/****************************************************************************
**
** Copyright (c) 2022 - 2023 Open Mobile Platform LLC.
** Copyright (c) 2015 - 2019 Jolla Ltd.
**
****************************************************************************/

import QtQuick 2.2
import QtQuick.Window 2.1 as QtQuick
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Lipstick 1.0

Private.Slideable {
    id: pannable

    property int switchOrientation: Qt.Horizontal
    property int orientation: QtQuick.Screen.primaryOrientation
    property int _effectiveOrientation
    onOrientationChanged: {
        if (!moving) {
            _effectiveOrientation = orientation
        }
    }

    flow: QtQuick.Screen.angleBetween(_effectiveOrientation, QtQuick.Screen.primaryOrientation)
          + (switchOrientation == Qt.Horizontal ? 0 : 90)

    property alias peekFilter: peekFilter

    onMovementEnded: {
        _effectiveOrientation = orientation
    }

    dragArea.states: [
        State {
            name: "leftPeek"
            when: (peekFilter.leftActive && !pannable._inverted)
                        || (peekFilter.rightActive && pannable._inverted)
            PropertyChanges {
                target: pannable
                absoluteProgress: peekFilter.absoluteProgress
            }
        }, State {
            name: "rightPeek"
            when: (peekFilter.leftActive && pannable._inverted)
                        || (peekFilter.rightActive && !pannable._inverted)
            PropertyChanges {
                target: pannable
                absoluteProgress: -peekFilter.absoluteProgress
            }
        }, State {
            name: "topPeek"
            when: (peekFilter.bottomActive && pannable._inverted)
                        || (peekFilter.topActive && !pannable._inverted)
            PropertyChanges {
                target: pannable
                absoluteProgress: peekFilter.absoluteProgress
            }
        }, State {
            name: "bottomPeek"
            when: (peekFilter.topActive && pannable._inverted)
                        || (peekFilter.bottomActive && !pannable._inverted)
            PropertyChanges {
                target: pannable
                absoluteProgress: -peekFilter.absoluteProgress
            }
        }
    ]

    PeekFilter {
        id: peekFilter

        leftEnabled: switchOrientation == Qt.Horizontal
        rightEnabled: switchOrientation == Qt.Horizontal
        topEnabled: switchOrientation == Qt.Vertical
        bottomEnabled: switchOrientation == Qt.Vertical
        objectName: "pannablePeekFilter"
    }
}
