/****************************************************************************************
**
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.6
import QtQuick.Window 2.2
import Sailfish.Lipstick 1.0
import org.nemomobile.configuration 1.0

DeclarativeLayerWindow {
    id: window

    readonly property int screenOrientation: Screen.orientation === Qt.PrimaryOrientation
                                             ? Screen.primaryOrientation
                                             : Screen.orientation

    // TODO: Workaround for topmostWindowOrientation from compositor.
    // The orientation of the homescreen does not match the orientation
    // of the screen sensors on phones.
    readonly property int homescreenOrientation: homescreenOrientationConfig.value
    ConfigurationValue {
        id: homescreenOrientationConfig

        // dialog_orientation is same as Lipstick.compositor.topmostWindowOrientation
        key: "/desktop/lipstick-jolla-home/dialog_orientation"
        defaultValue: Screen.primaryOrientation
    }
}
