/*
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

Label {
    id: root

    onFontChanged: metrics.update()
    onWidthChanged: metrics.update()
    onTextChanged: metrics.update()

    textFormat: Text.PlainText
    truncationMode: TruncationMode.Fade
    font.pixelSize: Theme.fontSizeTiny
    horizontalAlignment: implicitWidth > width ? Text.AlignLeft : Text.AlignHCenter

    TextMetrics {
        id: metrics

        property bool updating
        property font fontBuffer

        function update() {
            if (updating) {
                return
            }

            updating = true
            fontBuffer = root.font
            fontBuffer.letterSpacing = 0
            font = fontBuffer
            text = root.text
            root.font.letterSpacing = width > root.width ? -root.font.pixelSize * 0.02 : 0
            updating = false
        }
    }

    Component.onCompleted: metrics.update()
}
