/*
 * SPDX-FileCopyrightText: Copyright 2020-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 *
 * Copyright (c) 2014 - 2019 Jolla Ltd.
 *
 * License: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

ContactSelectDialog {
    id: pickerPage

    signal selectedRecipients(var contacts)

    function clearSelections() {
        contactSelectionModel.removeAllContacts()
    }

    ContactSelectionModel {
        id: contactSelectionModel
    }

    Connections {
        target: allContactsModel
        onRowsAboutToBeRemoved: {
            var selectedRows
            for (var i = first; i <= last; ++i) {
                selectedRows = contactSelectionModel.findContactId(allContactsModel.get(i, PeopleModel.ContactIdRole))
                for (var j = 0; j < selectedRows.length; j++) {
                    contactSelectionModel.removeContactAt(selectedRows[j])
                }
            }
        }
    }
}
