/*
 * SPDX-FileCopyrightText: Copyright 2022-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 *
 * Copyright (c) 2013 - 2019 Jolla Ltd.
 *
 * License: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

ContactsMultiSelectDialog {
    id: pickerDialog

    signal selectedRecipients(variant contacts)

    function clearSelections() {
        selectedContacts.removeAllContacts()
    }

    function disableSelections(recipients) {
        disabledContacts.removeAllContacts()

        var lastIndex = recipients.count - 2
        for (var i = 0; i <= lastIndex; i++) {
            if (recipients.get(i).person) {
                disabledContacts.addContact(recipients.get(i).person.id,
                                            recipients.get(i).property,
                                            recipients.get(i).propertyType,
                                            i !== lastIndex
                                            ? ContactSelectionModel.BatchMode
                                            : ContactSelectionModel.SingleContactMode)
            }
        }
    }

    useMaximumWidth: true

    acceptDestinationAction: PageStackAction.Pop
    // TODO pending contacts picker support:
    // dont allow selection of dups
    // deselect contacts removed from email editor
    onDone: {
        if (result == DialogResult.Accepted) {
            pickerDialog.selectedRecipients(selectedContacts)
        }
    }
}
