/*
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

MultiTypeFieldEditor {
    //: Add a website for this contact
    //% "Add website"
    fieldAdditionText: qsTrId("contacts-bt-contact_add_website")
    titleIconSource: "image://theme/icon-splus-website"

    propertyAccessor: 'websiteDetails'
    valueField: 'url'
    allowedTypes: [ Person.WebsiteType ]
    subTypesExclusive: true
    allowedSubTypes: {
        var subTypes = {}
        subTypes[Person.WebsiteType] = [
            Person.WebsiteSubTypeHomePage,
            Person.WebsiteSubTypeBlog,
            Person.WebsiteSubTypeFavorite
        ]
        return subTypes
    }

    inputMethodHints: Qt.ImhUrlCharactersOnly
    showTitleLabel: true
    titleLabelText: ContactsUtil.getNameForDetailType(Person.WebsiteType)
    showIconWhenEditing: false
}
