/*
 * SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.Telephony 1.0
import org.nemomobile.contacts 1.0

MultiTypeFieldEditor {
    //: Add a phone number for this contact
    //% "Add phone"
    fieldAdditionText: qsTrId("contacts-bt-contact_add_phone")
    fieldAdditionIcon: "image://theme/icon-splus-call"

    propertyAccessor: 'phoneDetails'
    valueField: 'number'
    allowedTypes: [ Person.PhoneNumberType ]
    subTypesExclusive: false
    allowedSubTypes: {
        var subTypes = {}
        subTypes[Person.PhoneNumberType] = [
            Person.PhoneSubTypeFax,
            Person.PhoneSubTypeMobile
        ]
        return subTypes
    }

    inputMethodHints: Qt.ImhDialableCharactersOnly
    prepopulate: true
    textFormatterCb: AsYouTypeFormatterUtil.getFormattedPhoneNumber
}
