/*
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import org.nemomobile.contacts 1.0

MultiTypeFieldEditor {
    //: Add an email for this contact
    //% "Add email"
    fieldAdditionText: qsTrId("contacts-bt-contact_add_email")
    fieldAdditionIcon: "image://theme/icon-splus-mail"

    propertyAccessor: 'emailDetails'
    valueField: 'address'
    allowedTypes: [ Person.EmailAddressType ]
    canChangeFieldType: false

    inputMethodHints: Qt.ImhEmailCharactersOnly
    prepopulate: true
}
