/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.0
import Sailfish.Silica 1.0
import org.nemomobile.contacts 1.0

ContextMenu {
    id: root

    property var model
    property int currentIndex: -1
    property int currentSubType: -1
    property bool _updating

    readonly property bool isLandscape: orientation & Orientation.LandscapeMask
    readonly property int menuWidth: root.isLandscape ? Screen.height : Screen.width

    signal subTypeClicked(int type, int subType)

    function _reload() {
        if (!_updating) {
            for (var i = 0; i < repeater.count; ++i) {
                if (repeater.model.get(i).subType === currentSubType) {
                    root._setHighlightedItem(repeater.itemAt(i))
                    root.currentIndex = i
                    return
                }
            }
        }
    }

    onCurrentSubTypeChanged: _reload()

    width: root.menuWidth - Theme.paddingMedium * 2

    Repeater {
        id: repeater

        model: root.model

        onCountChanged: root._reload()

        delegate: MenuItem {
            id: menuItem

            text: model.name

            onClicked: {
                if (model.subType !== root.currentSubType) {
                    _updating = true
                    root.currentIndex = model.index
                    _updating = false
                    root.subTypeClicked(model.type, model.subType)
                }
            }

            Component.onCompleted: {
                if (model.subType === root.currentSubType) {
                    root._setHighlightedItem(menuItem)
                    root.currentIndex = model.index
                }
            }
        }
    }
}
