/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

ContextMenu {
    id: root

    property int currentIndex: -1
    property int currentLabel: -1
    property int detailType: -1
    property bool _updating

    readonly property bool isLandscape: orientation & Orientation.LandscapeMask
    readonly property int menuWidth: root.isLandscape ? Screen.height : Screen.width

    signal labelClicked(int label)

    onCurrentLabelChanged: {
        if (!_updating) {
            for (var i = 0; i < repeater.count; ++i) {
                if (repeater.model[i] === currentLabel) {
                    root._setHighlightedItem(repeater.itemAt(i))
                    root.currentIndex = i
                    return
                }
            }
        }
    }

    width: root.menuWidth - Theme.paddingMedium * 2

    Repeater {
        id: repeater

        model: ContactsUtil.labels

        delegate: MenuItem {
            id: menuItem

            text: (modelData === Person.NoLabel)
                  ? ContactsUtil.getNoLabelText()
                  : ContactsUtil.getLabelNameForMenu(root.detailType, modelData)

            onClicked: {
                if (modelData !== root.currentLabel) {
                    _updating = true
                    root.currentIndex = model.index
                    _updating = false
                    root.labelClicked(modelData)
                }
            }

            Component.onCompleted: {
                if (modelData === root.currentLabel) {
                    root._setHighlightedItem(menuItem)
                    root.currentIndex = model.index
                }
            }
        }
    }
}
