/*
 * SPDX-FileCopyrightText: Copyright 2019-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 *
 * Copyright (c) 2019 Jolla Ltd.
 *
 * License: Proprietary
*/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

BaseEditor {
    id: root

    readonly property var _fields: [
        { "type": Person.CompanyType, "propertyName": "companyName", "persistent": true, "autoFillField": ContactDetailSuggestions.OrganizationName, "expandedProperty": false },
        { "type": Person.DepartmentType, "propertyName": "department", "persistent": false, "autoFillField": ContactDetailSuggestions.OrganizationDepartment, "expandedProperty": true },
        { "type": Person.TitleType, "propertyName": "title", "persistent": false, "autoFillField": ContactDetailSuggestions.OrganizationTitle, "expandedProperty": true },
        { "type": Person.RoleType, "propertyName": "role", "persistent": false, "autoFillField": ContactDetailSuggestions.OrganizationRole, "expandedProperty": true }
    ]

    function populateFieldEditor() {
        detailModel.clear()

        for (var i = 0; i < root._fields.length; i++) {
            var detail = root._fields[i]
            var value = contact[detail.propertyName]
            detailModel.append({
                                   "type": detail.type,
                                   "name": ContactsUtil.getNameForDetailType(detail.type),
                                   "propertyName": detail.propertyName,
                                   "autoFillField": detail.autoFillField,
                                   "value": value,
                                   "expandedProperty": detail.expandedProperty
                               })
        }
    }

    function aboutToSave() {
        detailModel.copySingleTypeDetailChanges(contact)
    }

    fieldDelegate: EditorFieldDelegate {
        editor: root
        leftMargin: 0
        rightMargin: Theme.paddingLarge
        icon.source: model.index === 0 ? "image://theme/icon-splus-company" : ""
        focus: root.initialFocusIndex === model.index
        height: !visible ? 0 : Theme.itemSizeMedium + ContactsUtil.__editorVerticalPadding
        expandedProperty: model.expandedProperty

        suggestionField: model.autoFillField

        onModified: root.detailModel.setProperty(model.index, "value", value)
    }
}
