/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Aurora.Controls 1.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0 as SailfishContacts
import org.nemomobile.contacts 1.0
import org.nemomobile.commhistory 1.0
import Nemo.DBus 2.0

import "../"

ContactCardSection {
    id: root

    property var _peopleModel: SailfishContacts.ContactModelCache.unfilteredModel()
    property Person _contact: contact
    property var _simManager: SailfishContacts.ContactCardUtils.simManager
 
    //% "Storage location"
    header: qsTrId("components_contacts-la-storage")

    fields: Repeater {
        model: modelData.sectionData

        delegate: ContactCardField {
            property var localContact

            width: parent.width
            mainText: addressBookInfo.name + (addressBookInfo.description ? " (" + addressBookInfo.description + ")" : "")
            mainIcon: addressBookInfo.iconUrl
            isContactStorageSection : true
            enabled: false
            cursorShape: Qt.ArrowCursor

            AddressBookDisplayInfo {
                id: addressBookInfo

                addressBook: localContact.addressBook
                simManager: _simManager
            }

            Component.onCompleted: {
                localContact = _peopleModel.personById(detailsValue)
                _simManager.simDescriptionSeparator = " \u2022 "
                _simManager.updateSimNames()
            }
        }
    }
}
