/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Aurora.Controls 1.0
import Sailfish.Silica 1.0
import Sailfish.Policy 1.0
import Sailfish.Telephony 1.0
import Sailfish.Contacts 1.0
import "numberutils.js" as NumberUtils

ContactCardSection {
    id: root

    header: qsTrId("components_contacts-la-contacts")

    property QtObject _messagesInterface

    function messagesInterface() {
        if (!_messagesInterface) {
            _messagesInterface = Qt.createQmlObject('import "../common"; MessagesInterface { }', root)
            if (!_messagesInterface)
                console.warn("ContactCardPage: Failed creating MessagesInterface instance")
        }

        return _messagesInterface
    }

    function startSms(number) {
        messagesInterface().startSMS(number)
    }

    fields: Repeater {
        model: modelData.sectionData

        delegate: ContactCardField {
            width: parent.width
            mainText: detailsValue
            secondText: detailsLabel
            mainIcon: detailsType === "phone"
                      ? "image://theme/icon-splus-answer?" + (highlighted ? Theme.highlightColor : Theme.primaryColor)
                      : detailsType === "email"
                        ? "image://theme/icon-splus-mail?" + (highlighted ? Theme.highlightColor : Theme.primaryColor)
                        : ""
            secondIcon: detailsType === "phone"
                        ? "image://theme/icon-splus-message?" + (highlighted ? Theme.highlightColor : Theme.primaryColor)
                        : ""

            actionsEnabled: detailsType === "phone" ? (!disablePhoneActions && !hidePhoneActions) : true
            secontIconEnabled: detailsType === "phone" ? (!disablePhoneActions && !hidePhoneActions) : true
            turnOffPolicy: detailsType === "phone" ? AccessPolicy.smsEnabled : true

            onContextMenuRequested: {
                detailContextMenu.clipboardText = detailsValue
                detailContextMenu.detailsOriginId = detailsOriginId
                detailContextMenu.detailsType = detailsType
                detailContextMenu.detailsIndex = detailsIndex
                detailContextMenu.open(this)
            }

            onClicked: {
                if (mouse.button != Qt.RightButton) {
                    if (detailsType === "phone") {
                        simMenu.openOnCurrentItem(this, NumberUtils.sanitizePhoneNumber(detailsValue))
                    } else if (detailsType === "email") {
                        URIOpener.openUri("mailto:" + detailsValue)
                    }
                }
            }

            onSecondIconClicked: {
                if (detailsType === "phone") {
                    if (AccessPolicy.smsEnabled) {
                        messagesInterface().startSMS(NumberUtils.sanitizePhoneNumber(detailsValue))
                    } else {
                        ContactsUtil.showSmsNotice()
                    }
                }
            }
        }
    }
}
