/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

import "../"

BackgroundItem {
    id: root

    readonly property real componentHeight: Theme.dp(100)
    property bool isAggregated
    property var person

    property alias mainText: mainLabel.text
    property alias secondText: secondLabel.text
    property bool actionsEnabled: true

    _backgroundColor: "transparent"
    highlighted: pressed || detailContextMenu.opened
    implicitHeight: root.componentHeight

    PersonAvatar {
        id: mainImage

        anchors {
            left: parent.left
            verticalCenter: parent.verticalCenter
        }

        width: Theme.dp(64)
        height: width
        enabled: root.actionsEnabled
        opacity: root.actionsEnabled ? 1.0 : Theme.opacityLow
        person: root.person
        highlighted: false
        _label.highlighted: false
    }

    Label {
        id: mainLabel

        anchors {
            left: mainImage.right
            leftMargin: Theme.paddingLarge
            right: parent.right
        }

        y: Theme.paddingMedium
        font.pixelSize: Theme.fontSizeMedium
        color: root.highlighted ? Theme.highlightColor : Theme.primaryColor
        truncationMode: TruncationMode.Fade
        opacity: mainImage.opacity
    }

    Label {
        id: secondLabel

        anchors {
            top: mainLabel.bottom
            topMargin: Theme.paddingMedium
            left: mainLabel.left
            right: mainLabel.right
        }

        font.pixelSize: Theme.fontSizeExtraSmall
        color: root.highlighted ? Theme.secondaryHighlightColor : Theme.secondaryColor
        truncationMode: TruncationMode.Fade
        opacity: mainImage.opacity
    }
}
