/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

Column {
    default property alias fields: content.data

    property alias header: headerLabel.text

    // Header
    Label {
        id: headerLabel

        anchors {
            left: parent.left
            right: parent.right
            margins: Theme.paddingMedium
        }

        height: Theme.dp(80)
        topPadding: Theme.dp(30)
        font.pixelSize: Theme.fontSizeSmall
        truncationMode: TruncationMode.Fade
        color: Theme.highlightColor
    }

    // Body
    Rectangle {
        width: parent.width
        height: childrenRect.height
        radius: Theme.dp(12)
        color: Theme.rgba(Theme.highlightColor, 0.1)

        Column {
            id: content

            anchors {
                left: parent.left
                right: parent.right
                margins: Theme.paddingLarge
            }

            topPadding: Theme.paddingLarge
            bottomPadding: Theme.paddingLarge
            spacing: Theme.paddingMedium
        }
    }
}
