/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Aurora.Controls 1.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0 as SailfishContacts
import org.nemomobile.contacts 1.0
import org.nemomobile.commhistory 1.0
import Nemo.DBus 2.0

import "../"

ContactCardSection {
    id: root

    //% "Aggregate contacts"
    header: qsTrId("components_contacts-la-aggregate")

    property QtObject _messagesInterface

    property var _peopleModel: SailfishContacts.ContactModelCache.unfilteredModel()
    property Person _contact: contact
    property bool _hidePhoneActions: hidePhoneActions
    property var _simManager: SailfishContacts.ContactCardUtils.simManager

    fields: Repeater {
        model: modelData.sectionData

        delegate: ContactCardStorage {
            property var localContact

            width: parent.width
            person: localContact
            mainText: localContact.displayLabel
            secondText: addressBookInfo.name + (addressBookInfo.description ? " (" + addressBookInfo.description + ")" : "")

            onClicked: {
                if (mouse.button != Qt.RightButton) {
                    pageStack.animatorPush("Sailfish.Contacts.ContactCardPage",
                                           {"contact": localContact})
                }
            }

            AddressBookDisplayInfo {
                id: addressBookInfo

                addressBook: localContact.addressBook
                simManager: _simManager
            }

            Component.onCompleted: {
                localContact = _peopleModel.personById(detailsValue)
                _simManager.simDescriptionSeparator = " \u2022 "
                _simManager.updateSimNames()
            }
        }
    }
}
