/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Aurora.Controls 1.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0 as SailfishContacts
import org.nemomobile.contacts 1.0
import Nemo.DBus 2.0

ContactCardSection {
    header: qsTrId("components_contacts-la-address")

    fields: Repeater {
        model: modelData.sectionData

        delegate: Column {
            width: parent.width
            spacing: 0

            property ListModel adressModel: ListModel {}

            Component.onCompleted: {
                if (!detailsData)
                    return

                if (detailsData.street)
                    adressModel.append({ "name": SailfishContacts.ContactsUtil.getDescriptionForDetail(Person.AddressType, Person.AddressStreetField),
                                           "value": detailsData.street})

                if (detailsData.city)
                    adressModel.append({ "name": SailfishContacts.ContactsUtil.getDescriptionForDetail(Person.AddressType, Person.AddressLocalityField),
                                           "value": detailsData.city})

                if (detailsData.region)
                    adressModel.append({ "name": SailfishContacts.ContactsUtil.getDescriptionForDetail(Person.AddressType, Person.AddressRegionField),
                                           "value": detailsData.region})

                if (detailsData.zipcode)
                    adressModel.append({ "name": SailfishContacts.ContactsUtil.getDescriptionForDetail(Person.AddressType, Person.AddressPostcodeField),
                                           "value": detailsData.zipcode})

                if (detailsData.country)
                    adressModel.append({ "name": SailfishContacts.ContactsUtil.getDescriptionForDetail(Person.AddressType, Person.AddressCountryField),
                                           "value": detailsData.country})

                if (detailsData.pobox)
                    adressModel.append({ "name": SailfishContacts.ContactsUtil.getDescriptionForDetail(Person.AddressType, Person.AddressPOBoxField),
                                           "value": detailsData.pobox})
            }

            ContactCardField {
                width: parent.width

                mainText: SailfishContacts.ContactsUtil.getNameForDetailType(Person.AddressType)
                secondText: detailsLabel
                mainIcon: "image://theme/icon-splus-location?" + (highlighted ? Theme.highlightColor : Theme.primaryColor)

                onContextMenuRequested: {
                    detailContextMenu.clipboardText = detailsValue
                    detailContextMenu.detailsOriginId = detailsOriginId
                    detailContextMenu.detailsType = detailsType
                    detailContextMenu.detailsIndex = detailsIndex
                    detailContextMenu.open(this)
                }

                onClicked: {
                    if(detailsData) {
                        mapsInterface.openAddress(detailsData["street"], detailsData["city"],
                                                  detailsData["region"], detailsData["zipcode"],
                                                  detailsData["country"])
                    }
                }
            }

            Repeater {
                model: adressModel

                ContactCardField {
                    width: parent.width
                    mainText: value
                    secondText: name

                    onContextMenuRequested: {
                        detailContextMenu.clipboardText = detailsValue
                        detailContextMenu.detailsOriginId = detailsOriginId
                        detailContextMenu.detailsType = detailsType
                        detailContextMenu.detailsIndex = detailsIndex
                        detailContextMenu.open(this)
                    }
                }
            }
        }
    }

    DBusInterface {
        id: mapsInterface

        service: "org.sailfishos.maps"
        path: "/"
        iface: "org.sailfishos.maps"

        function openAddress(street, city, region, zipcode, country) {
            call('openAddress', [street, city, region, zipcode, country])
        }
    }
}
