/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Aurora.Controls 1.0
import Sailfish.Silica 1.0
import org.nemomobile.contacts 1.0
import Nemo.DBus 2.0

ContactCardSection {
    header: qsTrId("components_contacts-la-additional")

    function iconForType(type) {
        if (type === "website")
            return "image://theme/icon-m-website?"

        if (type === "date")
            return "image://theme/icon-m-date?"

        if (type === "note")
            return "image://theme/icon-splus-note?"

        return ""
    }

    fields: Repeater {
        model: modelData.sectionData

        ContactCardField {
            width: parent.width

            mainText: detailsValue
            secondText: detailsLabel
            isNoteSection: detailsType === "note"
            mainIcon: iconForType(detailsType)
                      ? (iconForType(detailsType) + (highlighted ? Theme.highlightColor : Theme.primaryColor))
                      : ""

            onContextMenuRequested: {
                detailContextMenu.clipboardText = detailsValue
                detailContextMenu.detailsOriginId = detailsOriginId
                detailContextMenu.detailsType = detailsType
                detailContextMenu.detailsIndex = detailsIndex
                detailContextMenu.open(this)
            }

            onClicked: {
                if (mouse.button != Qt.RightButton) {
                    if (detailsType === "website") {
                        var url = detailsValue
                        var schemeSeparatorIndex = url.indexOf(':')
                        if (schemeSeparatorIndex <= 0 || schemeSeparatorIndex > 'https'.length) {
                            // Assume http
                            url = 'http://' + url
                        }

                        URIOpener.openUri(url)
                    } else if (detailsType === "date") {
                        var now = new Date()
                        var date = detailsData.date
                        var nextDate = new Date(now.getFullYear(), date.getMonth(), date.getDate())

                        if (new Date(now.getFullYear(), now.getMonth(), now.getDate()) > nextDate) {
                            nextDate.setFullYear(nextDate.getFullYear() + 1)
                        }

                        var formatted = Qt.formatDate(nextDate, Qt.ISODate)
                        calendarInterface.showDate(formatted)
                    }
                }
            }
        }
    }

    DBusInterface {
        id: calendarInterface

        service: "ru.auroraos.calendar.ui"
        path: "/ru/auroraos/calendar/ui"
        iface: "ru.auroraos.calendar.ui"

        function showDate(date) {
            call('viewDate', date)
        }
    }
}
