/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import Aurora.Controls 1.0
import Sailfish.Contacts 1.0

PopupSubMenuItem {
    id: root

    property alias contact: propertyModel.contact
    property alias disabledItems: propertyModel.disabledItems
    property alias requiredProperty: propertyModel.requiredProperty
    property alias propertyModel: repeater.model

    property var _propertyModel: ContactPropertyModel {
        id: propertyModel
    }

    signal propertySelected(var propertyData)

    Repeater {
        id: repeater

        model: root._propertyModel

        PopupMenuItem {
            text: model.displayLabel
            onClicked: root.propertySelected(propertyModel.get(model.index))
        }
    }
}
