/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

BackgroundItem {
    id: root

    property string description
    property alias icon: labelIcon.source
    property alias text: buttonText.text

    anchors.horizontalCenter: parent.horizontalCenter
    width: parent.width - Theme.horizontalPageMargin
    height: content.height + 2 * content.y
    _backgroundRadius: Theme.paddingMedium

    Column {
        id: content

        anchors.horizontalCenter: parent.horizontalCenter
        width: parent.width - Theme.horizontalPageMargin
        y: Theme.paddingMedium
        spacing: Theme.paddingSmall

        Loader {
            id: descriptionLoader

            width: parent.width
            active: root.description.length > 0
            sourceComponent: Label {
                id: descriptionLabel

                width: parent.width
                wrapMode: Text.WordWrap
                font.pixelSize: Theme.fontSizeExtraSmall
                text: root.description
            }
        }

        Row {
            width: parent.width
            spacing: Theme.paddingMedium
            x: -Theme.paddingMedium

            Icon {
                id: labelIcon

                anchors.verticalCenter: parent.verticalCenter
            }

            Label {
                id: buttonText

                anchors.verticalCenter: parent.verticalCenter
                width: parent.width - labelIcon.width
                wrapMode: Text.Wrap
            }
        }
    }
}
