/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import org.nemomobile.thumbnailer 1.0

RoundedItem {
    id: root

    property alias thumbnail: thumbnail

    readonly property bool hasSource: thumbnail.source.toString().length

    roundedCorners: root.hasSource

    Thumbnail {
        id: thumbnail

        anchors.fill: parent

        fillMode: Image.PreserveAspectFit
    }
}
