/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

RoundedItem {
    id: root

    property alias image: image

    readonly property bool hasSource: image.source.toString().length

    roundedCorners: root.hasSource

    Image {
        id: image

        anchors.centerIn: parent
        width: parent.width

        fillMode: Image.PreserveAspectFit
    }
}
