/*
 * SPDX-FileCopyrightText: Copyright 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0

Dialog {
    id: root

    property bool removeAllContacts
    property var person: null
    property var contactsToRemove: []

    Column {
        x: Theme.horizontalPageMargin
        width: parent.width - x * 2

        DialogHeader {
            //% "Remove"
            acceptText: qsTrId("components_contacts-he-dialog_remove")
        }

        Label {
            width: parent.width
            height: implicitHeight + Theme.paddingLarge
            color: Theme.primaryColor
            font.pixelSize: Theme.fontSizeExtraLarge
            wrapMode: Text.Wrap
            text: {
                if (removeAllContacts) {
                    //% "Accept removal of all contacts"
                    return qsTrId("components_contacts-la-remove_all")
                }

                if (root.person) {
                    const fullName = [
                        "primaryName",
                        "middleName",
                        "secondaryName"
                    ].reduce(
                        function(a, c) {
                            if (root.person[c]) {
                                a += root.person[c] + " "
                            }

                            return a
                        },
                        ""
                    ).trim()

                    //% "Are you sure you want to delete contact"
                    return qsTrId("components_contacts-la-remove_contact") + " " + fullName + "?"
                }

                //% "Are you sure you want to delete selected contacts (%n)?"
                return qsTrId("components_contacts-la-remove_contacts", contactsToRemove.length)
            }
        }

        Label {
            width: parent.width
            height: implicitHeight + Theme.paddingLarge
            color: Theme.rgba(Theme.primaryColor, Theme.opacityOverlay)
            wrapMode: Text.Wrap
            text: root.person
                    //% "This contact will be deleted without the possibility of recovery."
                  ? qsTrId("components_contacts-la-cant_undo_delete_contact")
                    //% "These contacts will be deleted without the possibility of recovery."
                  : qsTrId("components_contacts-la-cant_undo_delete_contacts")

        }
    }
}
