/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import org.nemomobile.contacts 1.0

Item {
    id: root

    /* required */ property Person person

    property alias _background: background
    property alias _icon: icon
    property alias _label: label
    property alias _image: image

    property bool isPersonValid: root.person != null && root.person.id > 0

    readonly property string avatarUrl: {
        if (root.person != null && typeof root.person !== 'string') {
            return person.avatarUrl
        }

        return ""
    }

    property bool isGroup
    property bool highlighted

    width: Theme.iconSizeMedium
    height: Theme.iconSizeMedium

    Rectangle {
        id: background

        anchors.fill: parent

        radius: width / 2
        color: Theme.rgba(Theme.primaryColor, 0.2)
    }

    HighlightImage {
        id: icon

        anchors.centerIn: parent
        highlighted: root.highlighted

        source: {
            if (root.isGroup) {
                return "image://theme/icon-splus-users"
            }

            if (!root.isPersonValid) {
                return "image://theme/icon-m-contact"
            }

            return ""
        }
    }

    Label {
        id: label

        anchors.centerIn: parent

        visible: !root.isGroup && root.isPersonValid

        text: {
            if (!root.isPersonValid) {
                return ""
            }

            const name = person.primaryName
            const secondaryName = person.secondaryName

            var buffer = ""

            buffer += name.length ? name[0].toUpperCase() : ""
            buffer += secondaryName.length ? secondaryName[0].toUpperCase() : ""

            return buffer
        }

        font.pixelSize: Theme.fontSizeSmall
    }

    RoundedImage {
        id: image

        anchors.fill: parent

        image.source: root.avatarUrl

        visible: image.hasSource && image.image.status !== Image.Error && !root.isGroup
    }
}
