/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import QtQuick.Layouts 1.1
import Sailfish.Silica 1.0
import Aurora.Applications.Internal 1.0 as AppInternal

AppInternal.LottiePlaceholder {
    id: root

    readonly property int contactsMode: 0
    readonly property int favoritedMode: 1
    property int mode: root.contactsMode

    property int contactsCount: 0

    signal createNewContact()
    signal importContacts()
    signal addContactToFavorites()

    label.text: [
        //% "You don't have contacts yet"
        qsTrId("components_contacts-la-no_contacts_yet"),

        //% "You don't have favorite contacts yet"
        qsTrId("components_contacts-mp-favorites_placeholder")
    ][root.mode] || ""

    lottie.source: Qt.resolvedUrl("Contacts.json")

    additionalContentItem: Loader {
        sourceComponent: [contactsModeComponent, favoriteModeComponent][root.mode]
    }

    Component {
        id: contactsModeComponent

        ColumnLayout {
            spacing: root.insideSectionSpacing

            Button {
                Layout.preferredWidth: Theme.buttonWidthLarge

                //% "Create a new contact"
                text: qsTrId("components_contacts-bt-create_new_contact")
                icon.source: "image://theme/icon-splus-add"
                onClicked: root.createNewContact()
            }

            Button {
                Layout.fillWidth: true

                //% "Import contacts"
                text: qsTrId("components_contacts-bt-import_contacts")
                icon.source: "image://theme/icon-splus-import-contacts"
                onClicked: root.importContacts()
            }
        }
    }

    Component {
        id: favoriteModeComponent

        ColumnLayout {
            spacing: root.insideSectionSpacing

            Button {
                Layout.preferredWidth: Theme.buttonWidthLarge

                //% "Add contact"
                text: qsTrId("components_contacts-mp-add_favorites")
                enabled: root.contactsCount > 0
                icon.source: "image://theme/icon-splus-add"
                onClicked: root.addContactToFavorites()
            }
        }
    }
}
