/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.6
import Sailfish.Silica 1.0
import MeeGo.Connman 0.2
import Aurora.Applications.Internal 1.0 as AppInternal

Item {
    id: root

    readonly property NetworkManagerFactory networkFactory: NetworkManagerFactory {}

    x: Theme.horizontalPageMargin
    width: parent.width - x * 2
    height: Theme.paddingLarge * 4 + placeholder.implicitHeight

    visible: root.networkFactory.instance.offlineMode

    AppInternal.ActionsPlaceholder {
        id: placeholder

        anchors.verticalCenter: parent.verticalCenter

        width: parent.width

        insideSectionSpacing: Theme.paddingLarge

        label {
            //% "These settings are not available in flight mode"
            text: qsTrId("components_contacts-la-not_available_in_flight_mode")
            color: Theme.highlightColor
            font.pixelSize: Theme.fontSizeLarge
        }

        additionalContentItem: Button {
            implicitWidth: Theme.buttonWidthLarge

            //% "Disable flight mode"
            text: qsTrId("components_contacts-la-disable_flightmode")

            onClicked: root.networkFactory.instance.offlineMode = false
        }
    }
}
