/*
 * SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

Dialog {
    id: root

    property PeopleModel peopleModel: PeopleModel {
        filterType: PeopleModel.FilterAll
    }

    property var newFavContacts: ({})

    readonly property bool isTablet: LayoutClassProvider.currentDisplayClass & DisplayLayoutClass.Tablet
    readonly property bool isPortrait: orientation & Orientation.PortraitMask
    readonly property real landscapeWidth: root.isPortrait ? root.width : Screen.width

    canAccept: peopleModel.count > 0

    ContactFavoriteModifier {
        id: favoriteModifier

        peopleModel: root.peopleModel
    }

    BackgroundItem {
        id: blockedContactsAndCalls

        anchors.fill: parent

        DialogHeader {
            id: header

            dialog: root
        }
        ContactBrowser {
            id: contactBrowser

            anchors {
                top: header.bottom
                bottom: parent.bottom
                horizontalCenter: parent.horizontalCenter
            }

            width: root.isTablet ? root.landscapeWidth : root.width
            contactView.anchors.topMargin: 0
            contactView.anchors.bottomMargin: 0
            clip: true
            showContacts: true
            searchActive: true
            showFavoriteContacts: false
            showRecentContacts: false
            searchableContactProperty: PeopleModel.AccountUriSearchable |
                                       PeopleModel.EmailAddressSearchable |
                                       PeopleModel.PhoneNumberSearchable |
                                       PeopleModel.OrganizationSearchable

            disableFavoritesContacts: true

            //: Displayed when there are no contacts
            //% "Add people"
            placeholderText: qsTrId("components_contacts-la-add_people")

            onContactClicked: {
                contactBrowser._activeDelegate.highlighted = !contactBrowser._activeDelegate.highlighted

                if (contactBrowser._activeDelegate.highlighted) {
                    var contact = peopleModel.personById(contactBrowser._activeDelegate.contactId)
                    newFavContacts[contactBrowser._activeDelegate.contactId] = contact
                } else {
                    delete newFavContacts[contactBrowser._activeDelegate.contactId]
                }
            }
        }
    }

    onAccepted: {
        var contacts = []

        for (var id in newFavContacts) {
            contacts.push(newFavContacts[id])
        }

        if (contacts.length > 0) favoriteModifier.setFavoriteStatus(contacts, true)
    }
}
