/*
 * SPDX-FileCopyrightText: Copyright 2022-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 *
 * Copyright (c) 2013 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

Dialog {
    id: root

    allowedOrientations: Orientation.All

    property ContactSelectionModel selectedContacts: contactBrowser.selectedContacts
    property ContactSelectionModel disabledContacts: contactBrowser.disabledContacts
    property alias requiredProperty: contactBrowser.requiredContactProperty
    property alias recentContactsCategoryMask: contactBrowser.recentContactsCategoryMask
    property alias searchActive: contactBrowser.searchActive
    property alias useMaximumWidth: contactBrowser.useMaximumWidth

    signal contactClicked(var contact, var property, string propertyType)

    function _propertySelected(contact, propertyData, contextMenu, propertyPicker) {
        root.contactClicked(contact, propertyData.property, propertyData.propertyType)
    }

    canAccept: selectedContacts.count > 0

    ContactBrowser {
        id: contactBrowser

        anchors.fill: parent
        canSelect: true
        searchActive: true

        pageHeader: DialogHeader {
            dialog: root
            acceptText: root.selectedContacts.count > 0
                          //: Indicates number of selected contacts
                          //% "Selected %n"
                        ? qsTrId("components_pickers-la-count_selected", root.selectedContacts.count)
                          //% "Select"
                        : qsTrId("components_contacts-la-select")
            spacing: 0
        }

        onContactClicked: {
            if (root.requiredProperty === PeopleModel.NoPropertyRequired) {
                root.contactClicked(contact, null, "")
            } else {
                contactBrowser.selectContactProperty(contact.id, root.requiredProperty, root._propertySelected)
            }
        }
    }
}
