/*
 * Copyright (c) 2020 - 2023 Open Mobile Platform LLC.
 * Copyright (c) 2013 - 2019 Jolla Pty Ltd.
 *
 * License: Proprietary
*/

import QtQuick 2.5
import Sailfish.Silica 1.0

DockedPanel {
    id: root

    property bool canBlock

    signal deleteClicked()
    signal shareClicked()
    signal blockClicked()

    width: parent.width
    height: Theme.itemSizeLarge
    dock: Dock.Bottom

    Image {
        anchors.fill: parent
        fillMode: Image.PreserveAspectFit
        source: "image://theme/graphic-gradient-edge"
    }

    Row {
        anchors.fill: parent

        IconButton {
            height: parent.height
            width: parent.width / 3
            icon.source: "image://theme/icon-m-block"
            visible: root.canBlock
            onClicked: {
                root.blockClicked()
            }
        }

        IconButton {
            height: parent.height
            width: root.canBlock ? parent.width / 3 : parent.width / 2
            icon.source: "image://theme/icon-m-share"
            onClicked: {
                root.shareClicked()
            }
        }

        IconButton {
            height: parent.height
            width: root.canBlock ? parent.width / 3 : parent.width / 2
            icon.source: "image://theme/icon-m-delete"

            onClicked: {
                root.deleteClicked()
            }
        }
    }
}
