/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

Page {
    id: root

    allowedOrientations: Orientation.All

    property alias allContactsModel: contactBrowser.allContactsModel
    property alias requiredProperty: contactBrowser.requiredContactProperty
    property alias recentContactsCategoryMask: contactBrowser.recentContactsCategoryMask
    property alias searchActive: contactBrowser.searchActive

    signal contactClicked(var contact, var property, string propertyType)

    function _propertySelected(contact, propertyData, contextMenu, propertyPicker) {
        root.contactClicked(contact, propertyData.property, propertyData.propertyType)
    }

    AppBar {
        id: appBar

        AppBarSearchField {
            id: searchField

            backgroundEnabled: true
            onTextChanged: {
                contactBrowser._searchPattern = text
                if (text.length === 0) {
                    searchField.forceActiveFocus()
                }
            }

            //% "Search"
            placeholderText: qsTrId("components_pickers-me-search")
        }
    }

    ContactBrowser {
        id: contactBrowser

        anchors {
            top: appBar.bottom
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }

        canSelect: false
        searchActive: true
        showContacts: true
        showFavoriteContacts: false
        showRecentContacts: false
        contactSearchFieldExtra: searchField

        onContactClicked: {
            if (root.requiredProperty === PeopleModel.NoPropertyRequired) {
                root.contactClicked(contact, null, "")
            } else {
                contactBrowser.selectContactProperty(contact.id, root.requiredProperty, root._propertySelected)
            }
        }
    }
}
