/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0
import org.nemomobile.contacts 1.0

Dialog {
    id: root

    property alias allContactsModel: contactBrowser.allContactsModel
    property alias requiredProperty: contactBrowser.requiredContactProperty
    property alias recentContactsCategoryMask: contactBrowser.recentContactsCategoryMask
    property alias searchActive: contactBrowser.searchActive

    signal contactClicked(var contact, var property, string propertyType)

    function _propertySelected(contact, propertyData, contextMenu, propertyPicker) {
        root.contactClicked(contact, propertyData.property, propertyData.propertyType)
    }

    allowedOrientations: Orientation.All
    canAccept: contactBrowser.selectedContacts.count === 1

    ContactBrowser {
        id: contactBrowser

        canSelect: true
        searchActive: true
        showContacts: true
        showFavoriteContacts: false
        showRecentContacts: false

        pageHeader: DialogHeader {
            dialog: root
            //% "Select"
            acceptText: qsTrId("components_contacts-la-select")
            spacing: 0
        }

        onContactClicked: {
            root.contactClicked(contact, null, "")
        }
    }
}
