/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

SearchField {
    id: root

    textLeftMargin: leftItem.width + leftItem.width / 2 - Theme.paddingMedium
    textRightMargin: 0

    //: Search contacts list
    //% "Search people"
    placeholderText: qsTrId("components_contacts-ph-search_people")

    // avoid removing focus whenever a contact is added to the selection list
    focusOutBehavior: FocusBehavior.KeepFocus

    autoScrollEnabled: false

    EnterKey.iconSource: "image://theme/icon-m-enter-close"
    EnterKey.onClicked: focus = false
}
