/*
 * Copyright (c) 2020 - 2023 Open Mobile Platform LLC.
 *
 * License: Proprietary
*/

import QtQuick 2.6
import Sailfish.Silica 1.0

QtObject {
    id: root

    property var peopleModel
    readonly property bool lastStatus: _pendingStatus
    readonly property bool lastStatusValid: _wasSet

    property bool _pendingStatus
    property bool _wasSet

    property var _contacts: []
    property var _fetchedFor: []
    property var _constituents: []

    function setFavoriteStatus(contacts, favorite) {
        _pendingStatus = favorite
        _wasSet = true
        _contacts = contacts

        for (var i = 0; i < _contacts.length; i++) {
            var contact = _contacts[i]
            if (!contact.addressBook.isAggregate) {
                _constituents.push(contact)
                _fetchedFor.push(contact.id)
                continue
            }
            contact.constituentsChanged.connect(appendConstituents)
            contact.fetchConstituents()
        }
    }

    function appendConstituents() {
        for (var i = 0; i < _contacts.length; i++) {
            var id = _contacts[i].id
            if (!constituentsFetched(id) && _contacts[i].constituents.length) {
                _constituents.push(_contacts[i].constituents)
                _fetchedFor.push(id)

                _contacts[i].constituentsChanged.disconnect(appendConstituents)
            }
        }

        if (_fetchedFor.length === _contacts.length)
            _applyFavoriteStatus(_constituents)

        _fetchedFor = []
        _constituents = []
    }

    function _applyFavoriteStatus(constituents) {
        var people = []
        for (var i = 0; i < constituents.length; i++) {
            var person = peopleModel.personById(constituents[i])
            person.favorite = _pendingStatus
            people.push(person)
        }
        if (!peopleModel.savePeople(people)) {
            console.warn("Unable to save favorite status to contacts:", constituents)
        }
    }

    function constituentsFetched(id) {
        for (var i = 0; i < _fetchedFor.length; i++) {
            if (_fetchedFor[i] === id)
                return true
        }
        return false
    }
}
