/*
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 *
 * Copyright (c) 2013 - 2018 Jolla Ltd.
 *
 * License: Proprietary
*/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Contacts 1.0
import Aurora.Controls 1.0
import org.nemomobile.contacts 1.0
import Aurora.Applications.Internal 1.0 as AppInternal

Page {
    id: root

    property int countContactsForRemoving
    property ContactsRemover remover
    property var rootPage

    backNavigation: false

    visible: !busyIndicator.failedPopAction

    function goToRootPage() {
        pageStack.pop(rootPage, PageStackAction.Immediate)
    }

    AppBar {
        id: appBar
        //% "Contacts deleting"
        headerText: qsTrId("components_contacts-la-deleting_contacts")
    }

    Label {
        id: header

        x: Theme.paddingLarge
        y: appBar.height + Theme.paddingLarge

        width: parent.width - x*2
        visible: !busyIndicator.running

        color: Theme.highlightColor
        font.pixelSize: Theme.fontSizeMedium
        wrapMode: Text.Wrap
        //% "Failed to delete contacts"
        text: qsTrId("components_contacts-la-failed_to_delete")
    }

    SilicaListView {
        id: constContactsView

        anchors {
            top: header.bottom
            topMargin: Theme.paddingLarge
            bottom: viewButton.top
            bottomMargin: Theme.paddingLarge
        }

        x: Theme.paddingLarge
        width: header.width
        visible: !busyIndicator.running
        spacing: Theme.paddingSmall
        clip: true
        quickScroll: true

        delegate: ListItem {
            _showPress: false
            down: false
              Label {
                  anchors {
                      rightMargin: Theme.paddingMedium
                      verticalCenter: parent.verticalCenter
                  }
                  width: Math.min(implicitWidth, constContactsView.width)
                  truncationMode: width == constContactsView.width ? TruncationMode.Fade : TruncationMode.None
                  textFormat: Text.StyledText
                  text: modelData
              }
          }
        VerticalScrollDecorator {}
    }

    BusyIndicator {
        id: busyIndicator

        property bool failedPopAction

        running: true
        anchors.centerIn: parent
        size: BusyIndicatorSize.Large
    }

    Button {
        id: viewButton

        anchors {
            bottom: parent.bottom
            bottomMargin: Theme.itemSizeMedium
            horizontalCenter: parent.horizontalCenter
        }
        visible: !busyIndicator.running

        //% "View all contacts"
        text: qsTrId("components_contacts-la-view_all_contact")

        Behavior on visible { FadeAnimation {} }

        onClicked: root.goToRootPage()
    }

    Connections {
        target: remover

        onRemovingFinished: {
            busyIndicator.running = false
            if (removedCount === countContactsForRemoving) {
                if (root.status === PageStatus.Active){
                    root.goToRootPage()
                } else {
                    busyIndicator.failedPopAction = true
                }
            } else {
                constContactsView.model = remover.getFailedContacts()
            }
        }
    }

    onStatusChanged: {
         if (busyIndicator.failedPopAction && status === PageStatus.Active){
             root.goToRootPage()
         }
     }
}
