/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

pragma Singleton

import QtQuick 2.0
import Sailfish.Telephony 1.0
import QOfono 0.2
import MeeGo.Connman 0.2

QtObject {
    property OfonoManager ofonoManager: OfonoManager { }

    property OfonoNetworkRegistration cellular1Status: OfonoNetworkRegistration {
        property bool disabled: status == ""
        property bool registered: status == "registered" || status == "roaming"

        modemPath: ofonoManager.modems[0] || ""
    }

    property OfonoNetworkRegistration cellular2Status: OfonoNetworkRegistration {
        property bool disabled: status == ""
        property bool registered: status == "registered" || status == "roaming"

        modemPath: ofonoManager.modems[1] || ""
    }

    property SimManager simManager: SimManager {
        id: _simManager
    }

    property NetworkManagerFactory network: NetworkManagerFactory {
        id: network

        property bool flightMode: instance.offlineMode
    }

    function instance () {} // Create singleton
}
