/*
* SPDX-FileCopyrightText: Copyright 2023-2025 Open Mobile Platform LLC <community@omp.ru>
* SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.6
import Sailfish.Silica 1.0

Item {
    id: avatar

    readonly property bool available: avatarImage.visible
    property var contact
    property bool unsavedContact
    property bool highlighted
    readonly property bool emailOnly: !!contact
            && contact.emailDetails.length > 0
            && contact.phoneDetails.length === 0
            && contact.addressDetails.length === 0
            && contact.accountDetails.length === 0
            && contact.websiteDetails.length === 0
    readonly property bool hasAvatar: !unsavedContact && !!avatar.contact && avatar.contact.avatarUrl != ""
    readonly property bool hasLabel: !!avatar.contact && avatarLabel.text.length > 0

    function getAbbreviation() {
        var abbreviation = ""
        if (contact && contact.id !== 0 && !avatar.hasAvatar && !avatar.emailOnly) {
            if (contact.primaryName.length > 0) {
                abbreviation += contact.primaryName.charAt(0).toUpperCase()
            }
            if (contact.secondaryName.length > 0) {
                abbreviation += contact.secondaryName.charAt(0).toUpperCase()
            }
        } else if (avatar.emailOnly) {
            if (contact.primaryName.length > 0) {
                abbreviation += contact.primaryName.charAt(0).toUpperCase()
            }
            if (contact.secondaryName.length > 0) {
                abbreviation += contact.secondaryName.charAt(0).toUpperCase()
            }
            if (abbreviation.length == 0) {
                abbreviation += contact.emailDetails.address.charAt(0).toUpperCase()
            }
        }
        return abbreviation
    }

    width: Theme.dp(180)
    height: width

    Rectangle {
        anchors.fill: parent
        color: avatar.highlighted ? Theme.rgba(Theme.highlightColor, Theme.opacityFaint)
                                  : Theme.rgba(Theme.primaryColor, Theme.opacityFaint)
        radius: width / 2
        visible: !avatar.hasAvatar && avatarLabel.text.length > 0 && !avatar.unsavedContact

        Label {
            id: avatarLabel

            anchors.centerIn: parent
            text: getAbbreviation()
            font.pixelSize: Theme.dp(62)
            color: avatar.highlighted ? Theme.highlightColor : Theme.primaryColor
            truncationMode: TruncationMode.Fade
            maximumLineCount: 1
            objectName: "label"
        }
    }

    RoundedImage {
        id: avatarImage

        anchors.centerIn: parent
        width: parent.width
        height: parent.width

        visible: avatar.hasAvatar || avatar.unsavedContact
        image.source: avatar.hasAvatar && !avatar.unsavedContact
                          ? avatar.contact.avatarUrl
                          : "image://theme/icon-l-contact"
    }
}
