/****************************************************************************************
**
** SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0
import Sailfish.Lipstick 1.0
import Aurora.AppActivity 1.0

Item {
    id: activityIndicator

    property int screenOrientation
    property real statusAreaRightMargin

    function colorActivity(type) {
        switch (type) {
        case AppActivityManager.activityCamera:
            return "#00B852"
        case AppActivityManager.activityMicrophone:
            return "#FE9500"
        case AppActivityManager.activityGeolocation:
            return "#0766F4"
        case AppActivityManager.activityScreen:
            return "#E30000"
        default:
            return "#000000"
        }
    }

    anchors {
        top: parent.top
        topMargin: Theme.dp(2)
        right: parent.right
        rightMargin: {
            var screenCorner = 0
            switch (screenOrientation) {
            case Qt.PortraitOrientation:
                screenCorner = ScreenCorners.topRight
                break
            case Qt.InvertedPortraitOrientation:
                screenCorner = ScreenCorners.bottomLeft
                break
            case Qt.LandscapeOrientation:
                screenCorner = ScreenCorners.topLeft
                break
            case Qt.InvertedLandscapeOrientation:
                screenCorner = ScreenCorners.bottomRight
                break
            }

            return Math.max(screenCorner, statusAreaRightMargin)
        }
    }

    width: Theme.dp(12) * AppActivityManager.activeNotificationsTypes.length
    height: Theme.dp(10)
    opacity: AppActivityManager.activeNotificationsTypes.length > 0 ? 1.0 : 0.0

    Row {
        spacing: Theme.dp(2)

        Repeater {
            model: AppActivityManager.activeNotificationsTypes
            delegate: Rectangle {
                width: Theme.dp(10)
                height: width
                radius: width * 0.5
                color: activityIndicator.colorActivity(modelData)

                Rectangle {
                    anchors.centerIn: parent
                    width: Theme.dp(8)
                    height: width
                    radius: width * 0.5
                    color: "transparent"
                    border.color: Theme.rgba("black", Theme.opacityFaint)
                    border.width: Theme.dp(1)
                }
            }
        }
    }

    Behavior on width {
        NumberAnimation {
            duration: 200
            easing.type: Easing.OutQuart
        }
    }

    Behavior on opacity { FadeAnimation {} }
}
