/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/protocol/http/nsIHttpChannelInternal.idl
 */

#ifndef __gen_nsIHttpChannelInternal_h__
#define __gen_nsIHttpChannelInternal_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsILoadInfo_h__
#include "nsILoadInfo.h"
#endif

#include "js/GCAnnotations.h"

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Assertions.h"
#include "mozilla/DebugOnly.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "nsStringFwd.h"
#include "nsTArrayForwardDeclare.h"
template<class T> class nsCOMArray;
namespace mozilla {
class TimeStamp;
}
class nsIAsyncInputStream; /* forward declaration */

class nsIAsyncOutputStream; /* forward declaration */

class nsIPrincipal; /* forward declaration */

class nsIProxyInfo; /* forward declaration */

class nsISecurityConsoleMessage; /* forward declaration */

class nsISocketTransport; /* forward declaration */

class nsIURI; /* forward declaration */


/* starting interface:    nsIHttpUpgradeListener */
#define NS_IHTTPUPGRADELISTENER_IID_STR "5b515449-ab64-4dba-b3cd-da8fc2f83064"

#define NS_IHTTPUPGRADELISTENER_IID \
  {0x5b515449, 0xab64, 0x4dba, \
    { 0xb3, 0xcd, 0xda, 0x8f, 0xc2, 0xf8, 0x30, 0x64 }}

class NS_NO_VTABLE nsIHttpUpgradeListener : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IHTTPUPGRADELISTENER_IID)

  /* [must_use] void onTransportAvailable (in nsISocketTransport aTransport, in nsIAsyncInputStream aSocketIn, in nsIAsyncOutputStream aSocketOut); */
  JS_HAZ_CAN_RUN_SCRIPT MOZ_MUST_USE NS_IMETHOD OnTransportAvailable(nsISocketTransport *aTransport, nsIAsyncInputStream *aSocketIn, nsIAsyncOutputStream *aSocketOut) = 0;

  /* [must_use] void onUpgradeFailed (in nsresult aErrorCode); */
  JS_HAZ_CAN_RUN_SCRIPT MOZ_MUST_USE NS_IMETHOD OnUpgradeFailed(nsresult aErrorCode) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIHttpUpgradeListener, NS_IHTTPUPGRADELISTENER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPUPGRADELISTENER \
  MOZ_MUST_USE NS_IMETHOD OnTransportAvailable(nsISocketTransport *aTransport, nsIAsyncInputStream *aSocketIn, nsIAsyncOutputStream *aSocketOut) override; \
  MOZ_MUST_USE NS_IMETHOD OnUpgradeFailed(nsresult aErrorCode) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIHTTPUPGRADELISTENER \
  MOZ_MUST_USE nsresult OnTransportAvailable(nsISocketTransport *aTransport, nsIAsyncInputStream *aSocketIn, nsIAsyncOutputStream *aSocketOut); \
  MOZ_MUST_USE nsresult OnUpgradeFailed(nsresult aErrorCode); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPUPGRADELISTENER(_to) \
  MOZ_MUST_USE NS_IMETHOD OnTransportAvailable(nsISocketTransport *aTransport, nsIAsyncInputStream *aSocketIn, nsIAsyncOutputStream *aSocketOut) override { return _to OnTransportAvailable(aTransport, aSocketIn, aSocketOut); } \
  MOZ_MUST_USE NS_IMETHOD OnUpgradeFailed(nsresult aErrorCode) override { return _to OnUpgradeFailed(aErrorCode); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPUPGRADELISTENER(_to) \
  MOZ_MUST_USE NS_IMETHOD OnTransportAvailable(nsISocketTransport *aTransport, nsIAsyncInputStream *aSocketIn, nsIAsyncOutputStream *aSocketOut) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnTransportAvailable(aTransport, aSocketIn, aSocketOut); } \
  MOZ_MUST_USE NS_IMETHOD OnUpgradeFailed(nsresult aErrorCode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnUpgradeFailed(aErrorCode); } 


/* starting interface:    nsIHttpChannelInternal */
#define NS_IHTTPCHANNELINTERNAL_IID_STR "4e28263d-1e03-46f4-aa5c-9512f91957f9"

#define NS_IHTTPCHANNELINTERNAL_IID \
  {0x4e28263d, 0x1e03, 0x46f4, \
    { 0xaa, 0x5c, 0x95, 0x12, 0xf9, 0x19, 0x57, 0xf9 }}

class NS_NO_VTABLE nsIHttpChannelInternal : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IHTTPCHANNELINTERNAL_IID)

  /* [must_use] attribute nsIURI documentURI; */
  MOZ_MUST_USE NS_IMETHOD GetDocumentURI(nsIURI **aDocumentURI) = 0;
  MOZ_MUST_USE NS_IMETHOD SetDocumentURI(nsIURI *aDocumentURI) = 0;

  /* [must_use] void getRequestVersion (out unsigned long major, out unsigned long minor); */
  MOZ_MUST_USE NS_IMETHOD GetRequestVersion(uint32_t *major, uint32_t *minor) = 0;

  /* [must_use] void getResponseVersion (out unsigned long major, out unsigned long minor); */
  MOZ_MUST_USE NS_IMETHOD GetResponseVersion(uint32_t *major, uint32_t *minor) = 0;

  /* [must_use,noscript] void takeAllSecurityMessages (in securityMessagesArray aMessages); */
  MOZ_MUST_USE NS_IMETHOD TakeAllSecurityMessages(nsCOMArray<nsISecurityConsoleMessage> & aMessages) = 0;

  /* [must_use] void setCookie (in ACString aCookieHeader); */
  MOZ_MUST_USE NS_IMETHOD SetCookie(const nsACString& aCookieHeader) = 0;

  /* [must_use] void setupFallbackChannel (in string aFallbackKey); */
  MOZ_MUST_USE NS_IMETHOD SetupFallbackChannel(const char * aFallbackKey) = 0;

  enum {
    THIRD_PARTY_FORCE_ALLOW = 1U
  };

  /* [must_use] attribute unsigned long thirdPartyFlags; */
  MOZ_MUST_USE NS_IMETHOD GetThirdPartyFlags(uint32_t *aThirdPartyFlags) = 0;
  MOZ_MUST_USE NS_IMETHOD SetThirdPartyFlags(uint32_t aThirdPartyFlags) = 0;

  /* [must_use] attribute boolean forceAllowThirdPartyCookie; */
  MOZ_MUST_USE NS_IMETHOD GetForceAllowThirdPartyCookie(bool *aForceAllowThirdPartyCookie) = 0;
  MOZ_MUST_USE NS_IMETHOD SetForceAllowThirdPartyCookie(bool aForceAllowThirdPartyCookie) = 0;

  /* [must_use] attribute boolean channelIsForDownload; */
  MOZ_MUST_USE NS_IMETHOD GetChannelIsForDownload(bool *aChannelIsForDownload) = 0;
  MOZ_MUST_USE NS_IMETHOD SetChannelIsForDownload(bool aChannelIsForDownload) = 0;

  /* [must_use] readonly attribute AUTF8String localAddress; */
  MOZ_MUST_USE NS_IMETHOD GetLocalAddress(nsACString& aLocalAddress) = 0;

  /* [must_use] readonly attribute int32_t localPort; */
  MOZ_MUST_USE NS_IMETHOD GetLocalPort(int32_t *aLocalPort) = 0;

  /* [must_use] readonly attribute AUTF8String remoteAddress; */
  MOZ_MUST_USE NS_IMETHOD GetRemoteAddress(nsACString& aRemoteAddress) = 0;

  /* [must_use] readonly attribute int32_t remotePort; */
  MOZ_MUST_USE NS_IMETHOD GetRemotePort(int32_t *aRemotePort) = 0;

  /* [must_use,noscript] void setCacheKeysRedirectChain (in StringArray cacheKeys); */
  MOZ_MUST_USE NS_IMETHOD SetCacheKeysRedirectChain(nsTArray<nsCString> * cacheKeys) = 0;

  /* [must_use] void HTTPUpgrade (in ACString aProtocolName, in nsIHttpUpgradeListener aListener); */
  MOZ_MUST_USE NS_IMETHOD HTTPUpgrade(const nsACString& aProtocolName, nsIHttpUpgradeListener *aListener) = 0;

  /* [must_use] void setConnectOnly (); */
  MOZ_MUST_USE NS_IMETHOD SetConnectOnly(void) = 0;

  /* [must_use] readonly attribute boolean onlyConnect; */
  MOZ_MUST_USE NS_IMETHOD GetOnlyConnect(bool *aOnlyConnect) = 0;

  /* [must_use] attribute boolean allowSpdy; */
  MOZ_MUST_USE NS_IMETHOD GetAllowSpdy(bool *aAllowSpdy) = 0;
  MOZ_MUST_USE NS_IMETHOD SetAllowSpdy(bool aAllowSpdy) = 0;

  /* [must_use] attribute boolean responseTimeoutEnabled; */
  MOZ_MUST_USE NS_IMETHOD GetResponseTimeoutEnabled(bool *aResponseTimeoutEnabled) = 0;
  MOZ_MUST_USE NS_IMETHOD SetResponseTimeoutEnabled(bool aResponseTimeoutEnabled) = 0;

  /* [must_use] attribute unsigned long initialRwin; */
  MOZ_MUST_USE NS_IMETHOD GetInitialRwin(uint32_t *aInitialRwin) = 0;
  MOZ_MUST_USE NS_IMETHOD SetInitialRwin(uint32_t aInitialRwin) = 0;

  /* [must_use] readonly attribute nsIURI apiRedirectToURI; */
  MOZ_MUST_USE NS_IMETHOD GetApiRedirectToURI(nsIURI **aApiRedirectToURI) = 0;

  /* [must_use] attribute boolean allowAltSvc; */
  MOZ_MUST_USE NS_IMETHOD GetAllowAltSvc(bool *aAllowAltSvc) = 0;
  MOZ_MUST_USE NS_IMETHOD SetAllowAltSvc(bool aAllowAltSvc) = 0;

  /* [must_use] attribute boolean beConservative; */
  MOZ_MUST_USE NS_IMETHOD GetBeConservative(bool *aBeConservative) = 0;
  MOZ_MUST_USE NS_IMETHOD SetBeConservative(bool aBeConservative) = 0;

  /* [must_use,noscript] attribute boolean isTRRServiceChannel; */
  MOZ_MUST_USE NS_IMETHOD GetIsTRRServiceChannel(bool *aIsTRRServiceChannel) = 0;
  MOZ_MUST_USE NS_IMETHOD SetIsTRRServiceChannel(bool aIsTRRServiceChannel) = 0;

  /* [must_use,noscript] readonly attribute boolean isResolvedByTRR; */
  MOZ_MUST_USE NS_IMETHOD GetIsResolvedByTRR(bool *aIsResolvedByTRR) = 0;

  /* [must_use] attribute unsigned long tlsFlags; */
  MOZ_MUST_USE NS_IMETHOD GetTlsFlags(uint32_t *aTlsFlags) = 0;
  MOZ_MUST_USE NS_IMETHOD SetTlsFlags(uint32_t aTlsFlags) = 0;

  /* [must_use] readonly attribute PRTime lastModifiedTime; */
  MOZ_MUST_USE NS_IMETHOD GetLastModifiedTime(PRTime *aLastModifiedTime) = 0;

  /* [must_use] attribute boolean corsIncludeCredentials; */
  MOZ_MUST_USE NS_IMETHOD GetCorsIncludeCredentials(bool *aCorsIncludeCredentials) = 0;
  MOZ_MUST_USE NS_IMETHOD SetCorsIncludeCredentials(bool aCorsIncludeCredentials) = 0;

  enum {
    CORS_MODE_SAME_ORIGIN = 0U,
    CORS_MODE_NO_CORS = 1U,
    CORS_MODE_CORS = 2U,
    CORS_MODE_NAVIGATE = 3U
  };

  /* [must_use] attribute unsigned long corsMode; */
  MOZ_MUST_USE NS_IMETHOD GetCorsMode(uint32_t *aCorsMode) = 0;
  MOZ_MUST_USE NS_IMETHOD SetCorsMode(uint32_t aCorsMode) = 0;

  enum {
    REDIRECT_MODE_FOLLOW = 0U,
    REDIRECT_MODE_ERROR = 1U,
    REDIRECT_MODE_MANUAL = 2U
  };

  /* [must_use] attribute unsigned long redirectMode; */
  MOZ_MUST_USE NS_IMETHOD GetRedirectMode(uint32_t *aRedirectMode) = 0;
  MOZ_MUST_USE NS_IMETHOD SetRedirectMode(uint32_t aRedirectMode) = 0;

  enum {
    FETCH_CACHE_MODE_DEFAULT = 0U,
    FETCH_CACHE_MODE_NO_STORE = 1U,
    FETCH_CACHE_MODE_RELOAD = 2U,
    FETCH_CACHE_MODE_NO_CACHE = 3U,
    FETCH_CACHE_MODE_FORCE_CACHE = 4U,
    FETCH_CACHE_MODE_ONLY_IF_CACHED = 5U
  };

  /* [must_use] attribute unsigned long fetchCacheMode; */
  MOZ_MUST_USE NS_IMETHOD GetFetchCacheMode(uint32_t *aFetchCacheMode) = 0;
  MOZ_MUST_USE NS_IMETHOD SetFetchCacheMode(uint32_t aFetchCacheMode) = 0;

  /* [must_use] readonly attribute nsIURI topWindowURI; */
  MOZ_MUST_USE NS_IMETHOD GetTopWindowURI(nsIURI **aTopWindowURI) = 0;

  /* [must_use] void setTopWindowURIIfUnknown (in nsIURI topWindowURI); */
  MOZ_MUST_USE NS_IMETHOD SetTopWindowURIIfUnknown(nsIURI *topWindowURI) = 0;

  /* [must_use] readonly attribute nsIURI proxyURI; */
  MOZ_MUST_USE NS_IMETHOD GetProxyURI(nsIURI **aProxyURI) = 0;

  /* [noscript,nostdcall,notxpcom] void setCorsPreflightParameters (in CStringArrayRef unsafeHeaders); */
  virtual void SetCorsPreflightParameters(const nsTArray<nsCString> & unsafeHeaders) = 0;

  /* [noscript,nostdcall,notxpcom] void setAltDataForChild (in boolean aIsForChild); */
  virtual void SetAltDataForChild(bool aIsForChild) = 0;

  /* [noscript,nostdcall,notxpcom] void disableAltDataCache (); */
  virtual void DisableAltDataCache(void) = 0;

  /* [infallible] attribute boolean blockAuthPrompt; */
  NS_IMETHOD GetBlockAuthPrompt(bool *aBlockAuthPrompt) = 0;
  inline bool GetBlockAuthPrompt()
  {
    bool result;
    mozilla::DebugOnly<nsresult> rv = GetBlockAuthPrompt(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }
  NS_IMETHOD SetBlockAuthPrompt(bool aBlockAuthPrompt) = 0;

  /* [must_use] attribute AString integrityMetadata; */
  MOZ_MUST_USE NS_IMETHOD GetIntegrityMetadata(nsAString& aIntegrityMetadata) = 0;
  MOZ_MUST_USE NS_IMETHOD SetIntegrityMetadata(const nsAString& aIntegrityMetadata) = 0;

  /* [must_use] readonly attribute ACString connectionInfoHashKey; */
  MOZ_MUST_USE NS_IMETHOD GetConnectionInfoHashKey(nsACString& aConnectionInfoHashKey) = 0;

  /* [infallible,noscript] attribute unsigned long lastRedirectFlags; */
  NS_IMETHOD GetLastRedirectFlags(uint32_t *aLastRedirectFlags) = 0;
  inline uint32_t GetLastRedirectFlags()
  {
    uint32_t result;
    mozilla::DebugOnly<nsresult> rv = GetLastRedirectFlags(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }
  NS_IMETHOD SetLastRedirectFlags(uint32_t aLastRedirectFlags) = 0;

  /* [noscript] attribute TimeStamp navigationStartTimeStamp; */
  NS_IMETHOD GetNavigationStartTimeStamp(mozilla::TimeStamp * aNavigationStartTimeStamp) = 0;
  NS_IMETHOD SetNavigationStartTimeStamp(mozilla::TimeStamp aNavigationStartTimeStamp) = 0;

  /* [noscript] void cancelByURLClassifier (in nsresult aErrorCode); */
  NS_IMETHOD CancelByURLClassifier(nsresult aErrorCode) = 0;

  /* [noscript,nostdcall,notxpcom] void setIPv4Disabled (); */
  virtual void SetIPv4Disabled(void) = 0;

  /* [noscript,nostdcall,notxpcom] void setIPv6Disabled (); */
  virtual void SetIPv6Disabled(void) = 0;

  /* readonly attribute nsILoadInfo_CrossOriginOpenerPolicy crossOriginOpenerPolicy; */
  NS_IMETHOD GetCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy *aCrossOriginOpenerPolicy) = 0;

  /* [noscript] nsILoadInfo_CrossOriginOpenerPolicy computeCrossOriginOpenerPolicy (in nsILoadInfo_CrossOriginOpenerPolicy aInitiatorPolicy); */
  NS_IMETHOD ComputeCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy aInitiatorPolicy, nsILoadInfo::CrossOriginOpenerPolicy *_retval) = 0;

  /* [noscript] bool hasCrossOriginOpenerPolicyMismatch (); */
  NS_IMETHOD HasCrossOriginOpenerPolicyMismatch(bool *_retval) = 0;

  /* [noscript] nsILoadInfo_CrossOriginEmbedderPolicy getResponseEmbedderPolicy (); */
  NS_IMETHOD GetResponseEmbedderPolicy(nsILoadInfo::CrossOriginEmbedderPolicy *_retval) = 0;

  /* [nostdcall,notxpcom] attribute boolean hasNonEmptySandboxingFlag; */
  virtual bool GetHasNonEmptySandboxingFlag() = 0;
  virtual void SetHasNonEmptySandboxingFlag(bool aHasNonEmptySandboxingFlag) = 0;

  /* [noscript,nostdcall,notxpcom] void DoDiagnosticAssertWhenOnStopNotCalledOnDestroy (); */
  virtual void DoDiagnosticAssertWhenOnStopNotCalledOnDestroy(void) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIHttpChannelInternal, NS_IHTTPCHANNELINTERNAL_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPCHANNELINTERNAL \
  MOZ_MUST_USE NS_IMETHOD GetDocumentURI(nsIURI **aDocumentURI) override; \
  MOZ_MUST_USE NS_IMETHOD SetDocumentURI(nsIURI *aDocumentURI) override; \
  MOZ_MUST_USE NS_IMETHOD GetRequestVersion(uint32_t *major, uint32_t *minor) override; \
  MOZ_MUST_USE NS_IMETHOD GetResponseVersion(uint32_t *major, uint32_t *minor) override; \
  MOZ_MUST_USE NS_IMETHOD TakeAllSecurityMessages(nsCOMArray<nsISecurityConsoleMessage> & aMessages) override; \
  MOZ_MUST_USE NS_IMETHOD SetCookie(const nsACString& aCookieHeader) override; \
  MOZ_MUST_USE NS_IMETHOD SetupFallbackChannel(const char * aFallbackKey) override; \
  MOZ_MUST_USE NS_IMETHOD GetThirdPartyFlags(uint32_t *aThirdPartyFlags) override; \
  MOZ_MUST_USE NS_IMETHOD SetThirdPartyFlags(uint32_t aThirdPartyFlags) override; \
  MOZ_MUST_USE NS_IMETHOD GetForceAllowThirdPartyCookie(bool *aForceAllowThirdPartyCookie) override; \
  MOZ_MUST_USE NS_IMETHOD SetForceAllowThirdPartyCookie(bool aForceAllowThirdPartyCookie) override; \
  MOZ_MUST_USE NS_IMETHOD GetChannelIsForDownload(bool *aChannelIsForDownload) override; \
  MOZ_MUST_USE NS_IMETHOD SetChannelIsForDownload(bool aChannelIsForDownload) override; \
  MOZ_MUST_USE NS_IMETHOD GetLocalAddress(nsACString& aLocalAddress) override; \
  MOZ_MUST_USE NS_IMETHOD GetLocalPort(int32_t *aLocalPort) override; \
  MOZ_MUST_USE NS_IMETHOD GetRemoteAddress(nsACString& aRemoteAddress) override; \
  MOZ_MUST_USE NS_IMETHOD GetRemotePort(int32_t *aRemotePort) override; \
  MOZ_MUST_USE NS_IMETHOD SetCacheKeysRedirectChain(nsTArray<nsCString> * cacheKeys) override; \
  MOZ_MUST_USE NS_IMETHOD HTTPUpgrade(const nsACString& aProtocolName, nsIHttpUpgradeListener *aListener) override; \
  MOZ_MUST_USE NS_IMETHOD SetConnectOnly(void) override; \
  MOZ_MUST_USE NS_IMETHOD GetOnlyConnect(bool *aOnlyConnect) override; \
  MOZ_MUST_USE NS_IMETHOD GetAllowSpdy(bool *aAllowSpdy) override; \
  MOZ_MUST_USE NS_IMETHOD SetAllowSpdy(bool aAllowSpdy) override; \
  MOZ_MUST_USE NS_IMETHOD GetResponseTimeoutEnabled(bool *aResponseTimeoutEnabled) override; \
  MOZ_MUST_USE NS_IMETHOD SetResponseTimeoutEnabled(bool aResponseTimeoutEnabled) override; \
  MOZ_MUST_USE NS_IMETHOD GetInitialRwin(uint32_t *aInitialRwin) override; \
  MOZ_MUST_USE NS_IMETHOD SetInitialRwin(uint32_t aInitialRwin) override; \
  MOZ_MUST_USE NS_IMETHOD GetApiRedirectToURI(nsIURI **aApiRedirectToURI) override; \
  MOZ_MUST_USE NS_IMETHOD GetAllowAltSvc(bool *aAllowAltSvc) override; \
  MOZ_MUST_USE NS_IMETHOD SetAllowAltSvc(bool aAllowAltSvc) override; \
  MOZ_MUST_USE NS_IMETHOD GetBeConservative(bool *aBeConservative) override; \
  MOZ_MUST_USE NS_IMETHOD SetBeConservative(bool aBeConservative) override; \
  MOZ_MUST_USE NS_IMETHOD GetIsTRRServiceChannel(bool *aIsTRRServiceChannel) override; \
  MOZ_MUST_USE NS_IMETHOD SetIsTRRServiceChannel(bool aIsTRRServiceChannel) override; \
  MOZ_MUST_USE NS_IMETHOD GetIsResolvedByTRR(bool *aIsResolvedByTRR) override; \
  MOZ_MUST_USE NS_IMETHOD GetTlsFlags(uint32_t *aTlsFlags) override; \
  MOZ_MUST_USE NS_IMETHOD SetTlsFlags(uint32_t aTlsFlags) override; \
  MOZ_MUST_USE NS_IMETHOD GetLastModifiedTime(PRTime *aLastModifiedTime) override; \
  MOZ_MUST_USE NS_IMETHOD GetCorsIncludeCredentials(bool *aCorsIncludeCredentials) override; \
  MOZ_MUST_USE NS_IMETHOD SetCorsIncludeCredentials(bool aCorsIncludeCredentials) override; \
  MOZ_MUST_USE NS_IMETHOD GetCorsMode(uint32_t *aCorsMode) override; \
  MOZ_MUST_USE NS_IMETHOD SetCorsMode(uint32_t aCorsMode) override; \
  MOZ_MUST_USE NS_IMETHOD GetRedirectMode(uint32_t *aRedirectMode) override; \
  MOZ_MUST_USE NS_IMETHOD SetRedirectMode(uint32_t aRedirectMode) override; \
  MOZ_MUST_USE NS_IMETHOD GetFetchCacheMode(uint32_t *aFetchCacheMode) override; \
  MOZ_MUST_USE NS_IMETHOD SetFetchCacheMode(uint32_t aFetchCacheMode) override; \
  MOZ_MUST_USE NS_IMETHOD GetTopWindowURI(nsIURI **aTopWindowURI) override; \
  MOZ_MUST_USE NS_IMETHOD SetTopWindowURIIfUnknown(nsIURI *topWindowURI) override; \
  MOZ_MUST_USE NS_IMETHOD GetProxyURI(nsIURI **aProxyURI) override; \
  virtual void SetCorsPreflightParameters(const nsTArray<nsCString> & unsafeHeaders) override; \
  virtual void SetAltDataForChild(bool aIsForChild) override; \
  virtual void DisableAltDataCache(void) override; \
  using nsIHttpChannelInternal::GetBlockAuthPrompt; \
  NS_IMETHOD GetBlockAuthPrompt(bool *aBlockAuthPrompt) override; \
  NS_IMETHOD SetBlockAuthPrompt(bool aBlockAuthPrompt) override; \
  MOZ_MUST_USE NS_IMETHOD GetIntegrityMetadata(nsAString& aIntegrityMetadata) override; \
  MOZ_MUST_USE NS_IMETHOD SetIntegrityMetadata(const nsAString& aIntegrityMetadata) override; \
  MOZ_MUST_USE NS_IMETHOD GetConnectionInfoHashKey(nsACString& aConnectionInfoHashKey) override; \
  using nsIHttpChannelInternal::GetLastRedirectFlags; \
  NS_IMETHOD GetLastRedirectFlags(uint32_t *aLastRedirectFlags) override; \
  NS_IMETHOD SetLastRedirectFlags(uint32_t aLastRedirectFlags) override; \
  NS_IMETHOD GetNavigationStartTimeStamp(mozilla::TimeStamp * aNavigationStartTimeStamp) override; \
  NS_IMETHOD SetNavigationStartTimeStamp(mozilla::TimeStamp aNavigationStartTimeStamp) override; \
  NS_IMETHOD CancelByURLClassifier(nsresult aErrorCode) override; \
  virtual void SetIPv4Disabled(void) override; \
  virtual void SetIPv6Disabled(void) override; \
  NS_IMETHOD GetCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy *aCrossOriginOpenerPolicy) override; \
  NS_IMETHOD ComputeCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy aInitiatorPolicy, nsILoadInfo::CrossOriginOpenerPolicy *_retval) override; \
  NS_IMETHOD HasCrossOriginOpenerPolicyMismatch(bool *_retval) override; \
  NS_IMETHOD GetResponseEmbedderPolicy(nsILoadInfo::CrossOriginEmbedderPolicy *_retval) override; \
  virtual bool GetHasNonEmptySandboxingFlag() override; \
  virtual void SetHasNonEmptySandboxingFlag(bool aHasNonEmptySandboxingFlag) override; \
  virtual void DoDiagnosticAssertWhenOnStopNotCalledOnDestroy(void) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIHTTPCHANNELINTERNAL \
  MOZ_MUST_USE nsresult GetDocumentURI(nsIURI **aDocumentURI); \
  MOZ_MUST_USE nsresult SetDocumentURI(nsIURI *aDocumentURI); \
  MOZ_MUST_USE nsresult GetRequestVersion(uint32_t *major, uint32_t *minor); \
  MOZ_MUST_USE nsresult GetResponseVersion(uint32_t *major, uint32_t *minor); \
  MOZ_MUST_USE nsresult TakeAllSecurityMessages(nsCOMArray<nsISecurityConsoleMessage> & aMessages); \
  MOZ_MUST_USE nsresult SetCookie(const nsACString& aCookieHeader); \
  MOZ_MUST_USE nsresult SetupFallbackChannel(const char * aFallbackKey); \
  MOZ_MUST_USE nsresult GetThirdPartyFlags(uint32_t *aThirdPartyFlags); \
  MOZ_MUST_USE nsresult SetThirdPartyFlags(uint32_t aThirdPartyFlags); \
  MOZ_MUST_USE nsresult GetForceAllowThirdPartyCookie(bool *aForceAllowThirdPartyCookie); \
  MOZ_MUST_USE nsresult SetForceAllowThirdPartyCookie(bool aForceAllowThirdPartyCookie); \
  MOZ_MUST_USE nsresult GetChannelIsForDownload(bool *aChannelIsForDownload); \
  MOZ_MUST_USE nsresult SetChannelIsForDownload(bool aChannelIsForDownload); \
  MOZ_MUST_USE nsresult GetLocalAddress(nsACString& aLocalAddress); \
  MOZ_MUST_USE nsresult GetLocalPort(int32_t *aLocalPort); \
  MOZ_MUST_USE nsresult GetRemoteAddress(nsACString& aRemoteAddress); \
  MOZ_MUST_USE nsresult GetRemotePort(int32_t *aRemotePort); \
  MOZ_MUST_USE nsresult SetCacheKeysRedirectChain(nsTArray<nsCString> * cacheKeys); \
  MOZ_MUST_USE nsresult HTTPUpgrade(const nsACString& aProtocolName, nsIHttpUpgradeListener *aListener); \
  MOZ_MUST_USE nsresult SetConnectOnly(void); \
  MOZ_MUST_USE nsresult GetOnlyConnect(bool *aOnlyConnect); \
  MOZ_MUST_USE nsresult GetAllowSpdy(bool *aAllowSpdy); \
  MOZ_MUST_USE nsresult SetAllowSpdy(bool aAllowSpdy); \
  MOZ_MUST_USE nsresult GetResponseTimeoutEnabled(bool *aResponseTimeoutEnabled); \
  MOZ_MUST_USE nsresult SetResponseTimeoutEnabled(bool aResponseTimeoutEnabled); \
  MOZ_MUST_USE nsresult GetInitialRwin(uint32_t *aInitialRwin); \
  MOZ_MUST_USE nsresult SetInitialRwin(uint32_t aInitialRwin); \
  MOZ_MUST_USE nsresult GetApiRedirectToURI(nsIURI **aApiRedirectToURI); \
  MOZ_MUST_USE nsresult GetAllowAltSvc(bool *aAllowAltSvc); \
  MOZ_MUST_USE nsresult SetAllowAltSvc(bool aAllowAltSvc); \
  MOZ_MUST_USE nsresult GetBeConservative(bool *aBeConservative); \
  MOZ_MUST_USE nsresult SetBeConservative(bool aBeConservative); \
  MOZ_MUST_USE nsresult GetIsTRRServiceChannel(bool *aIsTRRServiceChannel); \
  MOZ_MUST_USE nsresult SetIsTRRServiceChannel(bool aIsTRRServiceChannel); \
  MOZ_MUST_USE nsresult GetIsResolvedByTRR(bool *aIsResolvedByTRR); \
  MOZ_MUST_USE nsresult GetTlsFlags(uint32_t *aTlsFlags); \
  MOZ_MUST_USE nsresult SetTlsFlags(uint32_t aTlsFlags); \
  MOZ_MUST_USE nsresult GetLastModifiedTime(PRTime *aLastModifiedTime); \
  MOZ_MUST_USE nsresult GetCorsIncludeCredentials(bool *aCorsIncludeCredentials); \
  MOZ_MUST_USE nsresult SetCorsIncludeCredentials(bool aCorsIncludeCredentials); \
  MOZ_MUST_USE nsresult GetCorsMode(uint32_t *aCorsMode); \
  MOZ_MUST_USE nsresult SetCorsMode(uint32_t aCorsMode); \
  MOZ_MUST_USE nsresult GetRedirectMode(uint32_t *aRedirectMode); \
  MOZ_MUST_USE nsresult SetRedirectMode(uint32_t aRedirectMode); \
  MOZ_MUST_USE nsresult GetFetchCacheMode(uint32_t *aFetchCacheMode); \
  MOZ_MUST_USE nsresult SetFetchCacheMode(uint32_t aFetchCacheMode); \
  MOZ_MUST_USE nsresult GetTopWindowURI(nsIURI **aTopWindowURI); \
  MOZ_MUST_USE nsresult SetTopWindowURIIfUnknown(nsIURI *topWindowURI); \
  MOZ_MUST_USE nsresult GetProxyURI(nsIURI **aProxyURI); \
  void SetCorsPreflightParameters(const nsTArray<nsCString> & unsafeHeaders); \
  void SetAltDataForChild(bool aIsForChild); \
  void DisableAltDataCache(void); \
  using nsIHttpChannelInternal::GetBlockAuthPrompt; \
  nsresult GetBlockAuthPrompt(bool *aBlockAuthPrompt); \
  nsresult SetBlockAuthPrompt(bool aBlockAuthPrompt); \
  MOZ_MUST_USE nsresult GetIntegrityMetadata(nsAString& aIntegrityMetadata); \
  MOZ_MUST_USE nsresult SetIntegrityMetadata(const nsAString& aIntegrityMetadata); \
  MOZ_MUST_USE nsresult GetConnectionInfoHashKey(nsACString& aConnectionInfoHashKey); \
  using nsIHttpChannelInternal::GetLastRedirectFlags; \
  nsresult GetLastRedirectFlags(uint32_t *aLastRedirectFlags); \
  nsresult SetLastRedirectFlags(uint32_t aLastRedirectFlags); \
  nsresult GetNavigationStartTimeStamp(mozilla::TimeStamp * aNavigationStartTimeStamp); \
  nsresult SetNavigationStartTimeStamp(mozilla::TimeStamp aNavigationStartTimeStamp); \
  nsresult CancelByURLClassifier(nsresult aErrorCode); \
  void SetIPv4Disabled(void); \
  void SetIPv6Disabled(void); \
  nsresult GetCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy *aCrossOriginOpenerPolicy); \
  nsresult ComputeCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy aInitiatorPolicy, nsILoadInfo::CrossOriginOpenerPolicy *_retval); \
  nsresult HasCrossOriginOpenerPolicyMismatch(bool *_retval); \
  nsresult GetResponseEmbedderPolicy(nsILoadInfo::CrossOriginEmbedderPolicy *_retval); \
  bool GetHasNonEmptySandboxingFlag(); \
  void SetHasNonEmptySandboxingFlag(bool aHasNonEmptySandboxingFlag); \
  void DoDiagnosticAssertWhenOnStopNotCalledOnDestroy(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPCHANNELINTERNAL(_to) \
  MOZ_MUST_USE NS_IMETHOD GetDocumentURI(nsIURI **aDocumentURI) override { return _to GetDocumentURI(aDocumentURI); } \
  MOZ_MUST_USE NS_IMETHOD SetDocumentURI(nsIURI *aDocumentURI) override { return _to SetDocumentURI(aDocumentURI); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestVersion(uint32_t *major, uint32_t *minor) override { return _to GetRequestVersion(major, minor); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseVersion(uint32_t *major, uint32_t *minor) override { return _to GetResponseVersion(major, minor); } \
  MOZ_MUST_USE NS_IMETHOD TakeAllSecurityMessages(nsCOMArray<nsISecurityConsoleMessage> & aMessages) override { return _to TakeAllSecurityMessages(aMessages); } \
  MOZ_MUST_USE NS_IMETHOD SetCookie(const nsACString& aCookieHeader) override { return _to SetCookie(aCookieHeader); } \
  MOZ_MUST_USE NS_IMETHOD SetupFallbackChannel(const char * aFallbackKey) override { return _to SetupFallbackChannel(aFallbackKey); } \
  MOZ_MUST_USE NS_IMETHOD GetThirdPartyFlags(uint32_t *aThirdPartyFlags) override { return _to GetThirdPartyFlags(aThirdPartyFlags); } \
  MOZ_MUST_USE NS_IMETHOD SetThirdPartyFlags(uint32_t aThirdPartyFlags) override { return _to SetThirdPartyFlags(aThirdPartyFlags); } \
  MOZ_MUST_USE NS_IMETHOD GetForceAllowThirdPartyCookie(bool *aForceAllowThirdPartyCookie) override { return _to GetForceAllowThirdPartyCookie(aForceAllowThirdPartyCookie); } \
  MOZ_MUST_USE NS_IMETHOD SetForceAllowThirdPartyCookie(bool aForceAllowThirdPartyCookie) override { return _to SetForceAllowThirdPartyCookie(aForceAllowThirdPartyCookie); } \
  MOZ_MUST_USE NS_IMETHOD GetChannelIsForDownload(bool *aChannelIsForDownload) override { return _to GetChannelIsForDownload(aChannelIsForDownload); } \
  MOZ_MUST_USE NS_IMETHOD SetChannelIsForDownload(bool aChannelIsForDownload) override { return _to SetChannelIsForDownload(aChannelIsForDownload); } \
  MOZ_MUST_USE NS_IMETHOD GetLocalAddress(nsACString& aLocalAddress) override { return _to GetLocalAddress(aLocalAddress); } \
  MOZ_MUST_USE NS_IMETHOD GetLocalPort(int32_t *aLocalPort) override { return _to GetLocalPort(aLocalPort); } \
  MOZ_MUST_USE NS_IMETHOD GetRemoteAddress(nsACString& aRemoteAddress) override { return _to GetRemoteAddress(aRemoteAddress); } \
  MOZ_MUST_USE NS_IMETHOD GetRemotePort(int32_t *aRemotePort) override { return _to GetRemotePort(aRemotePort); } \
  MOZ_MUST_USE NS_IMETHOD SetCacheKeysRedirectChain(nsTArray<nsCString> * cacheKeys) override { return _to SetCacheKeysRedirectChain(cacheKeys); } \
  MOZ_MUST_USE NS_IMETHOD HTTPUpgrade(const nsACString& aProtocolName, nsIHttpUpgradeListener *aListener) override { return _to HTTPUpgrade(aProtocolName, aListener); } \
  MOZ_MUST_USE NS_IMETHOD SetConnectOnly(void) override { return _to SetConnectOnly(); } \
  MOZ_MUST_USE NS_IMETHOD GetOnlyConnect(bool *aOnlyConnect) override { return _to GetOnlyConnect(aOnlyConnect); } \
  MOZ_MUST_USE NS_IMETHOD GetAllowSpdy(bool *aAllowSpdy) override { return _to GetAllowSpdy(aAllowSpdy); } \
  MOZ_MUST_USE NS_IMETHOD SetAllowSpdy(bool aAllowSpdy) override { return _to SetAllowSpdy(aAllowSpdy); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseTimeoutEnabled(bool *aResponseTimeoutEnabled) override { return _to GetResponseTimeoutEnabled(aResponseTimeoutEnabled); } \
  MOZ_MUST_USE NS_IMETHOD SetResponseTimeoutEnabled(bool aResponseTimeoutEnabled) override { return _to SetResponseTimeoutEnabled(aResponseTimeoutEnabled); } \
  MOZ_MUST_USE NS_IMETHOD GetInitialRwin(uint32_t *aInitialRwin) override { return _to GetInitialRwin(aInitialRwin); } \
  MOZ_MUST_USE NS_IMETHOD SetInitialRwin(uint32_t aInitialRwin) override { return _to SetInitialRwin(aInitialRwin); } \
  MOZ_MUST_USE NS_IMETHOD GetApiRedirectToURI(nsIURI **aApiRedirectToURI) override { return _to GetApiRedirectToURI(aApiRedirectToURI); } \
  MOZ_MUST_USE NS_IMETHOD GetAllowAltSvc(bool *aAllowAltSvc) override { return _to GetAllowAltSvc(aAllowAltSvc); } \
  MOZ_MUST_USE NS_IMETHOD SetAllowAltSvc(bool aAllowAltSvc) override { return _to SetAllowAltSvc(aAllowAltSvc); } \
  MOZ_MUST_USE NS_IMETHOD GetBeConservative(bool *aBeConservative) override { return _to GetBeConservative(aBeConservative); } \
  MOZ_MUST_USE NS_IMETHOD SetBeConservative(bool aBeConservative) override { return _to SetBeConservative(aBeConservative); } \
  MOZ_MUST_USE NS_IMETHOD GetIsTRRServiceChannel(bool *aIsTRRServiceChannel) override { return _to GetIsTRRServiceChannel(aIsTRRServiceChannel); } \
  MOZ_MUST_USE NS_IMETHOD SetIsTRRServiceChannel(bool aIsTRRServiceChannel) override { return _to SetIsTRRServiceChannel(aIsTRRServiceChannel); } \
  MOZ_MUST_USE NS_IMETHOD GetIsResolvedByTRR(bool *aIsResolvedByTRR) override { return _to GetIsResolvedByTRR(aIsResolvedByTRR); } \
  MOZ_MUST_USE NS_IMETHOD GetTlsFlags(uint32_t *aTlsFlags) override { return _to GetTlsFlags(aTlsFlags); } \
  MOZ_MUST_USE NS_IMETHOD SetTlsFlags(uint32_t aTlsFlags) override { return _to SetTlsFlags(aTlsFlags); } \
  MOZ_MUST_USE NS_IMETHOD GetLastModifiedTime(PRTime *aLastModifiedTime) override { return _to GetLastModifiedTime(aLastModifiedTime); } \
  MOZ_MUST_USE NS_IMETHOD GetCorsIncludeCredentials(bool *aCorsIncludeCredentials) override { return _to GetCorsIncludeCredentials(aCorsIncludeCredentials); } \
  MOZ_MUST_USE NS_IMETHOD SetCorsIncludeCredentials(bool aCorsIncludeCredentials) override { return _to SetCorsIncludeCredentials(aCorsIncludeCredentials); } \
  MOZ_MUST_USE NS_IMETHOD GetCorsMode(uint32_t *aCorsMode) override { return _to GetCorsMode(aCorsMode); } \
  MOZ_MUST_USE NS_IMETHOD SetCorsMode(uint32_t aCorsMode) override { return _to SetCorsMode(aCorsMode); } \
  MOZ_MUST_USE NS_IMETHOD GetRedirectMode(uint32_t *aRedirectMode) override { return _to GetRedirectMode(aRedirectMode); } \
  MOZ_MUST_USE NS_IMETHOD SetRedirectMode(uint32_t aRedirectMode) override { return _to SetRedirectMode(aRedirectMode); } \
  MOZ_MUST_USE NS_IMETHOD GetFetchCacheMode(uint32_t *aFetchCacheMode) override { return _to GetFetchCacheMode(aFetchCacheMode); } \
  MOZ_MUST_USE NS_IMETHOD SetFetchCacheMode(uint32_t aFetchCacheMode) override { return _to SetFetchCacheMode(aFetchCacheMode); } \
  MOZ_MUST_USE NS_IMETHOD GetTopWindowURI(nsIURI **aTopWindowURI) override { return _to GetTopWindowURI(aTopWindowURI); } \
  MOZ_MUST_USE NS_IMETHOD SetTopWindowURIIfUnknown(nsIURI *topWindowURI) override { return _to SetTopWindowURIIfUnknown(topWindowURI); } \
  MOZ_MUST_USE NS_IMETHOD GetProxyURI(nsIURI **aProxyURI) override { return _to GetProxyURI(aProxyURI); } \
  virtual void SetCorsPreflightParameters(const nsTArray<nsCString> & unsafeHeaders) override { return _to SetCorsPreflightParameters(unsafeHeaders); } \
  virtual void SetAltDataForChild(bool aIsForChild) override { return _to SetAltDataForChild(aIsForChild); } \
  virtual void DisableAltDataCache(void) override { return _to DisableAltDataCache(); } \
  using nsIHttpChannelInternal::GetBlockAuthPrompt; \
  NS_IMETHOD GetBlockAuthPrompt(bool *aBlockAuthPrompt) override { return _to GetBlockAuthPrompt(aBlockAuthPrompt); } \
  NS_IMETHOD SetBlockAuthPrompt(bool aBlockAuthPrompt) override { return _to SetBlockAuthPrompt(aBlockAuthPrompt); } \
  MOZ_MUST_USE NS_IMETHOD GetIntegrityMetadata(nsAString& aIntegrityMetadata) override { return _to GetIntegrityMetadata(aIntegrityMetadata); } \
  MOZ_MUST_USE NS_IMETHOD SetIntegrityMetadata(const nsAString& aIntegrityMetadata) override { return _to SetIntegrityMetadata(aIntegrityMetadata); } \
  MOZ_MUST_USE NS_IMETHOD GetConnectionInfoHashKey(nsACString& aConnectionInfoHashKey) override { return _to GetConnectionInfoHashKey(aConnectionInfoHashKey); } \
  using nsIHttpChannelInternal::GetLastRedirectFlags; \
  NS_IMETHOD GetLastRedirectFlags(uint32_t *aLastRedirectFlags) override { return _to GetLastRedirectFlags(aLastRedirectFlags); } \
  NS_IMETHOD SetLastRedirectFlags(uint32_t aLastRedirectFlags) override { return _to SetLastRedirectFlags(aLastRedirectFlags); } \
  NS_IMETHOD GetNavigationStartTimeStamp(mozilla::TimeStamp * aNavigationStartTimeStamp) override { return _to GetNavigationStartTimeStamp(aNavigationStartTimeStamp); } \
  NS_IMETHOD SetNavigationStartTimeStamp(mozilla::TimeStamp aNavigationStartTimeStamp) override { return _to SetNavigationStartTimeStamp(aNavigationStartTimeStamp); } \
  NS_IMETHOD CancelByURLClassifier(nsresult aErrorCode) override { return _to CancelByURLClassifier(aErrorCode); } \
  virtual void SetIPv4Disabled(void) override { return _to SetIPv4Disabled(); } \
  virtual void SetIPv6Disabled(void) override { return _to SetIPv6Disabled(); } \
  NS_IMETHOD GetCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy *aCrossOriginOpenerPolicy) override { return _to GetCrossOriginOpenerPolicy(aCrossOriginOpenerPolicy); } \
  NS_IMETHOD ComputeCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy aInitiatorPolicy, nsILoadInfo::CrossOriginOpenerPolicy *_retval) override { return _to ComputeCrossOriginOpenerPolicy(aInitiatorPolicy, _retval); } \
  NS_IMETHOD HasCrossOriginOpenerPolicyMismatch(bool *_retval) override { return _to HasCrossOriginOpenerPolicyMismatch(_retval); } \
  NS_IMETHOD GetResponseEmbedderPolicy(nsILoadInfo::CrossOriginEmbedderPolicy *_retval) override { return _to GetResponseEmbedderPolicy(_retval); } \
  virtual bool GetHasNonEmptySandboxingFlag() override { return _to GetHasNonEmptySandboxingFlag(); } \
  virtual void SetHasNonEmptySandboxingFlag(bool aHasNonEmptySandboxingFlag) override { return _to SetHasNonEmptySandboxingFlag(aHasNonEmptySandboxingFlag); } \
  virtual void DoDiagnosticAssertWhenOnStopNotCalledOnDestroy(void) override { return _to DoDiagnosticAssertWhenOnStopNotCalledOnDestroy(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPCHANNELINTERNAL(_to) \
  MOZ_MUST_USE NS_IMETHOD GetDocumentURI(nsIURI **aDocumentURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentURI(aDocumentURI); } \
  MOZ_MUST_USE NS_IMETHOD SetDocumentURI(nsIURI *aDocumentURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentURI(aDocumentURI); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestVersion(uint32_t *major, uint32_t *minor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestVersion(major, minor); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseVersion(uint32_t *major, uint32_t *minor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseVersion(major, minor); } \
  MOZ_MUST_USE NS_IMETHOD TakeAllSecurityMessages(nsCOMArray<nsISecurityConsoleMessage> & aMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->TakeAllSecurityMessages(aMessages); } \
  MOZ_MUST_USE NS_IMETHOD SetCookie(const nsACString& aCookieHeader) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCookie(aCookieHeader); } \
  MOZ_MUST_USE NS_IMETHOD SetupFallbackChannel(const char * aFallbackKey) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetupFallbackChannel(aFallbackKey); } \
  MOZ_MUST_USE NS_IMETHOD GetThirdPartyFlags(uint32_t *aThirdPartyFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetThirdPartyFlags(aThirdPartyFlags); } \
  MOZ_MUST_USE NS_IMETHOD SetThirdPartyFlags(uint32_t aThirdPartyFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetThirdPartyFlags(aThirdPartyFlags); } \
  MOZ_MUST_USE NS_IMETHOD GetForceAllowThirdPartyCookie(bool *aForceAllowThirdPartyCookie) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetForceAllowThirdPartyCookie(aForceAllowThirdPartyCookie); } \
  MOZ_MUST_USE NS_IMETHOD SetForceAllowThirdPartyCookie(bool aForceAllowThirdPartyCookie) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetForceAllowThirdPartyCookie(aForceAllowThirdPartyCookie); } \
  MOZ_MUST_USE NS_IMETHOD GetChannelIsForDownload(bool *aChannelIsForDownload) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChannelIsForDownload(aChannelIsForDownload); } \
  MOZ_MUST_USE NS_IMETHOD SetChannelIsForDownload(bool aChannelIsForDownload) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetChannelIsForDownload(aChannelIsForDownload); } \
  MOZ_MUST_USE NS_IMETHOD GetLocalAddress(nsACString& aLocalAddress) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocalAddress(aLocalAddress); } \
  MOZ_MUST_USE NS_IMETHOD GetLocalPort(int32_t *aLocalPort) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocalPort(aLocalPort); } \
  MOZ_MUST_USE NS_IMETHOD GetRemoteAddress(nsACString& aRemoteAddress) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRemoteAddress(aRemoteAddress); } \
  MOZ_MUST_USE NS_IMETHOD GetRemotePort(int32_t *aRemotePort) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRemotePort(aRemotePort); } \
  MOZ_MUST_USE NS_IMETHOD SetCacheKeysRedirectChain(nsTArray<nsCString> * cacheKeys) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCacheKeysRedirectChain(cacheKeys); } \
  MOZ_MUST_USE NS_IMETHOD HTTPUpgrade(const nsACString& aProtocolName, nsIHttpUpgradeListener *aListener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->HTTPUpgrade(aProtocolName, aListener); } \
  MOZ_MUST_USE NS_IMETHOD SetConnectOnly(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetConnectOnly(); } \
  MOZ_MUST_USE NS_IMETHOD GetOnlyConnect(bool *aOnlyConnect) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOnlyConnect(aOnlyConnect); } \
  MOZ_MUST_USE NS_IMETHOD GetAllowSpdy(bool *aAllowSpdy) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowSpdy(aAllowSpdy); } \
  MOZ_MUST_USE NS_IMETHOD SetAllowSpdy(bool aAllowSpdy) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowSpdy(aAllowSpdy); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseTimeoutEnabled(bool *aResponseTimeoutEnabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseTimeoutEnabled(aResponseTimeoutEnabled); } \
  MOZ_MUST_USE NS_IMETHOD SetResponseTimeoutEnabled(bool aResponseTimeoutEnabled) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetResponseTimeoutEnabled(aResponseTimeoutEnabled); } \
  MOZ_MUST_USE NS_IMETHOD GetInitialRwin(uint32_t *aInitialRwin) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInitialRwin(aInitialRwin); } \
  MOZ_MUST_USE NS_IMETHOD SetInitialRwin(uint32_t aInitialRwin) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetInitialRwin(aInitialRwin); } \
  MOZ_MUST_USE NS_IMETHOD GetApiRedirectToURI(nsIURI **aApiRedirectToURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetApiRedirectToURI(aApiRedirectToURI); } \
  MOZ_MUST_USE NS_IMETHOD GetAllowAltSvc(bool *aAllowAltSvc) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowAltSvc(aAllowAltSvc); } \
  MOZ_MUST_USE NS_IMETHOD SetAllowAltSvc(bool aAllowAltSvc) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowAltSvc(aAllowAltSvc); } \
  MOZ_MUST_USE NS_IMETHOD GetBeConservative(bool *aBeConservative) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBeConservative(aBeConservative); } \
  MOZ_MUST_USE NS_IMETHOD SetBeConservative(bool aBeConservative) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBeConservative(aBeConservative); } \
  MOZ_MUST_USE NS_IMETHOD GetIsTRRServiceChannel(bool *aIsTRRServiceChannel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsTRRServiceChannel(aIsTRRServiceChannel); } \
  MOZ_MUST_USE NS_IMETHOD SetIsTRRServiceChannel(bool aIsTRRServiceChannel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsTRRServiceChannel(aIsTRRServiceChannel); } \
  MOZ_MUST_USE NS_IMETHOD GetIsResolvedByTRR(bool *aIsResolvedByTRR) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsResolvedByTRR(aIsResolvedByTRR); } \
  MOZ_MUST_USE NS_IMETHOD GetTlsFlags(uint32_t *aTlsFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTlsFlags(aTlsFlags); } \
  MOZ_MUST_USE NS_IMETHOD SetTlsFlags(uint32_t aTlsFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTlsFlags(aTlsFlags); } \
  MOZ_MUST_USE NS_IMETHOD GetLastModifiedTime(PRTime *aLastModifiedTime) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastModifiedTime(aLastModifiedTime); } \
  MOZ_MUST_USE NS_IMETHOD GetCorsIncludeCredentials(bool *aCorsIncludeCredentials) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCorsIncludeCredentials(aCorsIncludeCredentials); } \
  MOZ_MUST_USE NS_IMETHOD SetCorsIncludeCredentials(bool aCorsIncludeCredentials) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCorsIncludeCredentials(aCorsIncludeCredentials); } \
  MOZ_MUST_USE NS_IMETHOD GetCorsMode(uint32_t *aCorsMode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCorsMode(aCorsMode); } \
  MOZ_MUST_USE NS_IMETHOD SetCorsMode(uint32_t aCorsMode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetCorsMode(aCorsMode); } \
  MOZ_MUST_USE NS_IMETHOD GetRedirectMode(uint32_t *aRedirectMode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRedirectMode(aRedirectMode); } \
  MOZ_MUST_USE NS_IMETHOD SetRedirectMode(uint32_t aRedirectMode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRedirectMode(aRedirectMode); } \
  MOZ_MUST_USE NS_IMETHOD GetFetchCacheMode(uint32_t *aFetchCacheMode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFetchCacheMode(aFetchCacheMode); } \
  MOZ_MUST_USE NS_IMETHOD SetFetchCacheMode(uint32_t aFetchCacheMode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFetchCacheMode(aFetchCacheMode); } \
  MOZ_MUST_USE NS_IMETHOD GetTopWindowURI(nsIURI **aTopWindowURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTopWindowURI(aTopWindowURI); } \
  MOZ_MUST_USE NS_IMETHOD SetTopWindowURIIfUnknown(nsIURI *topWindowURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTopWindowURIIfUnknown(topWindowURI); } \
  MOZ_MUST_USE NS_IMETHOD GetProxyURI(nsIURI **aProxyURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProxyURI(aProxyURI); } \
  virtual void SetCorsPreflightParameters(const nsTArray<nsCString> & unsafeHeaders) override; \
  virtual void SetAltDataForChild(bool aIsForChild) override; \
  virtual void DisableAltDataCache(void) override; \
  NS_IMETHOD GetBlockAuthPrompt(bool *aBlockAuthPrompt) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBlockAuthPrompt(aBlockAuthPrompt); } \
  NS_IMETHOD SetBlockAuthPrompt(bool aBlockAuthPrompt) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBlockAuthPrompt(aBlockAuthPrompt); } \
  MOZ_MUST_USE NS_IMETHOD GetIntegrityMetadata(nsAString& aIntegrityMetadata) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIntegrityMetadata(aIntegrityMetadata); } \
  MOZ_MUST_USE NS_IMETHOD SetIntegrityMetadata(const nsAString& aIntegrityMetadata) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIntegrityMetadata(aIntegrityMetadata); } \
  MOZ_MUST_USE NS_IMETHOD GetConnectionInfoHashKey(nsACString& aConnectionInfoHashKey) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetConnectionInfoHashKey(aConnectionInfoHashKey); } \
  NS_IMETHOD GetLastRedirectFlags(uint32_t *aLastRedirectFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLastRedirectFlags(aLastRedirectFlags); } \
  NS_IMETHOD SetLastRedirectFlags(uint32_t aLastRedirectFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetLastRedirectFlags(aLastRedirectFlags); } \
  NS_IMETHOD GetNavigationStartTimeStamp(mozilla::TimeStamp * aNavigationStartTimeStamp) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNavigationStartTimeStamp(aNavigationStartTimeStamp); } \
  NS_IMETHOD SetNavigationStartTimeStamp(mozilla::TimeStamp aNavigationStartTimeStamp) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetNavigationStartTimeStamp(aNavigationStartTimeStamp); } \
  NS_IMETHOD CancelByURLClassifier(nsresult aErrorCode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelByURLClassifier(aErrorCode); } \
  virtual void SetIPv4Disabled(void) override; \
  virtual void SetIPv6Disabled(void) override; \
  NS_IMETHOD GetCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy *aCrossOriginOpenerPolicy) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCrossOriginOpenerPolicy(aCrossOriginOpenerPolicy); } \
  NS_IMETHOD ComputeCrossOriginOpenerPolicy(nsILoadInfo::CrossOriginOpenerPolicy aInitiatorPolicy, nsILoadInfo::CrossOriginOpenerPolicy *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ComputeCrossOriginOpenerPolicy(aInitiatorPolicy, _retval); } \
  NS_IMETHOD HasCrossOriginOpenerPolicyMismatch(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->HasCrossOriginOpenerPolicyMismatch(_retval); } \
  NS_IMETHOD GetResponseEmbedderPolicy(nsILoadInfo::CrossOriginEmbedderPolicy *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseEmbedderPolicy(_retval); } \
  virtual bool GetHasNonEmptySandboxingFlag() override; \
  virtual void SetHasNonEmptySandboxingFlag(bool aHasNonEmptySandboxingFlag) override; \
  virtual void DoDiagnosticAssertWhenOnStopNotCalledOnDestroy(void) override; 


#endif /* __gen_nsIHttpChannelInternal_h__ */
