/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/protocol/http/nsIHttpChannel.idl
 */

#ifndef __gen_nsIHttpChannel_h__
#define __gen_nsIHttpChannel_h__


#ifndef __gen_nsIChannel_h__
#include "nsIChannel.h"
#endif

#include "mozilla/AlreadyAddRefed.h"
#include "mozilla/Assertions.h"
#include "mozilla/DebugOnly.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIHttpHeaderVisitor; /* forward declaration */

class nsIReferrerInfo; /* forward declaration */


/* starting interface:    nsIHttpChannel */
#define NS_IHTTPCHANNEL_IID_STR "c5a4a073-4539-49c7-a3f2-cec3f0619c6c"

#define NS_IHTTPCHANNEL_IID \
  {0xc5a4a073, 0x4539, 0x49c7, \
    { 0xa3, 0xf2, 0xce, 0xc3, 0xf0, 0x61, 0x9c, 0x6c }}

class nsIHttpChannel : public nsIIdentChannel {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IHTTPCHANNEL_IID)

  /* [must_use] attribute ACString requestMethod; */
  MOZ_MUST_USE NS_IMETHOD GetRequestMethod(nsACString& aRequestMethod) = 0;
  MOZ_MUST_USE NS_IMETHOD SetRequestMethod(const nsACString& aRequestMethod) = 0;

  /* [infallible,must_use] attribute nsIReferrerInfo referrerInfo; */
  MOZ_MUST_USE NS_IMETHOD GetReferrerInfo(nsIReferrerInfo **aReferrerInfo) = 0;
  inline already_AddRefed<nsIReferrerInfo>GetReferrerInfo()
  {
    nsIReferrerInfo* result = nullptr;
    mozilla::DebugOnly<nsresult> rv = GetReferrerInfo(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return already_AddRefed<nsIReferrerInfo>(result);
  }
  MOZ_MUST_USE NS_IMETHOD SetReferrerInfo(nsIReferrerInfo *aReferrerInfo) = 0;

  /* [must_use,noscript] void setReferrerInfoWithoutClone (in nsIReferrerInfo aReferrerInfo); */
  MOZ_MUST_USE NS_IMETHOD SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo) = 0;

  /* [must_use] readonly attribute ACString protocolVersion; */
  MOZ_MUST_USE NS_IMETHOD GetProtocolVersion(nsACString& aProtocolVersion) = 0;

  /* [must_use] readonly attribute uint64_t transferSize; */
  MOZ_MUST_USE NS_IMETHOD GetTransferSize(uint64_t *aTransferSize) = 0;

  /* [must_use] readonly attribute uint64_t requestSize; */
  MOZ_MUST_USE NS_IMETHOD GetRequestSize(uint64_t *aRequestSize) = 0;

  /* [must_use] readonly attribute uint64_t decodedBodySize; */
  MOZ_MUST_USE NS_IMETHOD GetDecodedBodySize(uint64_t *aDecodedBodySize) = 0;

  /* [must_use] readonly attribute uint64_t encodedBodySize; */
  MOZ_MUST_USE NS_IMETHOD GetEncodedBodySize(uint64_t *aEncodedBodySize) = 0;

  /* [must_use] ACString getRequestHeader (in ACString aHeader); */
  MOZ_MUST_USE NS_IMETHOD GetRequestHeader(const nsACString& aHeader, nsACString& _retval) = 0;

  /* [must_use] void setRequestHeader (in ACString aHeader, in ACString aValue, in boolean aMerge); */
  MOZ_MUST_USE NS_IMETHOD SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge) = 0;

  /* [must_use] void setEmptyRequestHeader (in ACString aHeader); */
  MOZ_MUST_USE NS_IMETHOD SetEmptyRequestHeader(const nsACString& aHeader) = 0;

  /* [must_use] void visitRequestHeaders (in nsIHttpHeaderVisitor aVisitor); */
  MOZ_MUST_USE NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] void visitNonDefaultRequestHeaders (in nsIHttpHeaderVisitor aVisitor); */
  MOZ_MUST_USE NS_IMETHOD VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] attribute boolean allowPipelining; */
  MOZ_MUST_USE NS_IMETHOD GetAllowPipelining(bool *aAllowPipelining) = 0;
  MOZ_MUST_USE NS_IMETHOD SetAllowPipelining(bool aAllowPipelining) = 0;

  /* [must_use] attribute boolean allowSTS; */
  MOZ_MUST_USE NS_IMETHOD GetAllowSTS(bool *aAllowSTS) = 0;
  MOZ_MUST_USE NS_IMETHOD SetAllowSTS(bool aAllowSTS) = 0;

  /* [must_use] attribute unsigned long redirectionLimit; */
  MOZ_MUST_USE NS_IMETHOD GetRedirectionLimit(uint32_t *aRedirectionLimit) = 0;
  MOZ_MUST_USE NS_IMETHOD SetRedirectionLimit(uint32_t aRedirectionLimit) = 0;

  /* [must_use] readonly attribute unsigned long responseStatus; */
  MOZ_MUST_USE NS_IMETHOD GetResponseStatus(uint32_t *aResponseStatus) = 0;

  /* [must_use] readonly attribute ACString responseStatusText; */
  MOZ_MUST_USE NS_IMETHOD GetResponseStatusText(nsACString& aResponseStatusText) = 0;

  /* [must_use] readonly attribute boolean requestSucceeded; */
  MOZ_MUST_USE NS_IMETHOD GetRequestSucceeded(bool *aRequestSucceeded) = 0;

  /* [must_use] attribute boolean isMainDocumentChannel; */
  MOZ_MUST_USE NS_IMETHOD GetIsMainDocumentChannel(bool *aIsMainDocumentChannel) = 0;
  MOZ_MUST_USE NS_IMETHOD SetIsMainDocumentChannel(bool aIsMainDocumentChannel) = 0;

  /* [must_use] ACString getResponseHeader (in ACString header); */
  MOZ_MUST_USE NS_IMETHOD GetResponseHeader(const nsACString& header, nsACString& _retval) = 0;

  /* [must_use] void setResponseHeader (in ACString header, in ACString value, in boolean merge); */
  MOZ_MUST_USE NS_IMETHOD SetResponseHeader(const nsACString& header, const nsACString& value, bool merge) = 0;

  /* [must_use] void visitResponseHeaders (in nsIHttpHeaderVisitor aVisitor); */
  MOZ_MUST_USE NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] void getOriginalResponseHeader (in ACString aHeader, in nsIHttpHeaderVisitor aVisitor); */
  MOZ_MUST_USE NS_IMETHOD GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] void visitOriginalResponseHeaders (in nsIHttpHeaderVisitor aVisitor); */
  MOZ_MUST_USE NS_IMETHOD VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor) = 0;

  /* [must_use] boolean isNoStoreResponse (); */
  MOZ_MUST_USE NS_IMETHOD IsNoStoreResponse(bool *_retval) = 0;

  /* [must_use] boolean isNoCacheResponse (); */
  MOZ_MUST_USE NS_IMETHOD IsNoCacheResponse(bool *_retval) = 0;

  /* [must_use] boolean isPrivateResponse (); */
  MOZ_MUST_USE NS_IMETHOD IsPrivateResponse(bool *_retval) = 0;

  /* [must_use] void redirectTo (in nsIURI aTargetURI); */
  MOZ_MUST_USE NS_IMETHOD RedirectTo(nsIURI *aTargetURI) = 0;

  /* [must_use] void upgradeToSecure (); */
  MOZ_MUST_USE NS_IMETHOD UpgradeToSecure(void) = 0;

  /* [must_use,noscript] attribute uint64_t requestContextID; */
  MOZ_MUST_USE NS_IMETHOD GetRequestContextID(uint64_t *aRequestContextID) = 0;
  MOZ_MUST_USE NS_IMETHOD SetRequestContextID(uint64_t aRequestContextID) = 0;

  /* [must_use] attribute uint64_t topLevelContentWindowId; */
  MOZ_MUST_USE NS_IMETHOD GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId) = 0;
  MOZ_MUST_USE NS_IMETHOD SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId) = 0;

  enum FlashPluginState : uint8_t {
    FlashPluginUnknown = 0,
    FlashPluginAllowed = 1,
    FlashPluginDenied = 2,
    FlashPluginDeniedInSubdocuments = 3,
    FlashPluginLastValue = 3,
  };

  /* [infallible] readonly attribute nsIHttpChannel_FlashPluginState flashPluginState; */
  NS_IMETHOD GetFlashPluginState(nsIHttpChannel::FlashPluginState *aFlashPluginState) = 0;
  inline nsIHttpChannel::FlashPluginState GetFlashPluginState()
  {
    nsIHttpChannel::FlashPluginState result;
    mozilla::DebugOnly<nsresult> rv = GetFlashPluginState(&result);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return result;
  }

  /* [must_use] attribute uint64_t topLevelOuterContentWindowId; */
  MOZ_MUST_USE NS_IMETHOD GetTopLevelOuterContentWindowId(uint64_t *aTopLevelOuterContentWindowId) = 0;
  MOZ_MUST_USE NS_IMETHOD SetTopLevelOuterContentWindowId(uint64_t aTopLevelOuterContentWindowId) = 0;

  /* void logBlockedCORSRequest (in AString aMessage, in ACString aCategory); */
  NS_IMETHOD LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory) = 0;

  /* void logMimeTypeMismatch (in ACString aMessageName, in boolean aWarning, in AString aURL, in AString aContentType); */
  NS_IMETHOD LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType) = 0;

   virtual void SetSource(UniqueProfilerBacktrace aSource) {}
};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIHttpChannel, NS_IHTTPCHANNEL_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPCHANNEL \
  MOZ_MUST_USE NS_IMETHOD GetRequestMethod(nsACString& aRequestMethod) override; \
  MOZ_MUST_USE NS_IMETHOD SetRequestMethod(const nsACString& aRequestMethod) override; \
  using nsIHttpChannel::GetReferrerInfo; \
  MOZ_MUST_USE NS_IMETHOD GetReferrerInfo(nsIReferrerInfo **aReferrerInfo) override; \
  MOZ_MUST_USE NS_IMETHOD SetReferrerInfo(nsIReferrerInfo *aReferrerInfo) override; \
  MOZ_MUST_USE NS_IMETHOD SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo) override; \
  MOZ_MUST_USE NS_IMETHOD GetProtocolVersion(nsACString& aProtocolVersion) override; \
  MOZ_MUST_USE NS_IMETHOD GetTransferSize(uint64_t *aTransferSize) override; \
  MOZ_MUST_USE NS_IMETHOD GetRequestSize(uint64_t *aRequestSize) override; \
  MOZ_MUST_USE NS_IMETHOD GetDecodedBodySize(uint64_t *aDecodedBodySize) override; \
  MOZ_MUST_USE NS_IMETHOD GetEncodedBodySize(uint64_t *aEncodedBodySize) override; \
  MOZ_MUST_USE NS_IMETHOD GetRequestHeader(const nsACString& aHeader, nsACString& _retval) override; \
  MOZ_MUST_USE NS_IMETHOD SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge) override; \
  MOZ_MUST_USE NS_IMETHOD SetEmptyRequestHeader(const nsACString& aHeader) override; \
  MOZ_MUST_USE NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override; \
  MOZ_MUST_USE NS_IMETHOD VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override; \
  MOZ_MUST_USE NS_IMETHOD GetAllowPipelining(bool *aAllowPipelining) override; \
  MOZ_MUST_USE NS_IMETHOD SetAllowPipelining(bool aAllowPipelining) override; \
  MOZ_MUST_USE NS_IMETHOD GetAllowSTS(bool *aAllowSTS) override; \
  MOZ_MUST_USE NS_IMETHOD SetAllowSTS(bool aAllowSTS) override; \
  MOZ_MUST_USE NS_IMETHOD GetRedirectionLimit(uint32_t *aRedirectionLimit) override; \
  MOZ_MUST_USE NS_IMETHOD SetRedirectionLimit(uint32_t aRedirectionLimit) override; \
  MOZ_MUST_USE NS_IMETHOD GetResponseStatus(uint32_t *aResponseStatus) override; \
  MOZ_MUST_USE NS_IMETHOD GetResponseStatusText(nsACString& aResponseStatusText) override; \
  MOZ_MUST_USE NS_IMETHOD GetRequestSucceeded(bool *aRequestSucceeded) override; \
  MOZ_MUST_USE NS_IMETHOD GetIsMainDocumentChannel(bool *aIsMainDocumentChannel) override; \
  MOZ_MUST_USE NS_IMETHOD SetIsMainDocumentChannel(bool aIsMainDocumentChannel) override; \
  MOZ_MUST_USE NS_IMETHOD GetResponseHeader(const nsACString& header, nsACString& _retval) override; \
  MOZ_MUST_USE NS_IMETHOD SetResponseHeader(const nsACString& header, const nsACString& value, bool merge) override; \
  MOZ_MUST_USE NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override; \
  MOZ_MUST_USE NS_IMETHOD GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor) override; \
  MOZ_MUST_USE NS_IMETHOD VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override; \
  MOZ_MUST_USE NS_IMETHOD IsNoStoreResponse(bool *_retval) override; \
  MOZ_MUST_USE NS_IMETHOD IsNoCacheResponse(bool *_retval) override; \
  MOZ_MUST_USE NS_IMETHOD IsPrivateResponse(bool *_retval) override; \
  MOZ_MUST_USE NS_IMETHOD RedirectTo(nsIURI *aTargetURI) override; \
  MOZ_MUST_USE NS_IMETHOD UpgradeToSecure(void) override; \
  MOZ_MUST_USE NS_IMETHOD GetRequestContextID(uint64_t *aRequestContextID) override; \
  MOZ_MUST_USE NS_IMETHOD SetRequestContextID(uint64_t aRequestContextID) override; \
  MOZ_MUST_USE NS_IMETHOD GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId) override; \
  MOZ_MUST_USE NS_IMETHOD SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId) override; \
  using nsIHttpChannel::GetFlashPluginState; \
  NS_IMETHOD GetFlashPluginState(nsIHttpChannel::FlashPluginState *aFlashPluginState) override; \
  MOZ_MUST_USE NS_IMETHOD GetTopLevelOuterContentWindowId(uint64_t *aTopLevelOuterContentWindowId) override; \
  MOZ_MUST_USE NS_IMETHOD SetTopLevelOuterContentWindowId(uint64_t aTopLevelOuterContentWindowId) override; \
  NS_IMETHOD LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory) override; \
  NS_IMETHOD LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType) override; \

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIHTTPCHANNEL \
  MOZ_MUST_USE nsresult GetRequestMethod(nsACString& aRequestMethod); \
  MOZ_MUST_USE nsresult SetRequestMethod(const nsACString& aRequestMethod); \
  using nsIHttpChannel::GetReferrerInfo; \
  MOZ_MUST_USE nsresult GetReferrerInfo(nsIReferrerInfo **aReferrerInfo); \
  MOZ_MUST_USE nsresult SetReferrerInfo(nsIReferrerInfo *aReferrerInfo); \
  MOZ_MUST_USE nsresult SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo); \
  MOZ_MUST_USE nsresult GetProtocolVersion(nsACString& aProtocolVersion); \
  MOZ_MUST_USE nsresult GetTransferSize(uint64_t *aTransferSize); \
  MOZ_MUST_USE nsresult GetRequestSize(uint64_t *aRequestSize); \
  MOZ_MUST_USE nsresult GetDecodedBodySize(uint64_t *aDecodedBodySize); \
  MOZ_MUST_USE nsresult GetEncodedBodySize(uint64_t *aEncodedBodySize); \
  MOZ_MUST_USE nsresult GetRequestHeader(const nsACString& aHeader, nsACString& _retval); \
  MOZ_MUST_USE nsresult SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge); \
  MOZ_MUST_USE nsresult SetEmptyRequestHeader(const nsACString& aHeader); \
  MOZ_MUST_USE nsresult VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor); \
  MOZ_MUST_USE nsresult VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor); \
  MOZ_MUST_USE nsresult GetAllowPipelining(bool *aAllowPipelining); \
  MOZ_MUST_USE nsresult SetAllowPipelining(bool aAllowPipelining); \
  MOZ_MUST_USE nsresult GetAllowSTS(bool *aAllowSTS); \
  MOZ_MUST_USE nsresult SetAllowSTS(bool aAllowSTS); \
  MOZ_MUST_USE nsresult GetRedirectionLimit(uint32_t *aRedirectionLimit); \
  MOZ_MUST_USE nsresult SetRedirectionLimit(uint32_t aRedirectionLimit); \
  MOZ_MUST_USE nsresult GetResponseStatus(uint32_t *aResponseStatus); \
  MOZ_MUST_USE nsresult GetResponseStatusText(nsACString& aResponseStatusText); \
  MOZ_MUST_USE nsresult GetRequestSucceeded(bool *aRequestSucceeded); \
  MOZ_MUST_USE nsresult GetIsMainDocumentChannel(bool *aIsMainDocumentChannel); \
  MOZ_MUST_USE nsresult SetIsMainDocumentChannel(bool aIsMainDocumentChannel); \
  MOZ_MUST_USE nsresult GetResponseHeader(const nsACString& header, nsACString& _retval); \
  MOZ_MUST_USE nsresult SetResponseHeader(const nsACString& header, const nsACString& value, bool merge); \
  MOZ_MUST_USE nsresult VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor); \
  MOZ_MUST_USE nsresult GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor); \
  MOZ_MUST_USE nsresult VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor); \
  MOZ_MUST_USE nsresult IsNoStoreResponse(bool *_retval); \
  MOZ_MUST_USE nsresult IsNoCacheResponse(bool *_retval); \
  MOZ_MUST_USE nsresult IsPrivateResponse(bool *_retval); \
  MOZ_MUST_USE nsresult RedirectTo(nsIURI *aTargetURI); \
  MOZ_MUST_USE nsresult UpgradeToSecure(void); \
  MOZ_MUST_USE nsresult GetRequestContextID(uint64_t *aRequestContextID); \
  MOZ_MUST_USE nsresult SetRequestContextID(uint64_t aRequestContextID); \
  MOZ_MUST_USE nsresult GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId); \
  MOZ_MUST_USE nsresult SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId); \
  using nsIHttpChannel::GetFlashPluginState; \
  nsresult GetFlashPluginState(nsIHttpChannel::FlashPluginState *aFlashPluginState); \
  MOZ_MUST_USE nsresult GetTopLevelOuterContentWindowId(uint64_t *aTopLevelOuterContentWindowId); \
  MOZ_MUST_USE nsresult SetTopLevelOuterContentWindowId(uint64_t aTopLevelOuterContentWindowId); \
  nsresult LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory); \
  nsresult LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPCHANNEL(_to) \
  MOZ_MUST_USE NS_IMETHOD GetRequestMethod(nsACString& aRequestMethod) override { return _to GetRequestMethod(aRequestMethod); } \
  MOZ_MUST_USE NS_IMETHOD SetRequestMethod(const nsACString& aRequestMethod) override { return _to SetRequestMethod(aRequestMethod); } \
  using nsIHttpChannel::GetReferrerInfo; \
  MOZ_MUST_USE NS_IMETHOD GetReferrerInfo(nsIReferrerInfo **aReferrerInfo) override { return _to GetReferrerInfo(aReferrerInfo); } \
  MOZ_MUST_USE NS_IMETHOD SetReferrerInfo(nsIReferrerInfo *aReferrerInfo) override { return _to SetReferrerInfo(aReferrerInfo); } \
  MOZ_MUST_USE NS_IMETHOD SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo) override { return _to SetReferrerInfoWithoutClone(aReferrerInfo); } \
  MOZ_MUST_USE NS_IMETHOD GetProtocolVersion(nsACString& aProtocolVersion) override { return _to GetProtocolVersion(aProtocolVersion); } \
  MOZ_MUST_USE NS_IMETHOD GetTransferSize(uint64_t *aTransferSize) override { return _to GetTransferSize(aTransferSize); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestSize(uint64_t *aRequestSize) override { return _to GetRequestSize(aRequestSize); } \
  MOZ_MUST_USE NS_IMETHOD GetDecodedBodySize(uint64_t *aDecodedBodySize) override { return _to GetDecodedBodySize(aDecodedBodySize); } \
  MOZ_MUST_USE NS_IMETHOD GetEncodedBodySize(uint64_t *aEncodedBodySize) override { return _to GetEncodedBodySize(aEncodedBodySize); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestHeader(const nsACString& aHeader, nsACString& _retval) override { return _to GetRequestHeader(aHeader, _retval); } \
  MOZ_MUST_USE NS_IMETHOD SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge) override { return _to SetRequestHeader(aHeader, aValue, aMerge); } \
  MOZ_MUST_USE NS_IMETHOD SetEmptyRequestHeader(const nsACString& aHeader) override { return _to SetEmptyRequestHeader(aHeader); } \
  MOZ_MUST_USE NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override { return _to VisitRequestHeaders(aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override { return _to VisitNonDefaultRequestHeaders(aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD GetAllowPipelining(bool *aAllowPipelining) override { return _to GetAllowPipelining(aAllowPipelining); } \
  MOZ_MUST_USE NS_IMETHOD SetAllowPipelining(bool aAllowPipelining) override { return _to SetAllowPipelining(aAllowPipelining); } \
  MOZ_MUST_USE NS_IMETHOD GetAllowSTS(bool *aAllowSTS) override { return _to GetAllowSTS(aAllowSTS); } \
  MOZ_MUST_USE NS_IMETHOD SetAllowSTS(bool aAllowSTS) override { return _to SetAllowSTS(aAllowSTS); } \
  MOZ_MUST_USE NS_IMETHOD GetRedirectionLimit(uint32_t *aRedirectionLimit) override { return _to GetRedirectionLimit(aRedirectionLimit); } \
  MOZ_MUST_USE NS_IMETHOD SetRedirectionLimit(uint32_t aRedirectionLimit) override { return _to SetRedirectionLimit(aRedirectionLimit); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseStatus(uint32_t *aResponseStatus) override { return _to GetResponseStatus(aResponseStatus); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseStatusText(nsACString& aResponseStatusText) override { return _to GetResponseStatusText(aResponseStatusText); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestSucceeded(bool *aRequestSucceeded) override { return _to GetRequestSucceeded(aRequestSucceeded); } \
  MOZ_MUST_USE NS_IMETHOD GetIsMainDocumentChannel(bool *aIsMainDocumentChannel) override { return _to GetIsMainDocumentChannel(aIsMainDocumentChannel); } \
  MOZ_MUST_USE NS_IMETHOD SetIsMainDocumentChannel(bool aIsMainDocumentChannel) override { return _to SetIsMainDocumentChannel(aIsMainDocumentChannel); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseHeader(const nsACString& header, nsACString& _retval) override { return _to GetResponseHeader(header, _retval); } \
  MOZ_MUST_USE NS_IMETHOD SetResponseHeader(const nsACString& header, const nsACString& value, bool merge) override { return _to SetResponseHeader(header, value, merge); } \
  MOZ_MUST_USE NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override { return _to VisitResponseHeaders(aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor) override { return _to GetOriginalResponseHeader(aHeader, aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override { return _to VisitOriginalResponseHeaders(aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD IsNoStoreResponse(bool *_retval) override { return _to IsNoStoreResponse(_retval); } \
  MOZ_MUST_USE NS_IMETHOD IsNoCacheResponse(bool *_retval) override { return _to IsNoCacheResponse(_retval); } \
  MOZ_MUST_USE NS_IMETHOD IsPrivateResponse(bool *_retval) override { return _to IsPrivateResponse(_retval); } \
  MOZ_MUST_USE NS_IMETHOD RedirectTo(nsIURI *aTargetURI) override { return _to RedirectTo(aTargetURI); } \
  MOZ_MUST_USE NS_IMETHOD UpgradeToSecure(void) override { return _to UpgradeToSecure(); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestContextID(uint64_t *aRequestContextID) override { return _to GetRequestContextID(aRequestContextID); } \
  MOZ_MUST_USE NS_IMETHOD SetRequestContextID(uint64_t aRequestContextID) override { return _to SetRequestContextID(aRequestContextID); } \
  MOZ_MUST_USE NS_IMETHOD GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId) override { return _to GetTopLevelContentWindowId(aTopLevelContentWindowId); } \
  MOZ_MUST_USE NS_IMETHOD SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId) override { return _to SetTopLevelContentWindowId(aTopLevelContentWindowId); } \
  using nsIHttpChannel::GetFlashPluginState; \
  NS_IMETHOD GetFlashPluginState(nsIHttpChannel::FlashPluginState *aFlashPluginState) override { return _to GetFlashPluginState(aFlashPluginState); } \
  MOZ_MUST_USE NS_IMETHOD GetTopLevelOuterContentWindowId(uint64_t *aTopLevelOuterContentWindowId) override { return _to GetTopLevelOuterContentWindowId(aTopLevelOuterContentWindowId); } \
  MOZ_MUST_USE NS_IMETHOD SetTopLevelOuterContentWindowId(uint64_t aTopLevelOuterContentWindowId) override { return _to SetTopLevelOuterContentWindowId(aTopLevelOuterContentWindowId); } \
  NS_IMETHOD LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory) override { return _to LogBlockedCORSRequest(aMessage, aCategory); } \
  NS_IMETHOD LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType) override { return _to LogMimeTypeMismatch(aMessageName, aWarning, aURL, aContentType); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPCHANNEL(_to) \
  MOZ_MUST_USE NS_IMETHOD GetRequestMethod(nsACString& aRequestMethod) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestMethod(aRequestMethod); } \
  MOZ_MUST_USE NS_IMETHOD SetRequestMethod(const nsACString& aRequestMethod) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestMethod(aRequestMethod); } \
  MOZ_MUST_USE NS_IMETHOD GetReferrerInfo(nsIReferrerInfo **aReferrerInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReferrerInfo(aReferrerInfo); } \
  MOZ_MUST_USE NS_IMETHOD SetReferrerInfo(nsIReferrerInfo *aReferrerInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReferrerInfo(aReferrerInfo); } \
  MOZ_MUST_USE NS_IMETHOD SetReferrerInfoWithoutClone(nsIReferrerInfo *aReferrerInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReferrerInfoWithoutClone(aReferrerInfo); } \
  MOZ_MUST_USE NS_IMETHOD GetProtocolVersion(nsACString& aProtocolVersion) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProtocolVersion(aProtocolVersion); } \
  MOZ_MUST_USE NS_IMETHOD GetTransferSize(uint64_t *aTransferSize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTransferSize(aTransferSize); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestSize(uint64_t *aRequestSize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestSize(aRequestSize); } \
  MOZ_MUST_USE NS_IMETHOD GetDecodedBodySize(uint64_t *aDecodedBodySize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDecodedBodySize(aDecodedBodySize); } \
  MOZ_MUST_USE NS_IMETHOD GetEncodedBodySize(uint64_t *aEncodedBodySize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEncodedBodySize(aEncodedBodySize); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestHeader(const nsACString& aHeader, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestHeader(aHeader, _retval); } \
  MOZ_MUST_USE NS_IMETHOD SetRequestHeader(const nsACString& aHeader, const nsACString& aValue, bool aMerge) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestHeader(aHeader, aValue, aMerge); } \
  MOZ_MUST_USE NS_IMETHOD SetEmptyRequestHeader(const nsACString& aHeader) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEmptyRequestHeader(aHeader); } \
  MOZ_MUST_USE NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitRequestHeaders(aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD VisitNonDefaultRequestHeaders(nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitNonDefaultRequestHeaders(aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD GetAllowPipelining(bool *aAllowPipelining) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowPipelining(aAllowPipelining); } \
  MOZ_MUST_USE NS_IMETHOD SetAllowPipelining(bool aAllowPipelining) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowPipelining(aAllowPipelining); } \
  MOZ_MUST_USE NS_IMETHOD GetAllowSTS(bool *aAllowSTS) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowSTS(aAllowSTS); } \
  MOZ_MUST_USE NS_IMETHOD SetAllowSTS(bool aAllowSTS) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowSTS(aAllowSTS); } \
  MOZ_MUST_USE NS_IMETHOD GetRedirectionLimit(uint32_t *aRedirectionLimit) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRedirectionLimit(aRedirectionLimit); } \
  MOZ_MUST_USE NS_IMETHOD SetRedirectionLimit(uint32_t aRedirectionLimit) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRedirectionLimit(aRedirectionLimit); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseStatus(uint32_t *aResponseStatus) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseStatus(aResponseStatus); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseStatusText(nsACString& aResponseStatusText) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseStatusText(aResponseStatusText); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestSucceeded(bool *aRequestSucceeded) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestSucceeded(aRequestSucceeded); } \
  MOZ_MUST_USE NS_IMETHOD GetIsMainDocumentChannel(bool *aIsMainDocumentChannel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsMainDocumentChannel(aIsMainDocumentChannel); } \
  MOZ_MUST_USE NS_IMETHOD SetIsMainDocumentChannel(bool aIsMainDocumentChannel) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIsMainDocumentChannel(aIsMainDocumentChannel); } \
  MOZ_MUST_USE NS_IMETHOD GetResponseHeader(const nsACString& header, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseHeader(header, _retval); } \
  MOZ_MUST_USE NS_IMETHOD SetResponseHeader(const nsACString& header, const nsACString& value, bool merge) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetResponseHeader(header, value, merge); } \
  MOZ_MUST_USE NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitResponseHeaders(aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD GetOriginalResponseHeader(const nsACString& aHeader, nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetOriginalResponseHeader(aHeader, aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD VisitOriginalResponseHeaders(nsIHttpHeaderVisitor *aVisitor) override { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitOriginalResponseHeaders(aVisitor); } \
  MOZ_MUST_USE NS_IMETHOD IsNoStoreResponse(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsNoStoreResponse(_retval); } \
  MOZ_MUST_USE NS_IMETHOD IsNoCacheResponse(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsNoCacheResponse(_retval); } \
  MOZ_MUST_USE NS_IMETHOD IsPrivateResponse(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsPrivateResponse(_retval); } \
  MOZ_MUST_USE NS_IMETHOD RedirectTo(nsIURI *aTargetURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RedirectTo(aTargetURI); } \
  MOZ_MUST_USE NS_IMETHOD UpgradeToSecure(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->UpgradeToSecure(); } \
  MOZ_MUST_USE NS_IMETHOD GetRequestContextID(uint64_t *aRequestContextID) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestContextID(aRequestContextID); } \
  MOZ_MUST_USE NS_IMETHOD SetRequestContextID(uint64_t aRequestContextID) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestContextID(aRequestContextID); } \
  MOZ_MUST_USE NS_IMETHOD GetTopLevelContentWindowId(uint64_t *aTopLevelContentWindowId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTopLevelContentWindowId(aTopLevelContentWindowId); } \
  MOZ_MUST_USE NS_IMETHOD SetTopLevelContentWindowId(uint64_t aTopLevelContentWindowId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTopLevelContentWindowId(aTopLevelContentWindowId); } \
  NS_IMETHOD GetFlashPluginState(nsIHttpChannel::FlashPluginState *aFlashPluginState) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFlashPluginState(aFlashPluginState); } \
  MOZ_MUST_USE NS_IMETHOD GetTopLevelOuterContentWindowId(uint64_t *aTopLevelOuterContentWindowId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTopLevelOuterContentWindowId(aTopLevelOuterContentWindowId); } \
  MOZ_MUST_USE NS_IMETHOD SetTopLevelOuterContentWindowId(uint64_t aTopLevelOuterContentWindowId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetTopLevelOuterContentWindowId(aTopLevelOuterContentWindowId); } \
  NS_IMETHOD LogBlockedCORSRequest(const nsAString& aMessage, const nsACString& aCategory) override { return !_to ? NS_ERROR_NULL_POINTER : _to->LogBlockedCORSRequest(aMessage, aCategory); } \
  NS_IMETHOD LogMimeTypeMismatch(const nsACString& aMessageName, bool aWarning, const nsAString& aURL, const nsAString& aContentType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->LogMimeTypeMismatch(aMessageName, aWarning, aURL, aContentType); } \


#endif /* __gen_nsIHttpChannel_h__ */
