/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/dns/nsIDNSService.idl
 */

#ifndef __gen_nsIDNSService_h__
#define __gen_nsIDNSService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIRequest_h__
#include "nsIRequest.h"
#endif

#include "js/Value.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#include "mozilla/BasePrincipal.h"
class nsICancelable; /* forward declaration */

class nsIEventTarget; /* forward declaration */

class nsIDNSRecord; /* forward declaration */

class nsIDNSListener; /* forward declaration */

#include "nsTArrayForwardDeclare.h"
namespace mozilla { namespace net {
    struct DNSCacheEntries;
} }

/* starting interface:    nsIDNSService */
#define NS_IDNSSERVICE_IID_STR "de5642c6-61fc-4fcf-9a47-03226b0d4e21"

#define NS_IDNSSERVICE_IID \
  {0xde5642c6, 0x61fc, 0x4fcf, \
    { 0x9a, 0x47, 0x03, 0x22, 0x6b, 0x0d, 0x4e, 0x21 }}

class nsIDNSService : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IDNSSERVICE_IID)

  /* [implicit_jscontext,optional_argc] nsICancelable asyncResolve (in AUTF8String aHostName, in unsigned long aFlags, in nsIDNSListener aListener, in nsIEventTarget aListenerTarget, [optional] in jsval aOriginAttributes); */
  NS_IMETHOD AsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) = 0;

  /* [notxpcom] nsresult asyncResolveNative (in AUTF8String aHostName, in unsigned long aFlags, in nsIDNSListener aListener, in nsIEventTarget aListenerTarget, in OriginAttributes aOriginAttributes, out nsICancelable aResult); */
  NS_IMETHOD AsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) = 0;

  /* [implicit_jscontext,optional_argc] nsICancelable asyncResolveWithTrrServer (in AUTF8String aHostName, in AUTF8String aTrrServer, in unsigned long aFlags, in nsIDNSListener aListener, in nsIEventTarget aListenerTarget, [optional] in jsval aOriginAttributes); */
  NS_IMETHOD AsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) = 0;

  /* [notxpcom] nsresult asyncResolveWithTrrServerNative (in AUTF8String aHostName, in AUTF8String aTrrServer, in unsigned long aFlags, in nsIDNSListener aListener, in nsIEventTarget aListenerTarget, in OriginAttributes aOriginAttributes, out nsICancelable aResult); */
  NS_IMETHOD AsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) = 0;

  /* [implicit_jscontext,optional_argc] nsICancelable asyncResolveByType (in AUTF8String aHostName, in unsigned short aType, in unsigned long aFlags, in nsIDNSListener aListener, in nsIEventTarget aListenerTarget, in jsval aOriginAttributes); */
  NS_IMETHOD AsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) = 0;

  /* [notxpcom] nsresult asyncResolveByTypeNative (in AUTF8String aHostName, in unsigned short aType, in unsigned long aFlags, in nsIDNSListener aListener, in nsIEventTarget aListenerTarget, in OriginAttributes aOriginAttributes, out nsICancelable aResult); */
  NS_IMETHOD AsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) = 0;

  /* [implicit_jscontext,optional_argc] void cancelAsyncResolve (in AUTF8String aHostName, in unsigned long aFlags, in nsIDNSListener aListener, in nsresult aReason, [optional] in jsval aOriginAttributes); */
  NS_IMETHOD CancelAsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) = 0;

  /* [notxpcom] nsresult cancelAsyncResolveNative (in AUTF8String aHostName, in unsigned long aFlags, in nsIDNSListener aListener, in nsresult aReason, in OriginAttributes aOriginAttributes); */
  NS_IMETHOD CancelAsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) = 0;

  /* [implicit_jscontext,optional_argc] void cancelAsyncResolveWithTrrServer (in AUTF8String aHostName, in AUTF8String aTrrServer, in unsigned long aFlags, in nsIDNSListener aListener, in nsresult aReason, [optional] in jsval aOriginAttributes); */
  NS_IMETHOD CancelAsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) = 0;

  /* [notxpcom] nsresult cancelAsyncResolveWithTrrServerNative (in AUTF8String aHostName, in AUTF8String aTrrServer, in unsigned long aFlags, in nsIDNSListener aListener, in nsresult aReason, in OriginAttributes aOriginAttributes); */
  NS_IMETHOD CancelAsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) = 0;

  /* [implicit_jscontext,optional_argc] void cancelAsyncResolveByType (in AUTF8String aHostName, in unsigned short aType, in unsigned long aFlags, in nsIDNSListener aListener, in nsresult aReason, in jsval aOriginAttributes); */
  NS_IMETHOD CancelAsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) = 0;

  /* [notxpcom] nsresult cancelAsyncResolveByTypeNative (in AUTF8String aHostName, in unsigned short aType, in unsigned long aFlags, in nsIDNSListener aListener, in nsresult aReason, in OriginAttributes aOriginAttributes); */
  NS_IMETHOD CancelAsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) = 0;

  /* [implicit_jscontext,optional_argc] nsIDNSRecord resolve (in AUTF8String aHostName, in unsigned long aFlags, [optional] in jsval aOriginAttributes); */
  NS_IMETHOD Resolve(const nsACString& aHostName, uint32_t aFlags, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsIDNSRecord **_retval) = 0;

  /* [notxpcom] nsresult resolveNative (in AUTF8String aHostName, in unsigned long aFlags, in OriginAttributes aOriginAttributes, out nsIDNSRecord aResult); */
  NS_IMETHOD ResolveNative(const nsACString& aHostName, uint32_t aFlags, const mozilla::OriginAttributes & aOriginAttributes, nsIDNSRecord **aResult) = 0;

  /* [noscript] void getDNSCacheEntries (in EntriesArray args); */
  NS_IMETHOD GetDNSCacheEntries(nsTArray<mozilla::net::DNSCacheEntries> * args) = 0;

  /* void clearCache (in boolean aTrrToo); */
  NS_IMETHOD ClearCache(bool aTrrToo) = 0;

  /* void reloadParentalControlEnabled (); */
  NS_IMETHOD ReloadParentalControlEnabled(void) = 0;

  /* void setDetectedTrrURI (in AUTF8String aURI); */
  NS_IMETHOD SetDetectedTrrURI(const nsACString& aURI) = 0;

  /* readonly attribute AUTF8String currentTrrURI; */
  NS_IMETHOD GetCurrentTrrURI(nsACString& aCurrentTrrURI) = 0;

  /* readonly attribute unsigned long currentTrrMode; */
  NS_IMETHOD GetCurrentTrrMode(uint32_t *aCurrentTrrMode) = 0;

  /* readonly attribute AUTF8String myHostName; */
  NS_IMETHOD GetMyHostName(nsACString& aMyHostName) = 0;

  enum {
    RESOLVE_BYPASS_CACHE = 1U,
    RESOLVE_CANONICAL_NAME = 2U,
    RESOLVE_PRIORITY_MEDIUM = 4U,
    RESOLVE_PRIORITY_LOW = 8U,
    RESOLVE_SPECULATE = 16U,
    RESOLVE_DISABLE_IPV6 = 32U,
    RESOLVE_OFFLINE = 64U,
    RESOLVE_DISABLE_IPV4 = 128U,
    RESOLVE_ALLOW_NAME_COLLISION = 256U,
    RESOLVE_DISABLE_TRR = 512U,
    RESOLVE_REFRESH_CACHE = 1024U,
    RESOLVE_TRR_MODE_MASK = 6144U
  };

     static uint32_t GetFlagsFromTRRMode(nsIRequest::TRRMode aMode) {
        return static_cast<uint32_t>(aMode) << 11;
    }
    static nsIRequest::TRRMode GetTRRModeFromFlags(uint32_t aFlags) {
        return static_cast<nsIRequest::TRRMode>((aFlags & RESOLVE_TRR_MODE_MASK) >> 11);
    }
  enum {
    RESOLVE_TYPE_DEFAULT = 0U,
    RESOLVE_TYPE_TXT = 16U,
    RESOLVE_TYPE_HTTPSSVC = 65345U
  };

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIDNSService, NS_IDNSSERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIDNSSERVICE \
  NS_IMETHOD AsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override; \
  NS_IMETHOD AsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override; \
  NS_IMETHOD AsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override; \
  NS_IMETHOD AsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override; \
  NS_IMETHOD AsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override; \
  NS_IMETHOD AsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override; \
  NS_IMETHOD CancelAsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override; \
  NS_IMETHOD CancelAsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override; \
  NS_IMETHOD CancelAsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override; \
  NS_IMETHOD CancelAsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override; \
  NS_IMETHOD CancelAsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override; \
  NS_IMETHOD CancelAsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override; \
  NS_IMETHOD Resolve(const nsACString& aHostName, uint32_t aFlags, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsIDNSRecord **_retval) override; \
  NS_IMETHOD ResolveNative(const nsACString& aHostName, uint32_t aFlags, const mozilla::OriginAttributes & aOriginAttributes, nsIDNSRecord **aResult) override; \
  NS_IMETHOD GetDNSCacheEntries(nsTArray<mozilla::net::DNSCacheEntries> * args) override; \
  NS_IMETHOD ClearCache(bool aTrrToo) override; \
  NS_IMETHOD ReloadParentalControlEnabled(void) override; \
  NS_IMETHOD SetDetectedTrrURI(const nsACString& aURI) override; \
  NS_IMETHOD GetCurrentTrrURI(nsACString& aCurrentTrrURI) override; \
  NS_IMETHOD GetCurrentTrrMode(uint32_t *aCurrentTrrMode) override; \
  NS_IMETHOD GetMyHostName(nsACString& aMyHostName) override; \

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIDNSSERVICE \
  nsresult AsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval); \
  nsresult AsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult); \
  nsresult AsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval); \
  nsresult AsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult); \
  nsresult AsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval); \
  nsresult AsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult); \
  nsresult CancelAsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc); \
  nsresult CancelAsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes); \
  nsresult CancelAsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc); \
  nsresult CancelAsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes); \
  nsresult CancelAsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc); \
  nsresult CancelAsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes); \
  nsresult Resolve(const nsACString& aHostName, uint32_t aFlags, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsIDNSRecord **_retval); \
  nsresult ResolveNative(const nsACString& aHostName, uint32_t aFlags, const mozilla::OriginAttributes & aOriginAttributes, nsIDNSRecord **aResult); \
  nsresult GetDNSCacheEntries(nsTArray<mozilla::net::DNSCacheEntries> * args); \
  nsresult ClearCache(bool aTrrToo); \
  nsresult ReloadParentalControlEnabled(void); \
  nsresult SetDetectedTrrURI(const nsACString& aURI); \
  nsresult GetCurrentTrrURI(nsACString& aCurrentTrrURI); \
  nsresult GetCurrentTrrMode(uint32_t *aCurrentTrrMode); \
  nsresult GetMyHostName(nsACString& aMyHostName); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIDNSSERVICE(_to) \
  NS_IMETHOD AsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override { return _to AsyncResolve(aHostName, aFlags, aListener, aListenerTarget, aOriginAttributes, cx, _argc, _retval); } \
  NS_IMETHOD AsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override { return _to AsyncResolveNative(aHostName, aFlags, aListener, aListenerTarget, aOriginAttributes, aResult); } \
  NS_IMETHOD AsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override { return _to AsyncResolveWithTrrServer(aHostName, aTrrServer, aFlags, aListener, aListenerTarget, aOriginAttributes, cx, _argc, _retval); } \
  NS_IMETHOD AsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override { return _to AsyncResolveWithTrrServerNative(aHostName, aTrrServer, aFlags, aListener, aListenerTarget, aOriginAttributes, aResult); } \
  NS_IMETHOD AsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override { return _to AsyncResolveByType(aHostName, aType, aFlags, aListener, aListenerTarget, aOriginAttributes, cx, _argc, _retval); } \
  NS_IMETHOD AsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override { return _to AsyncResolveByTypeNative(aHostName, aType, aFlags, aListener, aListenerTarget, aOriginAttributes, aResult); } \
  NS_IMETHOD CancelAsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override { return _to CancelAsyncResolve(aHostName, aFlags, aListener, aReason, aOriginAttributes, cx, _argc); } \
  NS_IMETHOD CancelAsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override { return _to CancelAsyncResolveNative(aHostName, aFlags, aListener, aReason, aOriginAttributes); } \
  NS_IMETHOD CancelAsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override { return _to CancelAsyncResolveWithTrrServer(aHostName, aTrrServer, aFlags, aListener, aReason, aOriginAttributes, cx, _argc); } \
  NS_IMETHOD CancelAsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override { return _to CancelAsyncResolveWithTrrServerNative(aHostName, aTrrServer, aFlags, aListener, aReason, aOriginAttributes); } \
  NS_IMETHOD CancelAsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override { return _to CancelAsyncResolveByType(aHostName, aType, aFlags, aListener, aReason, aOriginAttributes, cx, _argc); } \
  NS_IMETHOD CancelAsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override { return _to CancelAsyncResolveByTypeNative(aHostName, aType, aFlags, aListener, aReason, aOriginAttributes); } \
  NS_IMETHOD Resolve(const nsACString& aHostName, uint32_t aFlags, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsIDNSRecord **_retval) override { return _to Resolve(aHostName, aFlags, aOriginAttributes, cx, _argc, _retval); } \
  NS_IMETHOD ResolveNative(const nsACString& aHostName, uint32_t aFlags, const mozilla::OriginAttributes & aOriginAttributes, nsIDNSRecord **aResult) override { return _to ResolveNative(aHostName, aFlags, aOriginAttributes, aResult); } \
  NS_IMETHOD GetDNSCacheEntries(nsTArray<mozilla::net::DNSCacheEntries> * args) override { return _to GetDNSCacheEntries(args); } \
  NS_IMETHOD ClearCache(bool aTrrToo) override { return _to ClearCache(aTrrToo); } \
  NS_IMETHOD ReloadParentalControlEnabled(void) override { return _to ReloadParentalControlEnabled(); } \
  NS_IMETHOD SetDetectedTrrURI(const nsACString& aURI) override { return _to SetDetectedTrrURI(aURI); } \
  NS_IMETHOD GetCurrentTrrURI(nsACString& aCurrentTrrURI) override { return _to GetCurrentTrrURI(aCurrentTrrURI); } \
  NS_IMETHOD GetCurrentTrrMode(uint32_t *aCurrentTrrMode) override { return _to GetCurrentTrrMode(aCurrentTrrMode); } \
  NS_IMETHOD GetMyHostName(nsACString& aMyHostName) override { return _to GetMyHostName(aMyHostName); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIDNSSERVICE(_to) \
  NS_IMETHOD AsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncResolve(aHostName, aFlags, aListener, aListenerTarget, aOriginAttributes, cx, _argc, _retval); } \
  NS_IMETHOD AsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override; \
  NS_IMETHOD AsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncResolveWithTrrServer(aHostName, aTrrServer, aFlags, aListener, aListenerTarget, aOriginAttributes, cx, _argc, _retval); } \
  NS_IMETHOD AsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override; \
  NS_IMETHOD AsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsICancelable **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncResolveByType(aHostName, aType, aFlags, aListener, aListenerTarget, aOriginAttributes, cx, _argc, _retval); } \
  NS_IMETHOD AsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsIEventTarget *aListenerTarget, const mozilla::OriginAttributes & aOriginAttributes, nsICancelable **aResult) override; \
  NS_IMETHOD CancelAsyncResolve(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelAsyncResolve(aHostName, aFlags, aListener, aReason, aOriginAttributes, cx, _argc); } \
  NS_IMETHOD CancelAsyncResolveNative(const nsACString& aHostName, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override; \
  NS_IMETHOD CancelAsyncResolveWithTrrServer(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelAsyncResolveWithTrrServer(aHostName, aTrrServer, aFlags, aListener, aReason, aOriginAttributes, cx, _argc); } \
  NS_IMETHOD CancelAsyncResolveWithTrrServerNative(const nsACString& aHostName, const nsACString& aTrrServer, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override; \
  NS_IMETHOD CancelAsyncResolveByType(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CancelAsyncResolveByType(aHostName, aType, aFlags, aListener, aReason, aOriginAttributes, cx, _argc); } \
  NS_IMETHOD CancelAsyncResolveByTypeNative(const nsACString& aHostName, uint16_t aType, uint32_t aFlags, nsIDNSListener *aListener, nsresult aReason, const mozilla::OriginAttributes & aOriginAttributes) override; \
  NS_IMETHOD Resolve(const nsACString& aHostName, uint32_t aFlags, JS::HandleValue aOriginAttributes, JSContext* cx, uint8_t _argc, nsIDNSRecord **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Resolve(aHostName, aFlags, aOriginAttributes, cx, _argc, _retval); } \
  NS_IMETHOD ResolveNative(const nsACString& aHostName, uint32_t aFlags, const mozilla::OriginAttributes & aOriginAttributes, nsIDNSRecord **aResult) override; \
  NS_IMETHOD GetDNSCacheEntries(nsTArray<mozilla::net::DNSCacheEntries> * args) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDNSCacheEntries(args); } \
  NS_IMETHOD ClearCache(bool aTrrToo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearCache(aTrrToo); } \
  NS_IMETHOD ReloadParentalControlEnabled(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReloadParentalControlEnabled(); } \
  NS_IMETHOD SetDetectedTrrURI(const nsACString& aURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDetectedTrrURI(aURI); } \
  NS_IMETHOD GetCurrentTrrURI(nsACString& aCurrentTrrURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentTrrURI(aCurrentTrrURI); } \
  NS_IMETHOD GetCurrentTrrMode(uint32_t *aCurrentTrrMode) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCurrentTrrMode(aCurrentTrrMode); } \
  NS_IMETHOD GetMyHostName(nsACString& aMyHostName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMyHostName(aMyHostName); } \


/**
 * An observer notification for this topic is sent whenever the URI that the
 * TRR service is using has changed.
 */
#define NS_NETWORK_TRR_URI_CHANGED_TOPIC "network:trr-uri-changed"
/**
 * An observer notification for this topic is sent whenever the mode that the
 * TRR service is using has changed.
 */
#define NS_NETWORK_TRR_MODE_CHANGED_TOPIC "network:trr-mode-changed"

#endif /* __gen_nsIDNSService_h__ */
