/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Generated with cbindgen:0.17.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */
#ifndef mozilla_intl_l10n_FluentBindings_h
#error "Don't include this file directly, instead include FluentBindings.h"
#endif


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

namespace mozilla {
namespace intl {
namespace ffi {

enum class FluentDateTimeStyle {
  Full,
  Long,
  Medium,
  Short,
  None,
};

enum class FluentNumberCurrencyDisplayStyleRaw {
  Symbol,
  Code,
  Name,
};

enum class FluentNumberStyleRaw {
  Decimal,
  Currency,
  Percent,
};

struct FluentBundleRc;

/// A resource containing a list of localization messages.
struct FluentResource;

struct RawDateTimeFormatter;

struct RawNumberFormatter;

struct FluentArgument {
  enum class Tag : uint8_t {
    Double_,
    String,
  };

  struct Double__Body {
    double _0;
  };

  struct String_Body {
    const nsCString *_0;
  };

  Tag tag;
  union {
    Double__Body double_;
    String_Body string;
  };

  static FluentArgument Double_(const double &_0) {
    FluentArgument result;
    ::new (&result.double_._0) (double)(_0);
    result.tag = Tag::Double_;
    return result;
  }

  bool IsDouble_() const {
    return tag == Tag::Double_;
  }

  static FluentArgument String(const nsCString *const &_0) {
    FluentArgument result;
    ::new (&result.string._0) (const nsCString*)(_0);
    result.tag = Tag::String;
    return result;
  }

  bool IsString() const {
    return tag == Tag::String;
  }
};

struct FluentNumberOptionsRaw {
  FluentNumberStyleRaw style;
  nsCString currency;
  FluentNumberCurrencyDisplayStyleRaw currency_display;
  bool use_grouping;
  uintptr_t minimum_integer_digits;
  uintptr_t minimum_fraction_digits;
  uintptr_t maximum_fraction_digits;
  intptr_t minimum_significant_digits;
  intptr_t maximum_significant_digits;
};

struct FluentDateTimeOptionsRaw {
  FluentDateTimeStyle date_style;
  FluentDateTimeStyle time_style;
  nsCString skeleton;
};

extern "C" {

FluentBundleRc *fluent_bundle_new_single(const nsACString *locale,
                                         bool use_isolating,
                                         const nsACString *pseudo_strategy);

FluentBundleRc *fluent_bundle_new(const nsCString *locales,
                                  uintptr_t locale_count,
                                  bool use_isolating,
                                  const nsACString *pseudo_strategy);

void fluent_bundle_get_locales(const FluentBundleRc *bundle, nsTArray<nsCString> *result);

void fluent_bundle_destroy(FluentBundleRc *bundle);

bool fluent_bundle_has_message(const FluentBundleRc *bundle, const nsACString *id);

bool fluent_bundle_get_message(const FluentBundleRc *bundle,
                               const nsACString *id,
                               bool *has_value,
                               nsTArray<nsCString> *attrs);

bool fluent_bundle_format_pattern(const FluentBundleRc *bundle,
                                  const nsACString *id,
                                  const nsACString *attr,
                                  const nsTArray<nsCString> *arg_ids,
                                  const nsTArray<FluentArgument> *arg_vals,
                                  nsACString *ret_val,
                                  nsTArray<nsCString> *ret_errors);

void fluent_bundle_add_resource(FluentBundleRc *bundle,
                                const FluentResource *r,
                                bool allow_overrides,
                                nsTArray<nsCString> *ret_errors);

extern RawNumberFormatter *FluentBuiltInNumberFormatterCreate(const nsCString *locale,
                                                              const FluentNumberOptionsRaw *options);

extern uint8_t *FluentBuiltInNumberFormatterFormat(const RawNumberFormatter *formatter,
                                                   double input,
                                                   uint32_t *out_count);

extern void FluentBuiltInNumberFormatterDestroy(RawNumberFormatter *formatter);

extern RawDateTimeFormatter *FluentBuiltInDateTimeFormatterCreate(const nsCString *locale,
                                                                  const FluentDateTimeOptionsRaw *options);

extern uint8_t *FluentBuiltInDateTimeFormatterFormat(const RawDateTimeFormatter *formatter,
                                                     double input,
                                                     uint32_t *out_count);

extern void FluentBuiltInDateTimeFormatterDestroy(RawDateTimeFormatter *formatter);

const FluentResource *fluent_resource_new(const nsACString *name, bool *has_errors);

void fluent_resource_addref(const FluentResource *res);

void fluent_resource_release(const FluentResource *res);

} // extern "C"

} // namespace ffi
} // namespace intl
} // namespace mozilla
