/* THIS FILE IS AUTOGENERATED FROM WebGPU.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_WebGPUBinding_h
#define mozilla_dom_WebGPUBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jsfriendapi.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/webgpu/BindGroupLayout.h"
#include "mozilla/webgpu/Buffer.h"
#include "mozilla/webgpu/Device.h"
#include "mozilla/webgpu/PipelineLayout.h"
#include "mozilla/webgpu/ShaderModule.h"
#include "mozilla/webgpu/Texture.h"
#include "mozilla/webgpu/TextureView.h"

namespace mozilla {

namespace dom {

struct GPUBindGroupDescriptorAtoms;
struct GPUBindGroupEntry;
struct GPUBindGroupEntryAtoms;
struct GPUBindGroupLayoutDescriptorAtoms;
struct GPUBindGroupLayoutEntry;
struct GPUBindGroupLayoutEntryAtoms;
struct GPUBlendDescriptor;
struct GPUBlendDescriptorAtoms;
struct GPUBufferBindingAtoms;
struct GPUBufferCopyViewAtoms;
struct GPUBufferDescriptorAtoms;
class GPUBufferUsage;
struct GPUBufferUsageAtoms;
struct GPUColorDictAtoms;
struct GPUColorStateDescriptor;
struct GPUColorStateDescriptorAtoms;
class GPUColorWrite;
struct GPUColorWriteAtoms;
struct GPUComputePipelineDescriptorAtoms;
struct GPUDepthStencilStateDescriptor;
struct GPUDepthStencilStateDescriptorAtoms;
struct GPUDeviceDescriptorAtoms;
struct GPUExtensions;
struct GPUExtensionsAtoms;
struct GPUExtent3DDictAtoms;
struct GPUFenceDescriptorAtoms;
struct GPUImageBitmapCopyViewAtoms;
struct GPULimits;
struct GPULimitsAtoms;
class GPULoadOpOrDoubleSequenceOrGPUColorDict;
class GPULoadOpOrFloat;
class GPULoadOpOrUnsignedLong;
struct GPUObjectDescriptorBaseAtoms;
struct GPUOrigin2DDictAtoms;
struct GPUOrigin3DDictAtoms;
struct GPUPipelineDescriptorBaseAtoms;
struct GPUPipelineLayoutDescriptorAtoms;
struct GPUProgrammableStageDescriptor;
struct GPUProgrammableStageDescriptorAtoms;
struct GPURasterizationStateDescriptor;
struct GPURasterizationStateDescriptorAtoms;
struct GPURenderBundleEncoderDescriptorAtoms;
struct GPURenderPassColorAttachmentDescriptor;
struct GPURenderPassColorAttachmentDescriptorAtoms;
struct GPURenderPassDepthStencilAttachmentDescriptor;
struct GPURenderPassDepthStencilAttachmentDescriptorAtoms;
struct GPURenderPassDescriptorAtoms;
struct GPURenderPipelineDescriptorAtoms;
struct GPURequestAdapterOptionsAtoms;
struct GPUSamplerDescriptorAtoms;
class GPUSamplerOrGPUTextureViewOrGPUBufferBinding;
struct GPUShaderModuleDescriptorAtoms;
class GPUShaderStage;
struct GPUShaderStageAtoms;
struct GPUStencilStateFaceDescriptor;
struct GPUStencilStateFaceDescriptorAtoms;
struct GPUSwapChainDescriptorAtoms;
struct GPUTextureCopyViewAtoms;
struct GPUTextureDescriptorAtoms;
class GPUTextureUsage;
struct GPUTextureUsageAtoms;
struct GPUTextureViewDescriptorAtoms;
struct GPUVertexAttributeDescriptor;
struct GPUVertexAttributeDescriptorAtoms;
struct GPUVertexBufferLayoutDescriptor;
struct GPUVertexBufferLayoutDescriptorAtoms;
struct GPUVertexStateDescriptor;
struct GPUVertexStateDescriptorAtoms;
struct NativePropertyHooks;
class OwningGPULoadOpOrDoubleSequenceOrGPUColorDict;
class OwningGPULoadOpOrFloat;
class OwningGPULoadOpOrUnsignedLong;
class OwningGPUOutOfMemoryErrorOrGPUValidationError;
class OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding;
class OwningUint32ArrayOrString;
class OwningUnsignedLongSequenceOrGPUExtent3DDict;
class OwningUnsignedLongSequenceOrGPUOrigin2DDict;
class OwningUnsignedLongSequenceOrGPUOrigin3DDict;
class ProtoAndIfaceCache;
class Uint32ArrayOrString;
class UnsignedLongSequenceOrGPUExtent3DDict;
class UnsignedLongSequenceOrGPUOrigin2DDict;
class UnsignedLongSequenceOrGPUOrigin3DDict;

} // namespace dom

namespace webgpu {

class Adapter;
struct AdapterAtoms;
class BindGroup;
struct BindGroupAtoms;
class BindGroupLayout;
struct BindGroupLayoutAtoms;
class Buffer;
struct BufferAtoms;
class CanvasContext;
struct CanvasContextAtoms;
class CommandBuffer;
struct CommandBufferAtoms;
class CommandEncoder;
struct CommandEncoderAtoms;
class ComputePassEncoder;
struct ComputePassEncoderAtoms;
class ComputePipeline;
struct ComputePipelineAtoms;
class Device;
struct DeviceAtoms;
class DeviceLostInfo;
struct DeviceLostInfoAtoms;
class Fence;
struct FenceAtoms;
class Instance;
struct InstanceAtoms;
class OutOfMemoryError;
struct OutOfMemoryErrorAtoms;
class PipelineLayout;
struct PipelineLayoutAtoms;
class Queue;
struct QueueAtoms;
class RenderBundle;
struct RenderBundleAtoms;
class RenderBundleEncoder;
struct RenderBundleEncoderAtoms;
class RenderPassEncoder;
struct RenderPassEncoderAtoms;
class RenderPipeline;
struct RenderPipelineAtoms;
class Sampler;
struct SamplerAtoms;
class ShaderModule;
struct ShaderModuleAtoms;
class SwapChain;
struct SwapChainAtoms;
class Texture;
struct TextureAtoms;
class TextureView;
struct TextureViewAtoms;
class ValidationError;
struct ValidationErrorAtoms;

} // namespace webgpu

} // namespace mozilla

namespace mozilla {
namespace dom {

enum class GPUPowerPreference : uint8_t {
  Low_power,
  High_performance,
  EndGuard_
};

namespace GPUPowerPreferenceValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUPowerPreference::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUPowerPreference stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUPowerPreferenceValues

bool
ToJSValue(JSContext* aCx, GPUPowerPreference aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUErrorFilter : uint8_t {
  None,
  Out_of_memory,
  Validation,
  EndGuard_
};

namespace GPUErrorFilterValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUErrorFilter::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUErrorFilter stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUErrorFilterValues

bool
ToJSValue(JSContext* aCx, GPUErrorFilter aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureDimension : uint8_t {
  _1d,
  _2d,
  _3d,
  EndGuard_
};

namespace GPUTextureDimensionValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureDimension::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUTextureDimension stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUTextureDimensionValues

bool
ToJSValue(JSContext* aCx, GPUTextureDimension aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureFormat : uint8_t {
  R8unorm,
  R8snorm,
  R8uint,
  R8sint,
  R16uint,
  R16sint,
  R16float,
  Rg8unorm,
  Rg8snorm,
  Rg8uint,
  Rg8sint,
  R32uint,
  R32sint,
  R32float,
  Rg16uint,
  Rg16sint,
  Rg16float,
  Rgba8unorm,
  Rgba8unorm_srgb,
  Rgba8snorm,
  Rgba8uint,
  Rgba8sint,
  Bgra8unorm,
  Bgra8unorm_srgb,
  Rgb10a2unorm,
  Rg11b10float,
  Rg32uint,
  Rg32sint,
  Rg32float,
  Rgba16uint,
  Rgba16sint,
  Rgba16float,
  Rgba32uint,
  Rgba32sint,
  Rgba32float,
  Depth32float,
  Depth24plus,
  Depth24plus_stencil8,
  EndGuard_
};

namespace GPUTextureFormatValues {
extern const EnumEntry strings[39];

static constexpr size_t Count = 38;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUTextureFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUTextureFormatValues

bool
ToJSValue(JSContext* aCx, GPUTextureFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureViewDimension : uint8_t {
  _1d,
  _2d,
  _2d_array,
  Cube,
  Cube_array,
  _3d,
  EndGuard_
};

namespace GPUTextureViewDimensionValues {
extern const EnumEntry strings[7];

static constexpr size_t Count = 6;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureViewDimension::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUTextureViewDimension stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUTextureViewDimensionValues

bool
ToJSValue(JSContext* aCx, GPUTextureViewDimension aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureAspect : uint8_t {
  All,
  Stencil_only,
  Depth_only,
  EndGuard_
};

namespace GPUTextureAspectValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureAspect::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUTextureAspect stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUTextureAspectValues

bool
ToJSValue(JSContext* aCx, GPUTextureAspect aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUAddressMode : uint8_t {
  Clamp_to_edge,
  Repeat,
  Mirror_repeat,
  EndGuard_
};

namespace GPUAddressModeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUAddressMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUAddressMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUAddressModeValues

bool
ToJSValue(JSContext* aCx, GPUAddressMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUFilterMode : uint8_t {
  Nearest,
  Linear,
  EndGuard_
};

namespace GPUFilterModeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUFilterMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUFilterMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUFilterModeValues

bool
ToJSValue(JSContext* aCx, GPUFilterMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCompareFunction : uint8_t {
  Never,
  Less,
  Equal,
  Less_equal,
  Greater,
  Not_equal,
  Greater_equal,
  Always,
  EndGuard_
};

namespace GPUCompareFunctionValues {
extern const EnumEntry strings[9];

static constexpr size_t Count = 8;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUCompareFunction::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUCompareFunction stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUCompareFunctionValues

bool
ToJSValue(JSContext* aCx, GPUCompareFunction aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUTextureComponentType : uint8_t {
  Float,
  Sint,
  Uint,
  EndGuard_
};

namespace GPUTextureComponentTypeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUTextureComponentType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUTextureComponentType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUTextureComponentTypeValues

bool
ToJSValue(JSContext* aCx, GPUTextureComponentType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBindingType : uint8_t {
  Uniform_buffer,
  Storage_buffer,
  Readonly_storage_buffer,
  Sampler,
  Comparison_sampler,
  Sampled_texture,
  Readonly_storage_texture,
  Writeonly_storage_texture,
  EndGuard_
};

namespace GPUBindingTypeValues {
extern const EnumEntry strings[9];

static constexpr size_t Count = 8;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUBindingType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUBindingType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUBindingTypeValues

bool
ToJSValue(JSContext* aCx, GPUBindingType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBlendFactor : uint8_t {
  Zero,
  One,
  Src_color,
  One_minus_src_color,
  Src_alpha,
  One_minus_src_alpha,
  Dst_color,
  One_minus_dst_color,
  Dst_alpha,
  One_minus_dst_alpha,
  Src_alpha_saturated,
  Blend_color,
  One_minus_blend_color,
  EndGuard_
};

namespace GPUBlendFactorValues {
extern const EnumEntry strings[14];

static constexpr size_t Count = 13;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUBlendFactor::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUBlendFactor stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUBlendFactorValues

bool
ToJSValue(JSContext* aCx, GPUBlendFactor aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUBlendOperation : uint8_t {
  Add,
  Subtract,
  Reverse_subtract,
  Min,
  Max,
  EndGuard_
};

namespace GPUBlendOperationValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUBlendOperation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUBlendOperation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUBlendOperationValues

bool
ToJSValue(JSContext* aCx, GPUBlendOperation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUStencilOperation : uint8_t {
  Keep,
  Zero,
  Replace,
  Invert,
  Increment_clamp,
  Decrement_clamp,
  Increment_wrap,
  Decrement_wrap,
  EndGuard_
};

namespace GPUStencilOperationValues {
extern const EnumEntry strings[9];

static constexpr size_t Count = 8;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUStencilOperation::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUStencilOperation stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUStencilOperationValues

bool
ToJSValue(JSContext* aCx, GPUStencilOperation aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUIndexFormat : uint8_t {
  Uint16,
  Uint32,
  EndGuard_
};

namespace GPUIndexFormatValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUIndexFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUIndexFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUIndexFormatValues

bool
ToJSValue(JSContext* aCx, GPUIndexFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUVertexFormat : uint8_t {
  Uchar2,
  Uchar4,
  Char2,
  Char4,
  Uchar2norm,
  Uchar4norm,
  Char2norm,
  Char4norm,
  Ushort2,
  Ushort4,
  Short2,
  Short4,
  Ushort2norm,
  Ushort4norm,
  Short2norm,
  Short4norm,
  Half2,
  Half4,
  Float,
  Float2,
  Float3,
  Float4,
  Uint,
  Uint2,
  Uint3,
  Uint4,
  Int,
  Int2,
  Int3,
  Int4,
  EndGuard_
};

namespace GPUVertexFormatValues {
extern const EnumEntry strings[31];

static constexpr size_t Count = 30;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUVertexFormat::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUVertexFormat stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUVertexFormatValues

bool
ToJSValue(JSContext* aCx, GPUVertexFormat aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUInputStepMode : uint8_t {
  Vertex,
  Instance,
  EndGuard_
};

namespace GPUInputStepModeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUInputStepMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUInputStepMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUInputStepModeValues

bool
ToJSValue(JSContext* aCx, GPUInputStepMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUPrimitiveTopology : uint8_t {
  Point_list,
  Line_list,
  Line_strip,
  Triangle_list,
  Triangle_strip,
  EndGuard_
};

namespace GPUPrimitiveTopologyValues {
extern const EnumEntry strings[6];

static constexpr size_t Count = 5;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUPrimitiveTopology::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUPrimitiveTopology stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUPrimitiveTopologyValues

bool
ToJSValue(JSContext* aCx, GPUPrimitiveTopology aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUFrontFace : uint8_t {
  Ccw,
  Cw,
  EndGuard_
};

namespace GPUFrontFaceValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUFrontFace::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUFrontFace stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUFrontFaceValues

bool
ToJSValue(JSContext* aCx, GPUFrontFace aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUCullMode : uint8_t {
  None,
  Front,
  Back,
  EndGuard_
};

namespace GPUCullModeValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUCullMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUCullMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUCullModeValues

bool
ToJSValue(JSContext* aCx, GPUCullMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPULoadOp : uint8_t {
  Load,
  EndGuard_
};

namespace GPULoadOpValues {
extern const EnumEntry strings[2];

static constexpr size_t Count = 1;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPULoadOp::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPULoadOp stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPULoadOpValues

bool
ToJSValue(JSContext* aCx, GPULoadOp aArgument, JS::MutableHandle<JS::Value> aValue);


enum class GPUStoreOp : uint8_t {
  Store,
  Clear,
  EndGuard_
};

namespace GPUStoreOpValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(GPUStoreOp::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(GPUStoreOp stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace GPUStoreOpValues

bool
ToJSValue(JSContext* aCx, GPUStoreOp aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningGPUOutOfMemoryErrorOrGPUValidationError& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningGPUOutOfMemoryErrorOrGPUValidationError& aUnion);


void
ImplCycleCollectionUnlink(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion);


struct GPUBindGroupLayoutEntry : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBinding;
  MOZ_INIT_OUTSIDE_CTOR bool mHasDynamicOffset;
  MOZ_INIT_OUTSIDE_CTOR bool mMultisampled;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureFormat> mStorageTextureFormat;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureComponentType mTextureComponentType;
  MOZ_INIT_OUTSIDE_CTOR GPUBindingType mType;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureViewDimension mViewDimension;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mVisibility;

  GPUBindGroupLayoutEntry();

  explicit inline GPUBindGroupLayoutEntry(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUBindGroupLayoutEntry(const GPUBindGroupLayoutEntry& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBindGroupLayoutEntry&
  operator=(const GPUBindGroupLayoutEntry& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupLayoutEntryAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupLayoutEntry : public GPUBindGroupLayoutEntry
{
  inline FastGPUBindGroupLayoutEntry()
    : GPUBindGroupLayoutEntry(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBlendDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUBlendFactor mDstFactor;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendOperation mOperation;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendFactor mSrcFactor;

  GPUBlendDescriptor();

  explicit inline GPUBlendDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUBlendDescriptor(const GPUBlendDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBlendDescriptor&
  operator=(const GPUBlendDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBlendDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBlendDescriptor : public GPUBlendDescriptor
{
  inline FastGPUBlendDescriptor()
    : GPUBlendDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferBinding : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Buffer> mBuffer;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mSize;

  GPUBufferBinding();

  explicit inline GPUBufferBinding(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUBufferBinding(const GPUBufferBinding& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBuffer, "mBuffer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBuffer);
  }

  GPUBufferBinding&
  operator=(const GPUBufferBinding& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBufferBindingAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferBinding : public GPUBufferBinding
{
  inline FastGPUBufferBinding()
    : GPUBufferBinding(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferCopyView : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Buffer> mBuffer;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBytesPerRow;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mRowsPerImage;

  GPUBufferCopyView();

  explicit inline GPUBufferCopyView(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUBufferCopyView(const GPUBufferCopyView& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBuffer, "mBuffer", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBuffer);
  }

  GPUBufferCopyView&
  operator=(const GPUBufferCopyView& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBufferCopyViewAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferCopyView : public GPUBufferCopyView
{
  inline FastGPUBufferCopyView()
    : GPUBufferCopyView(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBufferDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mSize;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;

  GPUBufferDescriptor();

  explicit inline GPUBufferDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUBufferDescriptor(const GPUBufferDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBufferDescriptor&
  operator=(const GPUBufferDescriptor& aOther);

  bool
  operator==(const GPUBufferDescriptor& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUBufferDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBufferDescriptor : public GPUBufferDescriptor
{
  inline FastGPUBufferDescriptor()
    : GPUBufferDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUColorDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR double mA;
  MOZ_INIT_OUTSIDE_CTOR double mB;
  MOZ_INIT_OUTSIDE_CTOR double mG;
  MOZ_INIT_OUTSIDE_CTOR double mR;

  GPUColorDict();

  explicit inline GPUColorDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUColorDict(const GPUColorDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUColorDict&
  operator=(const GPUColorDict& aOther);

  bool
  operator==(const GPUColorDict& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUColorDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUColorDict : public GPUColorDict
{
  inline FastGPUColorDict()
    : GPUColorDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUExtensions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAnisotropicFiltering;

  GPUExtensions();

  explicit inline GPUExtensions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUExtensions(const GPUExtensions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUExtensions&
  operator=(const GPUExtensions& aOther);

  bool
  operator==(const GPUExtensions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUExtensionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUExtensions : public GPUExtensions
{
  inline FastGPUExtensions()
    : GPUExtensions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUExtent3DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mDepth;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  GPUExtent3DDict();

  explicit inline GPUExtent3DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUExtent3DDict(const GPUExtent3DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUExtent3DDict&
  operator=(const GPUExtent3DDict& aOther);

  bool
  operator==(const GPUExtent3DDict& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUExtent3DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUExtent3DDict : public GPUExtent3DDict
{
  inline FastGPUExtent3DDict()
    : GPUExtent3DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPULimits : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMaxBindGroups;

  GPULimits();

  explicit inline GPULimits(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPULimits(const GPULimits& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPULimits&
  operator=(const GPULimits& aOther);

  bool
  operator==(const GPULimits& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPULimitsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPULimits : public GPULimits
{
  inline FastGPULimits()
    : GPULimits(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class GPULoadOpOrFloat
{
  friend class GPULoadOpOrFloatArgument;
  enum Type
  {
    eUninitialized,
    eGPULoadOp,
    eFloat
  };

  union Value
  {
    UnionMember<GPULoadOp > mGPULoadOp;
    UnionMember<float > mFloat;

  };

  Type mType;
  Value mValue;

  GPULoadOpOrFloat(const GPULoadOpOrFloat&) = delete;
  GPULoadOpOrFloat& operator=(const GPULoadOpOrFloat&) = delete;
public:
  explicit inline GPULoadOpOrFloat()
    : mType(eUninitialized)
  {
  }

  inline ~GPULoadOpOrFloat()
  {
    Uninit();
  }

  inline GPULoadOp&
  RawSetAsGPULoadOp()
  {
    if (mType == eGPULoadOp) {
      return mValue.mGPULoadOp.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPULoadOp;
    return mValue.mGPULoadOp.SetValue();
  }

  inline GPULoadOp&
  SetAsGPULoadOp()
  {
    if (mType == eGPULoadOp) {
      return mValue.mGPULoadOp.Value();
    }
    Uninit();
    mType = eGPULoadOp;
    return mValue.mGPULoadOp.SetValue();
  }

  inline bool
  IsGPULoadOp() const
  {
    return mType == eGPULoadOp;
  }

  inline GPULoadOp&
  GetAsGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline GPULoadOp
  GetAsGPULoadOp() const
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline float&
  RawSetAsFloat()
  {
    if (mType == eFloat) {
      return mValue.mFloat.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFloat;
    return mValue.mFloat.SetValue();
  }

  inline float&
  SetAsFloat()
  {
    if (mType == eFloat) {
      return mValue.mFloat.Value();
    }
    Uninit();
    mType = eFloat;
    return mValue.mFloat.SetValue();
  }

  inline bool
  IsFloat() const
  {
    return mType == eFloat;
  }

  inline float&
  GetAsFloat()
  {
    MOZ_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  inline float
  GetAsFloat() const
  {
    MOZ_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPULoadOp: {
        DestroyGPULoadOp();
        break;
      }
      case eFloat: {
        DestroyFloat();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    mValue.mGPULoadOp.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyFloat()
  {
    MOZ_ASSERT(IsFloat(), "Wrong type!");
    mValue.mFloat.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPULoadOpOrFloat : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPULoadOpOrFloat& aUnion);
  enum Type
  {
    eUninitialized,
    eGPULoadOp,
    eFloat
  };

  union Value
  {
    UnionMember<GPULoadOp > mGPULoadOp;
    UnionMember<float > mFloat;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningGPULoadOpOrFloat()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningGPULoadOpOrFloat(const OwningGPULoadOpOrFloat& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPULoadOpOrFloat()
  {
    Uninit();
  }

  GPULoadOp&
  RawSetAsGPULoadOp();

  GPULoadOp&
  SetAsGPULoadOp();

  bool
  TrySetToGPULoadOp(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPULoadOp(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPULoadOp() const
  {
    return mType == eGPULoadOp;
  }

  inline GPULoadOp&
  GetAsGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline GPULoadOp const &
  GetAsGPULoadOp() const
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  float&
  RawSetAsFloat();

  float&
  SetAsFloat();

  bool
  TrySetToFloat(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFloat(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsFloat() const
  {
    return mType == eFloat;
  }

  inline float&
  GetAsFloat()
  {
    MOZ_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  inline float const &
  GetAsFloat() const
  {
    MOZ_ASSERT(IsFloat(), "Wrong type!");
    return mValue.mFloat.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningGPULoadOpOrFloat&
  operator=(const OwningGPULoadOpOrFloat& aOther);

private:
  void
  DestroyGPULoadOp();

  void
  DestroyFloat();
};


class GPULoadOpOrUnsignedLong
{
  friend class GPULoadOpOrUnsignedLongArgument;
  enum Type
  {
    eUninitialized,
    eGPULoadOp,
    eUnsignedLong
  };

  union Value
  {
    UnionMember<GPULoadOp > mGPULoadOp;
    UnionMember<uint32_t > mUnsignedLong;

  };

  Type mType;
  Value mValue;

  GPULoadOpOrUnsignedLong(const GPULoadOpOrUnsignedLong&) = delete;
  GPULoadOpOrUnsignedLong& operator=(const GPULoadOpOrUnsignedLong&) = delete;
public:
  explicit inline GPULoadOpOrUnsignedLong()
    : mType(eUninitialized)
  {
  }

  inline ~GPULoadOpOrUnsignedLong()
  {
    Uninit();
  }

  inline GPULoadOp&
  RawSetAsGPULoadOp()
  {
    if (mType == eGPULoadOp) {
      return mValue.mGPULoadOp.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPULoadOp;
    return mValue.mGPULoadOp.SetValue();
  }

  inline GPULoadOp&
  SetAsGPULoadOp()
  {
    if (mType == eGPULoadOp) {
      return mValue.mGPULoadOp.Value();
    }
    Uninit();
    mType = eGPULoadOp;
    return mValue.mGPULoadOp.SetValue();
  }

  inline bool
  IsGPULoadOp() const
  {
    return mType == eGPULoadOp;
  }

  inline GPULoadOp&
  GetAsGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline GPULoadOp
  GetAsGPULoadOp() const
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline uint32_t&
  RawSetAsUnsignedLong()
  {
    if (mType == eUnsignedLong) {
      return mValue.mUnsignedLong.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnsignedLong;
    return mValue.mUnsignedLong.SetValue();
  }

  inline uint32_t&
  SetAsUnsignedLong()
  {
    if (mType == eUnsignedLong) {
      return mValue.mUnsignedLong.Value();
    }
    Uninit();
    mType = eUnsignedLong;
    return mValue.mUnsignedLong.SetValue();
  }

  inline bool
  IsUnsignedLong() const
  {
    return mType == eUnsignedLong;
  }

  inline uint32_t&
  GetAsUnsignedLong()
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  inline uint32_t
  GetAsUnsignedLong() const
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPULoadOp: {
        DestroyGPULoadOp();
        break;
      }
      case eUnsignedLong: {
        DestroyUnsignedLong();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    mValue.mGPULoadOp.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyUnsignedLong()
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    mValue.mUnsignedLong.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPULoadOpOrUnsignedLong : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPULoadOpOrUnsignedLong& aUnion);
  enum Type
  {
    eUninitialized,
    eGPULoadOp,
    eUnsignedLong
  };

  union Value
  {
    UnionMember<GPULoadOp > mGPULoadOp;
    UnionMember<uint32_t > mUnsignedLong;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningGPULoadOpOrUnsignedLong()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningGPULoadOpOrUnsignedLong(const OwningGPULoadOpOrUnsignedLong& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPULoadOpOrUnsignedLong()
  {
    Uninit();
  }

  GPULoadOp&
  RawSetAsGPULoadOp();

  GPULoadOp&
  SetAsGPULoadOp();

  bool
  TrySetToGPULoadOp(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPULoadOp(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPULoadOp() const
  {
    return mType == eGPULoadOp;
  }

  inline GPULoadOp&
  GetAsGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline GPULoadOp const &
  GetAsGPULoadOp() const
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  uint32_t&
  RawSetAsUnsignedLong();

  uint32_t&
  SetAsUnsignedLong();

  bool
  TrySetToUnsignedLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUnsignedLong() const
  {
    return mType == eUnsignedLong;
  }

  inline uint32_t&
  GetAsUnsignedLong()
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  inline uint32_t const &
  GetAsUnsignedLong() const
  {
    MOZ_ASSERT(IsUnsignedLong(), "Wrong type!");
    return mValue.mUnsignedLong.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningGPULoadOpOrUnsignedLong&
  operator=(const OwningGPULoadOpOrUnsignedLong& aOther);

private:
  void
  DestroyGPULoadOp();

  void
  DestroyUnsignedLong();
};


struct GPUObjectDescriptorBase : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mLabel;

  GPUObjectDescriptorBase();

  explicit inline GPUObjectDescriptorBase(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUObjectDescriptorBase(const GPUObjectDescriptorBase& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUObjectDescriptorBase&
  operator=(const GPUObjectDescriptorBase& aOther);

  bool
  operator==(const GPUObjectDescriptorBase& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUObjectDescriptorBaseAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUObjectDescriptorBase : public GPUObjectDescriptorBase
{
  inline FastGPUObjectDescriptorBase()
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUOrigin2DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mX;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mY;

  GPUOrigin2DDict();

  explicit inline GPUOrigin2DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUOrigin2DDict(const GPUOrigin2DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUOrigin2DDict&
  operator=(const GPUOrigin2DDict& aOther);

  bool
  operator==(const GPUOrigin2DDict& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUOrigin2DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUOrigin2DDict : public GPUOrigin2DDict
{
  inline FastGPUOrigin2DDict()
    : GPUOrigin2DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUOrigin3DDict : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mX;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mY;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mZ;

  GPUOrigin3DDict();

  explicit inline GPUOrigin3DDict(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUOrigin3DDict(const GPUOrigin3DDict& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUOrigin3DDict&
  operator=(const GPUOrigin3DDict& aOther);

  bool
  operator==(const GPUOrigin3DDict& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUOrigin3DDictAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUOrigin3DDict : public GPUOrigin3DDict
{
  inline FastGPUOrigin3DDict()
    : GPUOrigin3DDict(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class GPUOutOfMemoryErrorOrGPUValidationError
{
  friend class GPUOutOfMemoryErrorOrGPUValidationErrorArgument;
  enum Type
  {
    eUninitialized,
    eGPUOutOfMemoryError,
    eGPUValidationError
  };

  union Value
  {
    UnionMember<NonNull<mozilla::webgpu::OutOfMemoryError> > mGPUOutOfMemoryError;
    UnionMember<NonNull<mozilla::webgpu::ValidationError> > mGPUValidationError;

  };

  Type mType;
  Value mValue;

  GPUOutOfMemoryErrorOrGPUValidationError(const GPUOutOfMemoryErrorOrGPUValidationError&) = delete;
  GPUOutOfMemoryErrorOrGPUValidationError& operator=(const GPUOutOfMemoryErrorOrGPUValidationError&) = delete;
public:
  explicit inline GPUOutOfMemoryErrorOrGPUValidationError()
    : mType(eUninitialized)
  {
  }

  inline ~GPUOutOfMemoryErrorOrGPUValidationError()
  {
    Uninit();
  }

  inline NonNull<mozilla::webgpu::OutOfMemoryError>&
  RawSetAsGPUOutOfMemoryError()
  {
    if (mType == eGPUOutOfMemoryError) {
      return mValue.mGPUOutOfMemoryError.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUOutOfMemoryError;
    return mValue.mGPUOutOfMemoryError.SetValue();
  }

  inline NonNull<mozilla::webgpu::OutOfMemoryError>&
  SetAsGPUOutOfMemoryError()
  {
    if (mType == eGPUOutOfMemoryError) {
      return mValue.mGPUOutOfMemoryError.Value();
    }
    Uninit();
    mType = eGPUOutOfMemoryError;
    return mValue.mGPUOutOfMemoryError.SetValue();
  }

  inline bool
  IsGPUOutOfMemoryError() const
  {
    return mType == eGPUOutOfMemoryError;
  }

  inline NonNull<mozilla::webgpu::OutOfMemoryError>&
  GetAsGPUOutOfMemoryError()
  {
    MOZ_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    return mValue.mGPUOutOfMemoryError.Value();
  }

  inline mozilla::webgpu::OutOfMemoryError&
  GetAsGPUOutOfMemoryError() const
  {
    MOZ_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    return mValue.mGPUOutOfMemoryError.Value();
  }

  inline NonNull<mozilla::webgpu::ValidationError>&
  RawSetAsGPUValidationError()
  {
    if (mType == eGPUValidationError) {
      return mValue.mGPUValidationError.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUValidationError;
    return mValue.mGPUValidationError.SetValue();
  }

  inline NonNull<mozilla::webgpu::ValidationError>&
  SetAsGPUValidationError()
  {
    if (mType == eGPUValidationError) {
      return mValue.mGPUValidationError.Value();
    }
    Uninit();
    mType = eGPUValidationError;
    return mValue.mGPUValidationError.SetValue();
  }

  inline bool
  IsGPUValidationError() const
  {
    return mType == eGPUValidationError;
  }

  inline NonNull<mozilla::webgpu::ValidationError>&
  GetAsGPUValidationError()
  {
    MOZ_ASSERT(IsGPUValidationError(), "Wrong type!");
    return mValue.mGPUValidationError.Value();
  }

  inline mozilla::webgpu::ValidationError&
  GetAsGPUValidationError() const
  {
    MOZ_ASSERT(IsGPUValidationError(), "Wrong type!");
    return mValue.mGPUValidationError.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPUOutOfMemoryError: {
        DestroyGPUOutOfMemoryError();
        break;
      }
      case eGPUValidationError: {
        DestroyGPUValidationError();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyGPUOutOfMemoryError()
  {
    MOZ_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    mValue.mGPUOutOfMemoryError.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyGPUValidationError()
  {
    MOZ_ASSERT(IsGPUValidationError(), "Wrong type!");
    mValue.mGPUValidationError.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPUOutOfMemoryErrorOrGPUValidationError : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPUOutOfMemoryErrorOrGPUValidationError& aUnion);
  enum Type
  {
    eUninitialized,
    eGPUOutOfMemoryError,
    eGPUValidationError
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::webgpu::OutOfMemoryError> > mGPUOutOfMemoryError;
    UnionMember<OwningNonNull<mozilla::webgpu::ValidationError> > mGPUValidationError;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningGPUOutOfMemoryErrorOrGPUValidationError()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningGPUOutOfMemoryErrorOrGPUValidationError(const OwningGPUOutOfMemoryErrorOrGPUValidationError& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPUOutOfMemoryErrorOrGPUValidationError()
  {
    Uninit();
  }

  OwningNonNull<mozilla::webgpu::OutOfMemoryError>&
  RawSetAsGPUOutOfMemoryError();

  OwningNonNull<mozilla::webgpu::OutOfMemoryError>&
  SetAsGPUOutOfMemoryError();

  bool
  TrySetToGPUOutOfMemoryError(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOutOfMemoryError(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPUOutOfMemoryError() const
  {
    return mType == eGPUOutOfMemoryError;
  }

  inline OwningNonNull<mozilla::webgpu::OutOfMemoryError>&
  GetAsGPUOutOfMemoryError()
  {
    MOZ_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    return mValue.mGPUOutOfMemoryError.Value();
  }

  inline OwningNonNull<mozilla::webgpu::OutOfMemoryError> const &
  GetAsGPUOutOfMemoryError() const
  {
    MOZ_ASSERT(IsGPUOutOfMemoryError(), "Wrong type!");
    return mValue.mGPUOutOfMemoryError.Value();
  }

  OwningNonNull<mozilla::webgpu::ValidationError>&
  RawSetAsGPUValidationError();

  OwningNonNull<mozilla::webgpu::ValidationError>&
  SetAsGPUValidationError();

  bool
  TrySetToGPUValidationError(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUValidationError(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPUValidationError() const
  {
    return mType == eGPUValidationError;
  }

  inline OwningNonNull<mozilla::webgpu::ValidationError>&
  GetAsGPUValidationError()
  {
    MOZ_ASSERT(IsGPUValidationError(), "Wrong type!");
    return mValue.mGPUValidationError.Value();
  }

  inline OwningNonNull<mozilla::webgpu::ValidationError> const &
  GetAsGPUValidationError() const
  {
    MOZ_ASSERT(IsGPUValidationError(), "Wrong type!");
    return mValue.mGPUValidationError.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningGPUOutOfMemoryErrorOrGPUValidationError&
  operator=(const OwningGPUOutOfMemoryErrorOrGPUValidationError& aOther);

private:
  void
  DestroyGPUOutOfMemoryError();

  void
  DestroyGPUValidationError();
};


struct GPUProgrammableStageDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mEntryPoint;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::ShaderModule> mModule;

  GPUProgrammableStageDescriptor();

  explicit inline GPUProgrammableStageDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUProgrammableStageDescriptor(const GPUProgrammableStageDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mModule, "mModule", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mModule);
  }

  GPUProgrammableStageDescriptor&
  operator=(const GPUProgrammableStageDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUProgrammableStageDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUProgrammableStageDescriptor : public GPUProgrammableStageDescriptor
{
  inline FastGPUProgrammableStageDescriptor()
    : GPUProgrammableStageDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURasterizationStateDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUCullMode mCullMode;
  MOZ_INIT_OUTSIDE_CTOR int32_t mDepthBias;
  MOZ_INIT_OUTSIDE_CTOR float mDepthBiasClamp;
  MOZ_INIT_OUTSIDE_CTOR float mDepthBiasSlopeScale;
  MOZ_INIT_OUTSIDE_CTOR GPUFrontFace mFrontFace;

  GPURasterizationStateDescriptor();

  explicit inline GPURasterizationStateDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPURasterizationStateDescriptor(const GPURasterizationStateDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURasterizationStateDescriptor&
  operator=(const GPURasterizationStateDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURasterizationStateDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURasterizationStateDescriptor : public GPURasterizationStateDescriptor
{
  inline FastGPURasterizationStateDescriptor()
    : GPURasterizationStateDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURequestAdapterOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUPowerPreference> mPowerPreference;

  GPURequestAdapterOptions();

  explicit inline GPURequestAdapterOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPURequestAdapterOptions(const GPURequestAdapterOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURequestAdapterOptions&
  operator=(const GPURequestAdapterOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURequestAdapterOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURequestAdapterOptions : public GPURequestAdapterOptions
{
  inline FastGPURequestAdapterOptions()
    : GPURequestAdapterOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUStencilStateFaceDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUCompareFunction mCompare;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mDepthFailOp;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mFailOp;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilOperation mPassOp;

  GPUStencilStateFaceDescriptor();

  explicit inline GPUStencilStateFaceDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUStencilStateFaceDescriptor(const GPUStencilStateFaceDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUStencilStateFaceDescriptor&
  operator=(const GPUStencilStateFaceDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUStencilStateFaceDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUStencilStateFaceDescriptor : public GPUStencilStateFaceDescriptor
{
  inline FastGPUStencilStateFaceDescriptor()
    : GPUStencilStateFaceDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexAttributeDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUVertexFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mShaderLocation;

  GPUVertexAttributeDescriptor();

  explicit inline GPUVertexAttributeDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUVertexAttributeDescriptor(const GPUVertexAttributeDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUVertexAttributeDescriptor&
  operator=(const GPUVertexAttributeDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUVertexAttributeDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUVertexAttributeDescriptor : public GPUVertexAttributeDescriptor
{
  inline FastGPUVertexAttributeDescriptor()
    : GPUVertexAttributeDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class Uint32ArrayOrString
{
  friend class Uint32ArrayOrStringArgument;
  enum Type
  {
    eUninitialized,
    eUint32Array,
    eString
  };

  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<Uint32Array> > mUint32Array;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  Type mType;
  Value mValue;

  Uint32ArrayOrString(const Uint32ArrayOrString&) = delete;
  Uint32ArrayOrString& operator=(const Uint32ArrayOrString&) = delete;
public:
  explicit inline Uint32ArrayOrString()
    : mType(eUninitialized)
  {
  }

  inline ~Uint32ArrayOrString()
  {
    Uninit();
  }

  inline RootedSpiderMonkeyInterface<Uint32Array>&
  RawSetAsUint32Array(JSContext* cx)
  {
    if (mType == eUint32Array) {
      return mValue.mUint32Array.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUint32Array;
    return mValue.mUint32Array.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<Uint32Array>&
  SetAsUint32Array(JSContext* cx)
  {
    if (mType == eUint32Array) {
      return mValue.mUint32Array.Value();
    }
    Uninit();
    mType = eUint32Array;
    return mValue.mUint32Array.SetValue(cx);
  }

  inline bool
  IsUint32Array() const
  {
    return mType == eUint32Array;
  }

  inline RootedSpiderMonkeyInterface<Uint32Array>&
  GetAsUint32Array()
  {
    MOZ_ASSERT(IsUint32Array(), "Wrong type!");
    return mValue.mUint32Array.Value();
  }

  inline Uint32Array const &
  GetAsUint32Array() const
  {
    MOZ_ASSERT(IsUint32Array(), "Wrong type!");
    return mValue.mUint32Array.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUint32Array: {
        DestroyUint32Array();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyUint32Array()
  {
    MOZ_ASSERT(IsUint32Array(), "Wrong type!");
    mValue.mUint32Array.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningUint32ArrayOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUint32ArrayOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eUint32Array,
    eString
  };

  union Value
  {
    UnionMember<Uint32Array > mUint32Array;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

  OwningUint32ArrayOrString(const OwningUint32ArrayOrString&) = delete;
  OwningUint32ArrayOrString& operator=(const OwningUint32ArrayOrString&) = delete;
public:
  explicit inline OwningUint32ArrayOrString()
    : mType(eUninitialized)
  {
  }

  inline ~OwningUint32ArrayOrString()
  {
    Uninit();
  }

  Uint32Array&
  RawSetAsUint32Array();

  Uint32Array&
  SetAsUint32Array();

  bool
  TrySetToUint32Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUint32Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUint32Array() const
  {
    return mType == eUint32Array;
  }

  inline Uint32Array&
  GetAsUint32Array()
  {
    MOZ_ASSERT(IsUint32Array(), "Wrong type!");
    return mValue.mUint32Array.Value();
  }

  inline Uint32Array const &
  GetAsUint32Array() const
  {
    MOZ_ASSERT(IsUint32Array(), "Wrong type!");
    return mValue.mUint32Array.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

private:
  void
  DestroyUint32Array();

  void
  DestroyString();
};


struct GPUBindGroupLayoutDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUBindGroupLayoutEntry> mEntries;

  GPUBindGroupLayoutDescriptor();

  explicit inline GPUBindGroupLayoutDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUBindGroupLayoutDescriptor(const GPUBindGroupLayoutDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUBindGroupLayoutDescriptor&
  operator=(const GPUBindGroupLayoutDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupLayoutDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupLayoutDescriptor : public GPUBindGroupLayoutDescriptor
{
  inline FastGPUBindGroupLayoutDescriptor()
    : GPUBindGroupLayoutDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUColorStateDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUBlendDescriptor mAlphaBlend;
  MOZ_INIT_OUTSIDE_CTOR GPUBlendDescriptor mColorBlend;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWriteMask;

  GPUColorStateDescriptor();

  explicit inline GPUColorStateDescriptor(const FastDictionaryInitializer& )
    : mAlphaBlend(FastDictionaryInitializer()),
      mColorBlend(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUColorStateDescriptor(const GPUColorStateDescriptor& aOther)
    : mAlphaBlend(FastDictionaryInitializer()),
      mColorBlend(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUColorStateDescriptor&
  operator=(const GPUColorStateDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUColorStateDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUColorStateDescriptor : public GPUColorStateDescriptor
{
  inline FastGPUColorStateDescriptor()
    : GPUColorStateDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCommandBufferDescriptor : public GPUObjectDescriptorBase
{
  GPUCommandBufferDescriptor();

  explicit inline GPUCommandBufferDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUCommandBufferDescriptor(const GPUCommandBufferDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUCommandBufferDescriptor&
  operator=(const GPUCommandBufferDescriptor& aOther);

  bool
  operator==(const GPUCommandBufferDescriptor& aOther) const;
};

namespace binding_detail {
struct FastGPUCommandBufferDescriptor : public GPUCommandBufferDescriptor
{
  inline FastGPUCommandBufferDescriptor()
    : GPUCommandBufferDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUCommandEncoderDescriptor : public GPUObjectDescriptorBase
{
  GPUCommandEncoderDescriptor();

  explicit inline GPUCommandEncoderDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUCommandEncoderDescriptor(const GPUCommandEncoderDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUCommandEncoderDescriptor&
  operator=(const GPUCommandEncoderDescriptor& aOther);

  bool
  operator==(const GPUCommandEncoderDescriptor& aOther) const;
};

namespace binding_detail {
struct FastGPUCommandEncoderDescriptor : public GPUCommandEncoderDescriptor
{
  inline FastGPUCommandEncoderDescriptor()
    : GPUCommandEncoderDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUComputePassDescriptor : public GPUObjectDescriptorBase
{
  GPUComputePassDescriptor();

  explicit inline GPUComputePassDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUComputePassDescriptor(const GPUComputePassDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUComputePassDescriptor&
  operator=(const GPUComputePassDescriptor& aOther);

  bool
  operator==(const GPUComputePassDescriptor& aOther) const;
};

namespace binding_detail {
struct FastGPUComputePassDescriptor : public GPUComputePassDescriptor
{
  inline FastGPUComputePassDescriptor()
    : GPUComputePassDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUDepthStencilStateDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUCompareFunction mDepthCompare;
  MOZ_INIT_OUTSIDE_CTOR bool mDepthWriteEnabled;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilStateFaceDescriptor mStencilBack;
  MOZ_INIT_OUTSIDE_CTOR GPUStencilStateFaceDescriptor mStencilFront;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStencilReadMask;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mStencilWriteMask;

  GPUDepthStencilStateDescriptor();

  explicit inline GPUDepthStencilStateDescriptor(const FastDictionaryInitializer& )
    : mStencilBack(FastDictionaryInitializer()),
      mStencilFront(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUDepthStencilStateDescriptor(const GPUDepthStencilStateDescriptor& aOther)
    : mStencilBack(FastDictionaryInitializer()),
      mStencilFront(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUDepthStencilStateDescriptor&
  operator=(const GPUDepthStencilStateDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUDepthStencilStateDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUDepthStencilStateDescriptor : public GPUDepthStencilStateDescriptor
{
  inline FastGPUDepthStencilStateDescriptor()
    : GPUDepthStencilStateDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUDeviceDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUExtensions> mExtensions;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPULimits> mLimits;

  GPUDeviceDescriptor();

  explicit inline GPUDeviceDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUDeviceDescriptor(const GPUDeviceDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUDeviceDescriptor&
  operator=(const GPUDeviceDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUDeviceDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUDeviceDescriptor : public GPUDeviceDescriptor
{
  inline FastGPUDeviceDescriptor()
    : GPUDeviceDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUFenceDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mInitialValue;

  GPUFenceDescriptor();

  explicit inline GPUFenceDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUFenceDescriptor(const GPUFenceDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUFenceDescriptor&
  operator=(const GPUFenceDescriptor& aOther);

  bool
  operator==(const GPUFenceDescriptor& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, GPUFenceDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUFenceDescriptor : public GPUFenceDescriptor
{
  inline FastGPUFenceDescriptor()
    : GPUFenceDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class GPULoadOpOrDoubleSequenceOrGPUColorDict
{
  friend class GPULoadOpOrDoubleSequenceOrGPUColorDictArgument;
  enum Type
  {
    eUninitialized,
    eGPULoadOp,
    eDoubleSequence,
    eGPUColorDict
  };

  union Value
  {
    UnionMember<GPULoadOp > mGPULoadOp;
    UnionMember<binding_detail::AutoSequence<double> > mDoubleSequence;
    UnionMember<binding_detail::FastGPUColorDict > mGPUColorDict;

  };

  Type mType;
  Value mValue;

  GPULoadOpOrDoubleSequenceOrGPUColorDict(const GPULoadOpOrDoubleSequenceOrGPUColorDict&) = delete;
  GPULoadOpOrDoubleSequenceOrGPUColorDict& operator=(const GPULoadOpOrDoubleSequenceOrGPUColorDict&) = delete;
public:
  explicit inline GPULoadOpOrDoubleSequenceOrGPUColorDict()
    : mType(eUninitialized)
  {
  }

  inline ~GPULoadOpOrDoubleSequenceOrGPUColorDict()
  {
    Uninit();
  }

  inline GPULoadOp&
  RawSetAsGPULoadOp()
  {
    if (mType == eGPULoadOp) {
      return mValue.mGPULoadOp.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPULoadOp;
    return mValue.mGPULoadOp.SetValue();
  }

  inline GPULoadOp&
  SetAsGPULoadOp()
  {
    if (mType == eGPULoadOp) {
      return mValue.mGPULoadOp.Value();
    }
    Uninit();
    mType = eGPULoadOp;
    return mValue.mGPULoadOp.SetValue();
  }

  inline bool
  IsGPULoadOp() const
  {
    return mType == eGPULoadOp;
  }

  inline GPULoadOp&
  GetAsGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline GPULoadOp
  GetAsGPULoadOp() const
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline binding_detail::AutoSequence<double>&
  RawSetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  inline binding_detail::AutoSequence<double>&
  SetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    Uninit();
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline binding_detail::AutoSequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline const Sequence<double>&
  GetAsDoubleSequence() const
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline binding_detail::FastGPUColorDict&
  RawSetAsGPUColorDict()
  {
    if (mType == eGPUColorDict) {
      return mValue.mGPUColorDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUColorDict;
    return mValue.mGPUColorDict.SetValue();
  }

  inline binding_detail::FastGPUColorDict&
  SetAsGPUColorDict()
  {
    if (mType == eGPUColorDict) {
      return mValue.mGPUColorDict.Value();
    }
    Uninit();
    mType = eGPUColorDict;
    return mValue.mGPUColorDict.SetValue();
  }

  inline bool
  IsGPUColorDict() const
  {
    return mType == eGPUColorDict;
  }

  inline binding_detail::FastGPUColorDict&
  GetAsGPUColorDict()
  {
    MOZ_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  inline const GPUColorDict&
  GetAsGPUColorDict() const
  {
    MOZ_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPULoadOp: {
        DestroyGPULoadOp();
        break;
      }
      case eDoubleSequence: {
        DestroyDoubleSequence();
        break;
      }
      case eGPUColorDict: {
        DestroyGPUColorDict();
        break;
      }
    }
  }

private:
  inline void
  DestroyGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    mValue.mGPULoadOp.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyDoubleSequence()
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    mValue.mDoubleSequence.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyGPUColorDict()
  {
    MOZ_ASSERT(IsGPUColorDict(), "Wrong type!");
    mValue.mGPUColorDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPULoadOpOrDoubleSequenceOrGPUColorDict : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPULoadOpOrDoubleSequenceOrGPUColorDict& aUnion);
  enum Type
  {
    eUninitialized,
    eGPULoadOp,
    eDoubleSequence,
    eGPUColorDict
  };

  union Value
  {
    UnionMember<GPULoadOp > mGPULoadOp;
    UnionMember<Sequence<double> > mDoubleSequence;
    UnionMember<GPUColorDict > mGPUColorDict;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningGPULoadOpOrDoubleSequenceOrGPUColorDict()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningGPULoadOpOrDoubleSequenceOrGPUColorDict(const OwningGPULoadOpOrDoubleSequenceOrGPUColorDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPULoadOpOrDoubleSequenceOrGPUColorDict()
  {
    Uninit();
  }

  GPULoadOp&
  RawSetAsGPULoadOp();

  GPULoadOp&
  SetAsGPULoadOp();

  bool
  TrySetToGPULoadOp(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPULoadOp(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPULoadOp() const
  {
    return mType == eGPULoadOp;
  }

  inline GPULoadOp&
  GetAsGPULoadOp()
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  inline GPULoadOp const &
  GetAsGPULoadOp() const
  {
    MOZ_ASSERT(IsGPULoadOp(), "Wrong type!");
    return mValue.mGPULoadOp.Value();
  }

  Sequence<double>&
  RawSetAsDoubleSequence();

  Sequence<double>&
  SetAsDoubleSequence();

  bool
  TrySetToDoubleSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDoubleSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline Sequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline Sequence<double> const &
  GetAsDoubleSequence() const
  {
    MOZ_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  GPUColorDict&
  RawSetAsGPUColorDict();

  GPUColorDict&
  SetAsGPUColorDict();

  bool
  TrySetToGPUColorDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUColorDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPUColorDict() const
  {
    return mType == eGPUColorDict;
  }

  inline GPUColorDict&
  GetAsGPUColorDict()
  {
    MOZ_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  inline GPUColorDict const &
  GetAsGPUColorDict() const
  {
    MOZ_ASSERT(IsGPUColorDict(), "Wrong type!");
    return mValue.mGPUColorDict.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningGPULoadOpOrDoubleSequenceOrGPUColorDict&
  operator=(const OwningGPULoadOpOrDoubleSequenceOrGPUColorDict& aOther);

private:
  void
  DestroyGPULoadOp();

  void
  DestroyDoubleSequence();

  void
  DestroyGPUColorDict();
};


struct GPUPipelineDescriptorBase : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::PipelineLayout> mLayout;

  GPUPipelineDescriptorBase();

  explicit inline GPUPipelineDescriptorBase(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUPipelineDescriptorBase(const GPUPipelineDescriptorBase& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mLayout, "mLayout", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mLayout);
  }

  GPUPipelineDescriptorBase&
  operator=(const GPUPipelineDescriptorBase& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPipelineDescriptorBaseAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPipelineDescriptorBase : public GPUPipelineDescriptorBase
{
  inline FastGPUPipelineDescriptorBase()
    : GPUPipelineDescriptorBase(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUPipelineLayoutDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningNonNull<mozilla::webgpu::BindGroupLayout>> mBindGroupLayouts;

  GPUPipelineLayoutDescriptor();

  explicit inline GPUPipelineLayoutDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUPipelineLayoutDescriptor(const GPUPipelineLayoutDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBindGroupLayouts, "mBindGroupLayouts", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBindGroupLayouts);
  }

  GPUPipelineLayoutDescriptor&
  operator=(const GPUPipelineLayoutDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUPipelineLayoutDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUPipelineLayoutDescriptor : public GPUPipelineLayoutDescriptor
{
  inline FastGPUPipelineLayoutDescriptor()
    : GPUPipelineLayoutDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderBundleDescriptor : public GPUObjectDescriptorBase
{
  GPURenderBundleDescriptor();

  explicit inline GPURenderBundleDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPURenderBundleDescriptor(const GPURenderBundleDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURenderBundleDescriptor&
  operator=(const GPURenderBundleDescriptor& aOther);

  bool
  operator==(const GPURenderBundleDescriptor& aOther) const;
};

namespace binding_detail {
struct FastGPURenderBundleDescriptor : public GPURenderBundleDescriptor
{
  inline FastGPURenderBundleDescriptor()
    : GPURenderBundleDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderBundleEncoderDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUTextureFormat> mColorFormats;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureFormat> mDepthStencilFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleCount;

  GPURenderBundleEncoderDescriptor();

  explicit inline GPURenderBundleEncoderDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPURenderBundleEncoderDescriptor(const GPURenderBundleEncoderDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPURenderBundleEncoderDescriptor&
  operator=(const GPURenderBundleEncoderDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderBundleEncoderDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderBundleEncoderDescriptor : public GPURenderBundleEncoderDescriptor
{
  inline FastGPURenderBundleEncoderDescriptor()
    : GPURenderBundleEncoderDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassDepthStencilAttachmentDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::TextureView> mAttachment;
  MOZ_INIT_OUTSIDE_CTOR OwningGPULoadOpOrFloat mDepthLoadValue;
  MOZ_INIT_OUTSIDE_CTOR GPUStoreOp mDepthStoreOp;
  MOZ_INIT_OUTSIDE_CTOR OwningGPULoadOpOrUnsignedLong mStencilLoadValue;
  MOZ_INIT_OUTSIDE_CTOR GPUStoreOp mStencilStoreOp;

  GPURenderPassDepthStencilAttachmentDescriptor();

  explicit inline GPURenderPassDepthStencilAttachmentDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPURenderPassDepthStencilAttachmentDescriptor(const GPURenderPassDepthStencilAttachmentDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mAttachment, "mAttachment", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mAttachment);
  }

  GPURenderPassDepthStencilAttachmentDescriptor&
  operator=(const GPURenderPassDepthStencilAttachmentDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassDepthStencilAttachmentDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassDepthStencilAttachmentDescriptor : public GPURenderPassDepthStencilAttachmentDescriptor
{
  inline FastGPURenderPassDepthStencilAttachmentDescriptor()
    : GPURenderPassDepthStencilAttachmentDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUSamplerDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeU;
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeV;
  MOZ_INIT_OUTSIDE_CTOR GPUAddressMode mAddressModeW;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUCompareFunction> mCompare;
  MOZ_INIT_OUTSIDE_CTOR float mLodMaxClamp;
  MOZ_INIT_OUTSIDE_CTOR float mLodMinClamp;
  MOZ_INIT_OUTSIDE_CTOR GPUFilterMode mMagFilter;
  MOZ_INIT_OUTSIDE_CTOR GPUFilterMode mMinFilter;
  MOZ_INIT_OUTSIDE_CTOR GPUFilterMode mMipmapFilter;

  GPUSamplerDescriptor();

  explicit inline GPUSamplerDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUSamplerDescriptor(const GPUSamplerDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUSamplerDescriptor&
  operator=(const GPUSamplerDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUSamplerDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUSamplerDescriptor : public GPUSamplerDescriptor
{
  inline FastGPUSamplerDescriptor()
    : GPUSamplerDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class GPUSamplerOrGPUTextureViewOrGPUBufferBinding
{
  friend class GPUSamplerOrGPUTextureViewOrGPUBufferBindingArgument;
  enum Type
  {
    eUninitialized,
    eGPUSampler,
    eGPUTextureView,
    eGPUBufferBinding
  };

  union Value
  {
    UnionMember<NonNull<mozilla::webgpu::Sampler> > mGPUSampler;
    UnionMember<NonNull<mozilla::webgpu::TextureView> > mGPUTextureView;
    UnionMember<binding_detail::FastGPUBufferBinding > mGPUBufferBinding;

  };

  Type mType;
  Value mValue;

  GPUSamplerOrGPUTextureViewOrGPUBufferBinding(const GPUSamplerOrGPUTextureViewOrGPUBufferBinding&) = delete;
  GPUSamplerOrGPUTextureViewOrGPUBufferBinding& operator=(const GPUSamplerOrGPUTextureViewOrGPUBufferBinding&) = delete;
public:
  explicit inline GPUSamplerOrGPUTextureViewOrGPUBufferBinding()
    : mType(eUninitialized)
  {
  }

  inline ~GPUSamplerOrGPUTextureViewOrGPUBufferBinding()
  {
    Uninit();
  }

  inline NonNull<mozilla::webgpu::Sampler>&
  RawSetAsGPUSampler()
  {
    if (mType == eGPUSampler) {
      return mValue.mGPUSampler.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUSampler;
    return mValue.mGPUSampler.SetValue();
  }

  inline NonNull<mozilla::webgpu::Sampler>&
  SetAsGPUSampler()
  {
    if (mType == eGPUSampler) {
      return mValue.mGPUSampler.Value();
    }
    Uninit();
    mType = eGPUSampler;
    return mValue.mGPUSampler.SetValue();
  }

  inline bool
  IsGPUSampler() const
  {
    return mType == eGPUSampler;
  }

  inline NonNull<mozilla::webgpu::Sampler>&
  GetAsGPUSampler()
  {
    MOZ_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  inline mozilla::webgpu::Sampler&
  GetAsGPUSampler() const
  {
    MOZ_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  inline NonNull<mozilla::webgpu::TextureView>&
  RawSetAsGPUTextureView()
  {
    if (mType == eGPUTextureView) {
      return mValue.mGPUTextureView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUTextureView;
    return mValue.mGPUTextureView.SetValue();
  }

  inline NonNull<mozilla::webgpu::TextureView>&
  SetAsGPUTextureView()
  {
    if (mType == eGPUTextureView) {
      return mValue.mGPUTextureView.Value();
    }
    Uninit();
    mType = eGPUTextureView;
    return mValue.mGPUTextureView.SetValue();
  }

  inline bool
  IsGPUTextureView() const
  {
    return mType == eGPUTextureView;
  }

  inline NonNull<mozilla::webgpu::TextureView>&
  GetAsGPUTextureView()
  {
    MOZ_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  inline mozilla::webgpu::TextureView&
  GetAsGPUTextureView() const
  {
    MOZ_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  inline binding_detail::FastGPUBufferBinding&
  RawSetAsGPUBufferBinding()
  {
    if (mType == eGPUBufferBinding) {
      return mValue.mGPUBufferBinding.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUBufferBinding;
    return mValue.mGPUBufferBinding.SetValue();
  }

  inline binding_detail::FastGPUBufferBinding&
  SetAsGPUBufferBinding()
  {
    if (mType == eGPUBufferBinding) {
      return mValue.mGPUBufferBinding.Value();
    }
    Uninit();
    mType = eGPUBufferBinding;
    return mValue.mGPUBufferBinding.SetValue();
  }

  inline bool
  IsGPUBufferBinding() const
  {
    return mType == eGPUBufferBinding;
  }

  inline binding_detail::FastGPUBufferBinding&
  GetAsGPUBufferBinding()
  {
    MOZ_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  inline const GPUBufferBinding&
  GetAsGPUBufferBinding() const
  {
    MOZ_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eGPUSampler: {
        DestroyGPUSampler();
        break;
      }
      case eGPUTextureView: {
        DestroyGPUTextureView();
        break;
      }
      case eGPUBufferBinding: {
        DestroyGPUBufferBinding();
        break;
      }
    }
  }

private:
  inline void
  DestroyGPUSampler()
  {
    MOZ_ASSERT(IsGPUSampler(), "Wrong type!");
    mValue.mGPUSampler.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyGPUTextureView()
  {
    MOZ_ASSERT(IsGPUTextureView(), "Wrong type!");
    mValue.mGPUTextureView.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyGPUBufferBinding()
  {
    MOZ_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    mValue.mGPUBufferBinding.Destroy();
    mType = eUninitialized;
  }
};


class OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aUnion);
  enum Type
  {
    eUninitialized,
    eGPUSampler,
    eGPUTextureView,
    eGPUBufferBinding
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::webgpu::Sampler> > mGPUSampler;
    UnionMember<OwningNonNull<mozilla::webgpu::TextureView> > mGPUTextureView;
    UnionMember<GPUBufferBinding > mGPUBufferBinding;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding(const OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding()
  {
    Uninit();
  }

  OwningNonNull<mozilla::webgpu::Sampler>&
  RawSetAsGPUSampler();

  OwningNonNull<mozilla::webgpu::Sampler>&
  SetAsGPUSampler();

  bool
  TrySetToGPUSampler(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUSampler(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPUSampler() const
  {
    return mType == eGPUSampler;
  }

  inline OwningNonNull<mozilla::webgpu::Sampler>&
  GetAsGPUSampler()
  {
    MOZ_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  inline OwningNonNull<mozilla::webgpu::Sampler> const &
  GetAsGPUSampler() const
  {
    MOZ_ASSERT(IsGPUSampler(), "Wrong type!");
    return mValue.mGPUSampler.Value();
  }

  OwningNonNull<mozilla::webgpu::TextureView>&
  RawSetAsGPUTextureView();

  OwningNonNull<mozilla::webgpu::TextureView>&
  SetAsGPUTextureView();

  bool
  TrySetToGPUTextureView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUTextureView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPUTextureView() const
  {
    return mType == eGPUTextureView;
  }

  inline OwningNonNull<mozilla::webgpu::TextureView>&
  GetAsGPUTextureView()
  {
    MOZ_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  inline OwningNonNull<mozilla::webgpu::TextureView> const &
  GetAsGPUTextureView() const
  {
    MOZ_ASSERT(IsGPUTextureView(), "Wrong type!");
    return mValue.mGPUTextureView.Value();
  }

  GPUBufferBinding&
  RawSetAsGPUBufferBinding();

  GPUBufferBinding&
  SetAsGPUBufferBinding();

  bool
  TrySetToGPUBufferBinding(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUBufferBinding(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPUBufferBinding() const
  {
    return mType == eGPUBufferBinding;
  }

  inline GPUBufferBinding&
  GetAsGPUBufferBinding()
  {
    MOZ_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  inline GPUBufferBinding const &
  GetAsGPUBufferBinding() const
  {
    MOZ_ASSERT(IsGPUBufferBinding(), "Wrong type!");
    return mValue.mGPUBufferBinding.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding&
  operator=(const OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding& aOther);

private:
  void
  DestroyGPUSampler();

  void
  DestroyGPUTextureView();

  void
  DestroyGPUBufferBinding();
};


struct GPUShaderModuleDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningUint32ArrayOrString mCode;

  GPUShaderModuleDescriptor();

  explicit inline GPUShaderModuleDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  GPUShaderModuleDescriptor(const GPUShaderModuleDescriptor&) = delete;
  GPUShaderModuleDescriptor& operator=(const GPUShaderModuleDescriptor&) = delete;

  static bool
  InitIds(JSContext* cx, GPUShaderModuleDescriptorAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastGPUShaderModuleDescriptor : public GPUShaderModuleDescriptor
{
  inline FastGPUShaderModuleDescriptor()
    : GPUShaderModuleDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUSwapChainDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Device> mDevice;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;

  GPUSwapChainDescriptor();

  explicit inline GPUSwapChainDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUSwapChainDescriptor(const GPUSwapChainDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mDevice, "mDevice", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mDevice);
  }

  GPUSwapChainDescriptor&
  operator=(const GPUSwapChainDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUSwapChainDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUSwapChainDescriptor : public GPUSwapChainDescriptor
{
  inline FastGPUSwapChainDescriptor()
    : GPUSwapChainDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureViewDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mArrayLayerCount;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureAspect mAspect;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBaseArrayLayer;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBaseMipLevel;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureViewDimension> mDimension;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUTextureFormat> mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMipLevelCount;

  GPUTextureViewDescriptor();

  explicit inline GPUTextureViewDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUTextureViewDescriptor(const GPUTextureViewDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTextureViewDescriptor&
  operator=(const GPUTextureViewDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureViewDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureViewDescriptor : public GPUTextureViewDescriptor
{
  inline FastGPUTextureViewDescriptor()
    : GPUTextureViewDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexBufferLayoutDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mArrayStride;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUVertexAttributeDescriptor> mAttributes;
  MOZ_INIT_OUTSIDE_CTOR GPUInputStepMode mStepMode;

  GPUVertexBufferLayoutDescriptor();

  explicit inline GPUVertexBufferLayoutDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUVertexBufferLayoutDescriptor(const GPUVertexBufferLayoutDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUVertexBufferLayoutDescriptor&
  operator=(const GPUVertexBufferLayoutDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUVertexBufferLayoutDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUVertexBufferLayoutDescriptor : public GPUVertexBufferLayoutDescriptor
{
  inline FastGPUVertexBufferLayoutDescriptor()
    : GPUVertexBufferLayoutDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UnsignedLongSequenceOrGPUExtent3DDict
{
  friend class UnsignedLongSequenceOrGPUExtent3DDictArgument;
  enum Type
  {
    eUninitialized,
    eUnsignedLongSequence,
    eGPUExtent3DDict
  };

  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUExtent3DDict > mGPUExtent3DDict;

  };

  Type mType;
  Value mValue;

  UnsignedLongSequenceOrGPUExtent3DDict(const UnsignedLongSequenceOrGPUExtent3DDict&) = delete;
  UnsignedLongSequenceOrGPUExtent3DDict& operator=(const UnsignedLongSequenceOrGPUExtent3DDict&) = delete;
public:
  explicit inline UnsignedLongSequenceOrGPUExtent3DDict()
    : mType(eUninitialized)
  {
  }

  inline ~UnsignedLongSequenceOrGPUExtent3DDict()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsUnsignedLongSequence()
  {
    if (mType == eUnsignedLongSequence) {
      return mValue.mUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnsignedLongSequence;
    return mValue.mUnsignedLongSequence.SetValue();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  SetAsUnsignedLongSequence()
  {
    if (mType == eUnsignedLongSequence) {
      return mValue.mUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eUnsignedLongSequence;
    return mValue.mUnsignedLongSequence.SetValue();
  }

  inline bool
  IsUnsignedLongSequence() const
  {
    return mType == eUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsUnsignedLongSequence() const
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline binding_detail::FastGPUExtent3DDict&
  RawSetAsGPUExtent3DDict()
  {
    if (mType == eGPUExtent3DDict) {
      return mValue.mGPUExtent3DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUExtent3DDict;
    return mValue.mGPUExtent3DDict.SetValue();
  }

  inline binding_detail::FastGPUExtent3DDict&
  SetAsGPUExtent3DDict()
  {
    if (mType == eGPUExtent3DDict) {
      return mValue.mGPUExtent3DDict.Value();
    }
    Uninit();
    mType = eGPUExtent3DDict;
    return mValue.mGPUExtent3DDict.SetValue();
  }

  inline bool
  IsGPUExtent3DDict() const
  {
    return mType == eGPUExtent3DDict;
  }

  inline binding_detail::FastGPUExtent3DDict&
  GetAsGPUExtent3DDict()
  {
    MOZ_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  inline const GPUExtent3DDict&
  GetAsGPUExtent3DDict() const
  {
    MOZ_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnsignedLongSequence: {
        DestroyUnsignedLongSequence();
        break;
      }
      case eGPUExtent3DDict: {
        DestroyGPUExtent3DDict();
        break;
      }
    }
  }

private:
  inline void
  DestroyUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    mValue.mUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyGPUExtent3DDict()
  {
    MOZ_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    mValue.mGPUExtent3DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnsignedLongSequenceOrGPUExtent3DDict : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUnsignedLongSequenceOrGPUExtent3DDict& aUnion);
  enum Type
  {
    eUninitialized,
    eUnsignedLongSequence,
    eGPUExtent3DDict
  };

  union Value
  {
    UnionMember<Sequence<uint32_t> > mUnsignedLongSequence;
    UnionMember<GPUExtent3DDict > mGPUExtent3DDict;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningUnsignedLongSequenceOrGPUExtent3DDict()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningUnsignedLongSequenceOrGPUExtent3DDict(const OwningUnsignedLongSequenceOrGPUExtent3DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnsignedLongSequenceOrGPUExtent3DDict()
  {
    Uninit();
  }

  Sequence<uint32_t>&
  RawSetAsUnsignedLongSequence();

  Sequence<uint32_t>&
  SetAsUnsignedLongSequence();

  bool
  TrySetToUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUnsignedLongSequence() const
  {
    return mType == eUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsUnsignedLongSequence() const
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  GPUExtent3DDict&
  RawSetAsGPUExtent3DDict();

  GPUExtent3DDict&
  SetAsGPUExtent3DDict();

  bool
  TrySetToGPUExtent3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUExtent3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPUExtent3DDict() const
  {
    return mType == eGPUExtent3DDict;
  }

  inline GPUExtent3DDict&
  GetAsGPUExtent3DDict()
  {
    MOZ_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  inline GPUExtent3DDict const &
  GetAsGPUExtent3DDict() const
  {
    MOZ_ASSERT(IsGPUExtent3DDict(), "Wrong type!");
    return mValue.mGPUExtent3DDict.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningUnsignedLongSequenceOrGPUExtent3DDict&
  operator=(const OwningUnsignedLongSequenceOrGPUExtent3DDict& aOther);

private:
  void
  DestroyUnsignedLongSequence();

  void
  DestroyGPUExtent3DDict();
};


class UnsignedLongSequenceOrGPUOrigin2DDict
{
  friend class UnsignedLongSequenceOrGPUOrigin2DDictArgument;
  enum Type
  {
    eUninitialized,
    eUnsignedLongSequence,
    eGPUOrigin2DDict
  };

  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUOrigin2DDict > mGPUOrigin2DDict;

  };

  Type mType;
  Value mValue;

  UnsignedLongSequenceOrGPUOrigin2DDict(const UnsignedLongSequenceOrGPUOrigin2DDict&) = delete;
  UnsignedLongSequenceOrGPUOrigin2DDict& operator=(const UnsignedLongSequenceOrGPUOrigin2DDict&) = delete;
public:
  explicit inline UnsignedLongSequenceOrGPUOrigin2DDict()
    : mType(eUninitialized)
  {
  }

  inline ~UnsignedLongSequenceOrGPUOrigin2DDict()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsUnsignedLongSequence()
  {
    if (mType == eUnsignedLongSequence) {
      return mValue.mUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnsignedLongSequence;
    return mValue.mUnsignedLongSequence.SetValue();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  SetAsUnsignedLongSequence()
  {
    if (mType == eUnsignedLongSequence) {
      return mValue.mUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eUnsignedLongSequence;
    return mValue.mUnsignedLongSequence.SetValue();
  }

  inline bool
  IsUnsignedLongSequence() const
  {
    return mType == eUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsUnsignedLongSequence() const
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline binding_detail::FastGPUOrigin2DDict&
  RawSetAsGPUOrigin2DDict()
  {
    if (mType == eGPUOrigin2DDict) {
      return mValue.mGPUOrigin2DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUOrigin2DDict;
    return mValue.mGPUOrigin2DDict.SetValue();
  }

  inline binding_detail::FastGPUOrigin2DDict&
  SetAsGPUOrigin2DDict()
  {
    if (mType == eGPUOrigin2DDict) {
      return mValue.mGPUOrigin2DDict.Value();
    }
    Uninit();
    mType = eGPUOrigin2DDict;
    return mValue.mGPUOrigin2DDict.SetValue();
  }

  inline bool
  IsGPUOrigin2DDict() const
  {
    return mType == eGPUOrigin2DDict;
  }

  inline binding_detail::FastGPUOrigin2DDict&
  GetAsGPUOrigin2DDict()
  {
    MOZ_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  inline const GPUOrigin2DDict&
  GetAsGPUOrigin2DDict() const
  {
    MOZ_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnsignedLongSequence: {
        DestroyUnsignedLongSequence();
        break;
      }
      case eGPUOrigin2DDict: {
        DestroyGPUOrigin2DDict();
        break;
      }
    }
  }

private:
  inline void
  DestroyUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    mValue.mUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyGPUOrigin2DDict()
  {
    MOZ_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    mValue.mGPUOrigin2DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnsignedLongSequenceOrGPUOrigin2DDict : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUnsignedLongSequenceOrGPUOrigin2DDict& aUnion);
  enum Type
  {
    eUninitialized,
    eUnsignedLongSequence,
    eGPUOrigin2DDict
  };

  union Value
  {
    UnionMember<Sequence<uint32_t> > mUnsignedLongSequence;
    UnionMember<GPUOrigin2DDict > mGPUOrigin2DDict;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningUnsignedLongSequenceOrGPUOrigin2DDict()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningUnsignedLongSequenceOrGPUOrigin2DDict(const OwningUnsignedLongSequenceOrGPUOrigin2DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnsignedLongSequenceOrGPUOrigin2DDict()
  {
    Uninit();
  }

  Sequence<uint32_t>&
  RawSetAsUnsignedLongSequence();

  Sequence<uint32_t>&
  SetAsUnsignedLongSequence();

  bool
  TrySetToUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUnsignedLongSequence() const
  {
    return mType == eUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsUnsignedLongSequence() const
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  GPUOrigin2DDict&
  RawSetAsGPUOrigin2DDict();

  GPUOrigin2DDict&
  SetAsGPUOrigin2DDict();

  inline bool
  IsGPUOrigin2DDict() const
  {
    return mType == eGPUOrigin2DDict;
  }

  inline GPUOrigin2DDict&
  GetAsGPUOrigin2DDict()
  {
    MOZ_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  inline GPUOrigin2DDict const &
  GetAsGPUOrigin2DDict() const
  {
    MOZ_ASSERT(IsGPUOrigin2DDict(), "Wrong type!");
    return mValue.mGPUOrigin2DDict.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningUnsignedLongSequenceOrGPUOrigin2DDict&
  operator=(const OwningUnsignedLongSequenceOrGPUOrigin2DDict& aOther);

private:
  void
  DestroyUnsignedLongSequence();

  void
  DestroyGPUOrigin2DDict();
};


class UnsignedLongSequenceOrGPUOrigin3DDict
{
  friend class UnsignedLongSequenceOrGPUOrigin3DDictArgument;
  enum Type
  {
    eUninitialized,
    eUnsignedLongSequence,
    eGPUOrigin3DDict
  };

  union Value
  {
    UnionMember<binding_detail::AutoSequence<uint32_t> > mUnsignedLongSequence;
    UnionMember<binding_detail::FastGPUOrigin3DDict > mGPUOrigin3DDict;

  };

  Type mType;
  Value mValue;

  UnsignedLongSequenceOrGPUOrigin3DDict(const UnsignedLongSequenceOrGPUOrigin3DDict&) = delete;
  UnsignedLongSequenceOrGPUOrigin3DDict& operator=(const UnsignedLongSequenceOrGPUOrigin3DDict&) = delete;
public:
  explicit inline UnsignedLongSequenceOrGPUOrigin3DDict()
    : mType(eUninitialized)
  {
  }

  inline ~UnsignedLongSequenceOrGPUOrigin3DDict()
  {
    Uninit();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  RawSetAsUnsignedLongSequence()
  {
    if (mType == eUnsignedLongSequence) {
      return mValue.mUnsignedLongSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnsignedLongSequence;
    return mValue.mUnsignedLongSequence.SetValue();
  }

  inline binding_detail::AutoSequence<uint32_t>&
  SetAsUnsignedLongSequence()
  {
    if (mType == eUnsignedLongSequence) {
      return mValue.mUnsignedLongSequence.Value();
    }
    Uninit();
    mType = eUnsignedLongSequence;
    return mValue.mUnsignedLongSequence.SetValue();
  }

  inline bool
  IsUnsignedLongSequence() const
  {
    return mType == eUnsignedLongSequence;
  }

  inline binding_detail::AutoSequence<uint32_t>&
  GetAsUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline const Sequence<uint32_t>&
  GetAsUnsignedLongSequence() const
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline binding_detail::FastGPUOrigin3DDict&
  RawSetAsGPUOrigin3DDict()
  {
    if (mType == eGPUOrigin3DDict) {
      return mValue.mGPUOrigin3DDict.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eGPUOrigin3DDict;
    return mValue.mGPUOrigin3DDict.SetValue();
  }

  inline binding_detail::FastGPUOrigin3DDict&
  SetAsGPUOrigin3DDict()
  {
    if (mType == eGPUOrigin3DDict) {
      return mValue.mGPUOrigin3DDict.Value();
    }
    Uninit();
    mType = eGPUOrigin3DDict;
    return mValue.mGPUOrigin3DDict.SetValue();
  }

  inline bool
  IsGPUOrigin3DDict() const
  {
    return mType == eGPUOrigin3DDict;
  }

  inline binding_detail::FastGPUOrigin3DDict&
  GetAsGPUOrigin3DDict()
  {
    MOZ_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  inline const GPUOrigin3DDict&
  GetAsGPUOrigin3DDict() const
  {
    MOZ_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnsignedLongSequence: {
        DestroyUnsignedLongSequence();
        break;
      }
      case eGPUOrigin3DDict: {
        DestroyGPUOrigin3DDict();
        break;
      }
    }
  }

private:
  inline void
  DestroyUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    mValue.mUnsignedLongSequence.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyGPUOrigin3DDict()
  {
    MOZ_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    mValue.mGPUOrigin3DDict.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnsignedLongSequenceOrGPUOrigin3DDict : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUnsignedLongSequenceOrGPUOrigin3DDict& aUnion);
  enum Type
  {
    eUninitialized,
    eUnsignedLongSequence,
    eGPUOrigin3DDict
  };

  union Value
  {
    UnionMember<Sequence<uint32_t> > mUnsignedLongSequence;
    UnionMember<GPUOrigin3DDict > mGPUOrigin3DDict;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningUnsignedLongSequenceOrGPUOrigin3DDict()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningUnsignedLongSequenceOrGPUOrigin3DDict(const OwningUnsignedLongSequenceOrGPUOrigin3DDict& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnsignedLongSequenceOrGPUOrigin3DDict()
  {
    Uninit();
  }

  Sequence<uint32_t>&
  RawSetAsUnsignedLongSequence();

  Sequence<uint32_t>&
  SetAsUnsignedLongSequence();

  bool
  TrySetToUnsignedLongSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUnsignedLongSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUnsignedLongSequence() const
  {
    return mType == eUnsignedLongSequence;
  }

  inline Sequence<uint32_t>&
  GetAsUnsignedLongSequence()
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  inline Sequence<uint32_t> const &
  GetAsUnsignedLongSequence() const
  {
    MOZ_ASSERT(IsUnsignedLongSequence(), "Wrong type!");
    return mValue.mUnsignedLongSequence.Value();
  }

  GPUOrigin3DDict&
  RawSetAsGPUOrigin3DDict();

  GPUOrigin3DDict&
  SetAsGPUOrigin3DDict();

  bool
  TrySetToGPUOrigin3DDict(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToGPUOrigin3DDict(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsGPUOrigin3DDict() const
  {
    return mType == eGPUOrigin3DDict;
  }

  inline GPUOrigin3DDict&
  GetAsGPUOrigin3DDict()
  {
    MOZ_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  inline GPUOrigin3DDict const &
  GetAsGPUOrigin3DDict() const
  {
    MOZ_ASSERT(IsGPUOrigin3DDict(), "Wrong type!");
    return mValue.mGPUOrigin3DDict.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningUnsignedLongSequenceOrGPUOrigin3DDict&
  operator=(const OwningUnsignedLongSequenceOrGPUOrigin3DDict& aOther);

private:
  void
  DestroyUnsignedLongSequence();

  void
  DestroyGPUOrigin3DDict();
};


struct GPUBindGroupEntry : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mBinding;
  MOZ_INIT_OUTSIDE_CTOR OwningGPUSamplerOrGPUTextureViewOrGPUBufferBinding mResource;

  GPUBindGroupEntry();

  explicit inline GPUBindGroupEntry(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUBindGroupEntry(const GPUBindGroupEntry& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mResource, "mResource", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mResource);
  }

  GPUBindGroupEntry&
  operator=(const GPUBindGroupEntry& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupEntryAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupEntry : public GPUBindGroupEntry
{
  inline FastGPUBindGroupEntry()
    : GPUBindGroupEntry(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUComputePipelineDescriptor : public GPUPipelineDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUProgrammableStageDescriptor mComputeStage;

  GPUComputePipelineDescriptor();

  explicit inline GPUComputePipelineDescriptor(const FastDictionaryInitializer& )
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mComputeStage(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUComputePipelineDescriptor(const GPUComputePipelineDescriptor& aOther)
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mComputeStage(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUPipelineDescriptorBase::TraverseForCC(aCallback, aFlags);
    ImplCycleCollectionTraverse(aCallback, mComputeStage, "mComputeStage", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUPipelineDescriptorBase::UnlinkForCC();
    ImplCycleCollectionUnlink(mComputeStage);
  }

  GPUComputePipelineDescriptor&
  operator=(const GPUComputePipelineDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUComputePipelineDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUComputePipelineDescriptor : public GPUComputePipelineDescriptor
{
  inline FastGPUComputePipelineDescriptor()
    : GPUComputePipelineDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUImageBitmapCopyView : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningUnsignedLongSequenceOrGPUOrigin2DDict> mOrigin;

  GPUImageBitmapCopyView();

  explicit inline GPUImageBitmapCopyView(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUImageBitmapCopyView(const GPUImageBitmapCopyView& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUImageBitmapCopyView&
  operator=(const GPUImageBitmapCopyView& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUImageBitmapCopyViewAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUImageBitmapCopyView : public GPUImageBitmapCopyView
{
  inline FastGPUImageBitmapCopyView()
    : GPUImageBitmapCopyView(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassColorAttachmentDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::TextureView> mAttachment;
  MOZ_INIT_OUTSIDE_CTOR OwningGPULoadOpOrDoubleSequenceOrGPUColorDict mLoadValue;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<mozilla::webgpu::TextureView>> mResolveTarget;
  MOZ_INIT_OUTSIDE_CTOR GPUStoreOp mStoreOp;

  GPURenderPassColorAttachmentDescriptor();

  explicit inline GPURenderPassColorAttachmentDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPURenderPassColorAttachmentDescriptor(const GPURenderPassColorAttachmentDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mAttachment, "mAttachment", aFlags);
    ImplCycleCollectionTraverse(aCallback, mResolveTarget, "mResolveTarget", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mAttachment);
    ImplCycleCollectionUnlink(mResolveTarget);
  }

  GPURenderPassColorAttachmentDescriptor&
  operator=(const GPURenderPassColorAttachmentDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassColorAttachmentDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassColorAttachmentDescriptor : public GPURenderPassColorAttachmentDescriptor
{
  inline FastGPURenderPassColorAttachmentDescriptor()
    : GPURenderPassColorAttachmentDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureCopyView : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mArrayLayer;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMipLevel;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningUnsignedLongSequenceOrGPUOrigin3DDict> mOrigin;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::Texture> mTexture;

  GPUTextureCopyView();

  explicit inline GPUTextureCopyView(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUTextureCopyView(const GPUTextureCopyView& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mTexture, "mTexture", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mTexture);
  }

  GPUTextureCopyView&
  operator=(const GPUTextureCopyView& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureCopyViewAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureCopyView : public GPUTextureCopyView
{
  inline FastGPUTextureCopyView()
    : GPUTextureCopyView(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUTextureDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUTextureDimension mDimension;
  MOZ_INIT_OUTSIDE_CTOR GPUTextureFormat mFormat;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mMipLevelCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleCount;
  MOZ_INIT_OUTSIDE_CTOR OwningUnsignedLongSequenceOrGPUExtent3DDict mSize;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mUsage;

  GPUTextureDescriptor();

  explicit inline GPUTextureDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUTextureDescriptor(const GPUTextureDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUTextureDescriptor&
  operator=(const GPUTextureDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUTextureDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUTextureDescriptor : public GPUTextureDescriptor
{
  inline FastGPUTextureDescriptor()
    : GPUTextureDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUVertexStateDescriptor : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR GPUIndexFormat mIndexFormat;
  MOZ_INIT_OUTSIDE_CTOR Sequence<Nullable<GPUVertexBufferLayoutDescriptor>> mVertexBuffers;

  GPUVertexStateDescriptor();

  explicit inline GPUVertexStateDescriptor(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUVertexStateDescriptor(const GPUVertexStateDescriptor& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GPUVertexStateDescriptor&
  operator=(const GPUVertexStateDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUVertexStateDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUVertexStateDescriptor : public GPUVertexStateDescriptor
{
  inline FastGPUVertexStateDescriptor()
    : GPUVertexStateDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPUBindGroupDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUBindGroupEntry> mEntries;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::webgpu::BindGroupLayout> mLayout;

  GPUBindGroupDescriptor();

  explicit inline GPUBindGroupDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPUBindGroupDescriptor(const GPUBindGroupDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mEntries, "mEntries", aFlags);
    ImplCycleCollectionTraverse(aCallback, mLayout, "mLayout", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mEntries);
    ImplCycleCollectionUnlink(mLayout);
  }

  GPUBindGroupDescriptor&
  operator=(const GPUBindGroupDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPUBindGroupDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPUBindGroupDescriptor : public GPUBindGroupDescriptor
{
  inline FastGPUBindGroupDescriptor()
    : GPUBindGroupDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPassDescriptor : public GPUObjectDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPURenderPassColorAttachmentDescriptor> mColorAttachments;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPURenderPassDepthStencilAttachmentDescriptor> mDepthStencilAttachment;

  GPURenderPassDescriptor();

  explicit inline GPURenderPassDescriptor(const FastDictionaryInitializer& )
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPURenderPassDescriptor(const GPURenderPassDescriptor& aOther)
    : GPUObjectDescriptorBase(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mColorAttachments, "mColorAttachments", aFlags);
    ImplCycleCollectionTraverse(aCallback, mDepthStencilAttachment, "mDepthStencilAttachment", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mColorAttachments);
    ImplCycleCollectionUnlink(mDepthStencilAttachment);
  }

  GPURenderPassDescriptor&
  operator=(const GPURenderPassDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPassDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPassDescriptor : public GPURenderPassDescriptor
{
  inline FastGPURenderPassDescriptor()
    : GPURenderPassDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GPURenderPipelineDescriptor : public GPUPipelineDescriptorBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mAlphaToCoverageEnabled;
  MOZ_INIT_OUTSIDE_CTOR Sequence<GPUColorStateDescriptor> mColorStates;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUDepthStencilStateDescriptor> mDepthStencilState;
  MOZ_INIT_OUTSIDE_CTOR Optional<GPUProgrammableStageDescriptor> mFragmentStage;
  MOZ_INIT_OUTSIDE_CTOR GPUPrimitiveTopology mPrimitiveTopology;
  MOZ_INIT_OUTSIDE_CTOR GPURasterizationStateDescriptor mRasterizationState;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleCount;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSampleMask;
  MOZ_INIT_OUTSIDE_CTOR GPUProgrammableStageDescriptor mVertexStage;
  MOZ_INIT_OUTSIDE_CTOR GPUVertexStateDescriptor mVertexState;

  GPURenderPipelineDescriptor();

  explicit inline GPURenderPipelineDescriptor(const FastDictionaryInitializer& )
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mRasterizationState(FastDictionaryInitializer()),
      mVertexStage(FastDictionaryInitializer()),
      mVertexState(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline GPURenderPipelineDescriptor(const GPURenderPipelineDescriptor& aOther)
    : GPUPipelineDescriptorBase(FastDictionaryInitializer()),
      mRasterizationState(FastDictionaryInitializer()),
      mVertexStage(FastDictionaryInitializer()),
      mVertexState(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    GPUPipelineDescriptorBase::TraverseForCC(aCallback, aFlags);
    ImplCycleCollectionTraverse(aCallback, mFragmentStage, "mFragmentStage", aFlags);
    ImplCycleCollectionTraverse(aCallback, mVertexStage, "mVertexStage", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    GPUPipelineDescriptorBase::UnlinkForCC();
    ImplCycleCollectionUnlink(mFragmentStage);
    ImplCycleCollectionUnlink(mVertexStage);
  }

  GPURenderPipelineDescriptor&
  operator=(const GPURenderPipelineDescriptor& aOther);

private:
  static bool
  InitIds(JSContext* cx, GPURenderPipelineDescriptorAtoms* atomsCache);
};

namespace binding_detail {
struct FastGPURenderPipelineDescriptor : public GPURenderPipelineDescriptor
{
  inline FastGPURenderPipelineDescriptor()
    : GPURenderPipelineDescriptor(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace GPU_Binding {

  typedef mozilla::webgpu::Instance NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Instance* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPU,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPU,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPU_Binding



namespace GPUAdapter_Binding {

  typedef mozilla::webgpu::Adapter NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Adapter* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUAdapter,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUAdapter,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUAdapter_Binding



namespace GPUBindGroup_Binding {

  typedef mozilla::webgpu::BindGroup NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::BindGroup* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUBindGroup,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBindGroup,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUBindGroup_Binding



namespace GPUBindGroupLayout_Binding {

  typedef mozilla::webgpu::BindGroupLayout NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::BindGroupLayout* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUBindGroupLayout,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBindGroupLayout,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUBindGroupLayout_Binding



namespace GPUBuffer_Binding {

  typedef mozilla::webgpu::Buffer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Buffer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUBuffer,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBuffer,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUBuffer_Binding



namespace GPUBufferUsage_Binding {

  typedef mozilla::dom::GPUBufferUsage NativeType;

  static const uint32_t NONE = 0;
  static const uint32_t MAP_READ = 1;
  static const uint32_t MAP_WRITE = 2;
  static const uint32_t COPY_SRC = 4;
  static const uint32_t COPY_DST = 8;
  static const uint32_t INDEX = 16;
  static const uint32_t VERTEX = 32;
  static const uint32_t UNIFORM = 64;
  static const uint32_t STORAGE = 128;
  static const uint32_t INDIRECT = 256;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUBufferUsage,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUBufferUsage_Binding



namespace GPUCanvasContext_Binding {

  typedef mozilla::webgpu::CanvasContext NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CanvasContext* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUCanvasContext,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCanvasContext,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUCanvasContext_Binding



namespace GPUColorWrite_Binding {

  typedef mozilla::dom::GPUColorWrite NativeType;

  static const uint32_t NONE = 0;
  static const uint32_t RED = 1;
  static const uint32_t GREEN = 2;
  static const uint32_t BLUE = 4;
  static const uint32_t ALPHA = 8;
  static const uint32_t ALL = 15;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUColorWrite,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUColorWrite_Binding



namespace GPUCommandBuffer_Binding {

  typedef mozilla::webgpu::CommandBuffer NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CommandBuffer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUCommandBuffer,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCommandBuffer,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUCommandBuffer_Binding



namespace GPUCommandEncoder_Binding {

  typedef mozilla::webgpu::CommandEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::CommandEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUCommandEncoder,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUCommandEncoder,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUCommandEncoder_Binding



namespace GPUComputePassEncoder_Binding {

  typedef mozilla::webgpu::ComputePassEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ComputePassEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUComputePassEncoder,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUComputePassEncoder,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUComputePassEncoder_Binding



namespace GPUComputePipeline_Binding {

  typedef mozilla::webgpu::ComputePipeline NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ComputePipeline* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUComputePipeline,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUComputePipeline,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUComputePipeline_Binding



namespace GPUDevice_Binding {

  typedef mozilla::webgpu::Device NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Device* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUDevice,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUDevice,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUDevice_Binding



namespace GPUDeviceLostInfo_Binding {

  typedef mozilla::webgpu::DeviceLostInfo NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::DeviceLostInfo* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUDeviceLostInfo,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUDeviceLostInfo,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUDeviceLostInfo_Binding



namespace GPUFence_Binding {

  typedef mozilla::webgpu::Fence NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Fence* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUFence,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUFence,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUFence_Binding



namespace GPUOutOfMemoryError_Binding {

  typedef mozilla::webgpu::OutOfMemoryError NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::OutOfMemoryError* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUOutOfMemoryError,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUOutOfMemoryError,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUOutOfMemoryError_Binding



namespace GPUPipelineLayout_Binding {

  typedef mozilla::webgpu::PipelineLayout NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::PipelineLayout* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUPipelineLayout,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUPipelineLayout,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUPipelineLayout_Binding



namespace GPUQueue_Binding {

  typedef mozilla::webgpu::Queue NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Queue* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUQueue,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUQueue,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUQueue_Binding



namespace GPURenderBundle_Binding {

  typedef mozilla::webgpu::RenderBundle NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderBundle* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPURenderBundle,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderBundle,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPURenderBundle_Binding



namespace GPURenderBundleEncoder_Binding {

  typedef mozilla::webgpu::RenderBundleEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderBundleEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPURenderBundleEncoder,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderBundleEncoder,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPURenderBundleEncoder_Binding



namespace GPURenderPassEncoder_Binding {

  typedef mozilla::webgpu::RenderPassEncoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderPassEncoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPURenderPassEncoder,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderPassEncoder,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPURenderPassEncoder_Binding



namespace GPURenderPipeline_Binding {

  typedef mozilla::webgpu::RenderPipeline NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::RenderPipeline* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPURenderPipeline,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPURenderPipeline,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPURenderPipeline_Binding



namespace GPUSampler_Binding {

  typedef mozilla::webgpu::Sampler NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Sampler* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUSampler,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSampler,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUSampler_Binding



namespace GPUShaderModule_Binding {

  typedef mozilla::webgpu::ShaderModule NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ShaderModule* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUShaderModule,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUShaderModule,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUShaderModule_Binding



namespace GPUShaderStage_Binding {

  typedef mozilla::dom::GPUShaderStage NativeType;

  static const uint32_t NONE = 0;
  static const uint32_t VERTEX = 1;
  static const uint32_t FRAGMENT = 2;
  static const uint32_t COMPUTE = 4;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUShaderStage,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUShaderStage_Binding



namespace GPUSwapChain_Binding {

  typedef mozilla::webgpu::SwapChain NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::SwapChain* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUSwapChain,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUSwapChain,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUSwapChain_Binding



namespace GPUTexture_Binding {

  typedef mozilla::webgpu::Texture NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::Texture* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUTexture,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTexture,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUTexture_Binding



namespace GPUTextureUsage_Binding {

  typedef mozilla::dom::GPUTextureUsage NativeType;

  static const uint32_t NONE = 0;
  static const uint32_t COPY_SRC = 1;
  static const uint32_t COPY_DST = 2;
  static const uint32_t SAMPLED = 4;
  static const uint32_t STORAGE = 8;
  static const uint32_t OUTPUT_ATTACHMENT = 16;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTextureUsage,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUTextureUsage_Binding



namespace GPUTextureView_Binding {

  typedef mozilla::webgpu::TextureView NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::TextureView* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUTextureView,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUTextureView,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUTextureView_Binding



namespace GPUValidationError_Binding {

  typedef mozilla::webgpu::ValidationError NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::webgpu::ValidationError* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::GPUValidationError,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::GPUValidationError,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace GPUValidationError_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_WebGPUBinding_h
