/* THIS FILE IS AUTOGENERATED FROM SessionStoreUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_SessionStoreUtilsBinding_h
#define mozilla_dom_SessionStoreUtilsBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct CollectedDataAtoms;
struct CollectedFileListValueAtoms;
struct CollectedNonMultipleSelectValueAtoms;
struct InputElementData;
struct InputElementDataAtoms;
struct NativePropertyHooks;
class OwningStringOrBooleanOrObject;
class ProtoAndIfaceCache;
class SessionStoreUtils;
struct SessionStoreUtilsAtoms;
class SessionStoreUtilsFrameCallback;
class StringOrBooleanOrObject;
struct UpdateSessionStoreDataAtoms;
class WindowProxyHolder;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct CollectedData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<JSObject*>> mChildren;
  MOZ_INIT_OUTSIDE_CTOR Optional<Record<nsString, OwningStringOrBooleanOrObject>> mId;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mInnerHTML;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mScroll;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mUrl;
  MOZ_INIT_OUTSIDE_CTOR Optional<Record<nsString, OwningStringOrBooleanOrObject>> mXpath;

  CollectedData();

  explicit inline CollectedData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  CollectedData(const CollectedData&) = delete;
  CollectedData& operator=(const CollectedData&) = delete;

  static bool
  InitIds(JSContext* cx, CollectedDataAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastCollectedData : public CollectedData
{
  inline FastCollectedData()
    : CollectedData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CollectedFileListValue : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mFileList;
  MOZ_INIT_OUTSIDE_CTOR nsString mType;

  CollectedFileListValue();

  explicit inline CollectedFileListValue(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline CollectedFileListValue(const CollectedFileListValue& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  CollectedFileListValue&
  operator=(const CollectedFileListValue& aOther);

private:
  static bool
  InitIds(JSContext* cx, CollectedFileListValueAtoms* atomsCache);
};

namespace binding_detail {
struct FastCollectedFileListValue : public CollectedFileListValue
{
  inline FastCollectedFileListValue()
    : CollectedFileListValue(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CollectedNonMultipleSelectValue : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR int32_t mSelectedIndex;
  MOZ_INIT_OUTSIDE_CTOR nsString mValue;

  CollectedNonMultipleSelectValue();

  explicit inline CollectedNonMultipleSelectValue(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline CollectedNonMultipleSelectValue(const CollectedNonMultipleSelectValue& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  CollectedNonMultipleSelectValue&
  operator=(const CollectedNonMultipleSelectValue& aOther);

  bool
  operator==(const CollectedNonMultipleSelectValue& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, CollectedNonMultipleSelectValueAtoms* atomsCache);
};

namespace binding_detail {
struct FastCollectedNonMultipleSelectValue : public CollectedNonMultipleSelectValue
{
  inline FastCollectedNonMultipleSelectValue()
    : CollectedNonMultipleSelectValue(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct InputElementData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<bool>> mBoolVal;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mId;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mSelectVal;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<int32_t>> mSelectedIndex;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mStrVal;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mType;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<int32_t>> mValueIdx;

  InputElementData();

  explicit inline InputElementData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline InputElementData(const InputElementData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  InputElementData&
  operator=(const InputElementData& aOther);

private:
  static bool
  InitIds(JSContext* cx, InputElementDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastInputElementData : public InputElementData
{
  inline FastInputElementData()
    : InputElementData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class StringOrBooleanOrObject
{
  friend class StringOrBooleanOrObjectArgument;
  enum Type
  {
    eUninitialized,
    eString,
    eBoolean,
    eObject
  };

  union Value
  {
    UnionMember<binding_detail::FakeString<char16_t> > mString;
    UnionMember<bool > mBoolean;
    UnionMember<JS::Rooted<JSObject*> > mObject;

  };

  Type mType;
  Value mValue;

  StringOrBooleanOrObject(const StringOrBooleanOrObject&) = delete;
  StringOrBooleanOrObject& operator=(const StringOrBooleanOrObject&) = delete;
public:
  explicit inline StringOrBooleanOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~StringOrBooleanOrObject()
  {
    Uninit();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType != eObject, "This will not play well with Rooted");
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JS::Rooted<JSObject*>&
  GetAsObject()
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject*
  GetAsObject() const
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eObject: {
        DestroyObject();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyObject()
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    mValue.mObject.Destroy();
    mType = eUninitialized;
  }
};


class OwningStringOrBooleanOrObject : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningStringOrBooleanOrObject& aUnion);
  enum Type
  {
    eUninitialized,
    eString,
    eBoolean,
    eObject
  };

  union Value
  {
    UnionMember<nsString > mString;
    UnionMember<bool > mBoolean;
    UnionMember<JSObject* > mObject;

  };

  Type mType;
  Value mValue;

  OwningStringOrBooleanOrObject(const OwningStringOrBooleanOrObject&) = delete;
  OwningStringOrBooleanOrObject& operator=(const OwningStringOrBooleanOrObject&) = delete;
public:
  explicit inline OwningStringOrBooleanOrObject()
    : mType(eUninitialized)
  {
  }

  inline ~OwningStringOrBooleanOrObject()
  {
    Uninit();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  JSObject*&
  RawSetAsObject();

  JSObject*&
  SetAsObject();

  inline bool
  SetToObject(BindingCallContext& cx, JSObject* obj, bool passedToJSImpl = false)
  {
    MOZ_ASSERT(mType == eUninitialized);
    mValue.mObject.SetValue(obj);
    mType = eObject;
    if (passedToJSImpl && !CallerSubsumes(obj)) {
      cx.ThrowErrorMessage<MSG_PERMISSION_DENIED_TO_PASS_ARG>("object branch of (DOMString or boolean or object)");
      return false;
    }
    return true;
  }

  inline bool
  IsObject() const
  {
    return mType == eObject;
  }

  inline JSObject*&
  GetAsObject()
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  inline JSObject* const &
  GetAsObject() const
  {
    MOZ_ASSERT(IsObject(), "Wrong type!");
    return mValue.mObject.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

private:
  void
  DestroyString();

  void
  DestroyBoolean();

  void
  DestroyObject();
};


struct UpdateSessionStoreData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mDocShellCaps;
  MOZ_INIT_OUTSIDE_CTOR Optional<InputElementData> mId;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mInnerHTML;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<int32_t>> mInputDescendants;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mIsFullStorage;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mIsPrivate;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<int32_t>> mNumId;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<int32_t>> mNumXPath;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<int32_t>> mPositionDescendants;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsCString>> mPositions;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mStorageKeys;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsCString>> mStorageOrigins;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mStorageValues;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsCString>> mUrl;
  MOZ_INIT_OUTSIDE_CTOR Optional<InputElementData> mXpath;

  UpdateSessionStoreData();

  explicit inline UpdateSessionStoreData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline UpdateSessionStoreData(const UpdateSessionStoreData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  UpdateSessionStoreData&
  operator=(const UpdateSessionStoreData& aOther);

private:
  static bool
  InitIds(JSContext* cx, UpdateSessionStoreDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastUpdateSessionStoreData : public UpdateSessionStoreData
{
  inline FastUpdateSessionStoreData()
    : UpdateSessionStoreData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class SessionStoreUtilsFrameCallback : public CallbackFunction
{
public:
  explicit inline SessionStoreUtilsFrameCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline SessionStoreUtilsFrameCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline SessionStoreUtilsFrameCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline SessionStoreUtilsFrameCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const WindowProxyHolder& frame, uint32_t index, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "SessionStoreUtilsFrameCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, frame, index, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const WindowProxyHolder& frame, uint32_t index, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "SessionStoreUtilsFrameCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, frame, index, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const WindowProxyHolder& frame, uint32_t index, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, frame, index, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const WindowProxyHolder& frame, uint32_t index, const char* aExecutionReason = nullptr)
  {
    return Call(frame, index, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const SessionStoreUtilsFrameCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const WindowProxyHolder& frame, uint32_t index, ErrorResult& aRv);
};


namespace binding_detail {
class FastSessionStoreUtilsFrameCallback : public SessionStoreUtilsFrameCallback
{
public:
  explicit inline FastSessionStoreUtilsFrameCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : SessionStoreUtilsFrameCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    SessionStoreUtilsFrameCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    SessionStoreUtilsFrameCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


namespace SessionStoreUtils_Binding {

  typedef mozilla::dom::SessionStoreUtils NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::SessionStoreUtils,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace SessionStoreUtils_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_SessionStoreUtilsBinding_h
