/* THIS FILE IS AUTOGENERATED FROM Request.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_RequestBinding_h
#define mozilla_dom_RequestBinding_h

#include "FetchBinding.h"
#include "FetchObserverBinding.h"
#include "GeckoProfiler.h"
#include "HeadersBinding.h"
#include "ReferrerPolicyBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/AbortSignal.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class AbortSignal;
class BlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString;
class ByteStringSequenceSequenceOrByteStringByteStringRecord;
struct NativePropertyHooks;
class ObserverCallback;
class OwningBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString;
class OwningByteStringSequenceSequenceOrByteStringByteStringRecord;
class OwningRequestOrUSVString;
class ProtoAndIfaceCache;
class Request;
struct RequestAtoms;
struct RequestInitAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class RequestDestination : uint8_t {
  _empty,
  Audio,
  Audioworklet,
  Document,
  Embed,
  Font,
  Image,
  Manifest,
  Object,
  Paintworklet,
  Report,
  Script,
  Sharedworker,
  Style,
  Track,
  Video,
  Worker,
  Xslt,
  EndGuard_
};

namespace RequestDestinationValues {
extern const EnumEntry strings[19];

static constexpr size_t Count = 18;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RequestDestination::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RequestDestination stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RequestDestinationValues

bool
ToJSValue(JSContext* aCx, RequestDestination aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestMode : uint8_t {
  Same_origin,
  No_cors,
  Cors,
  Navigate,
  EndGuard_
};

namespace RequestModeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RequestMode::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RequestMode stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RequestModeValues

bool
ToJSValue(JSContext* aCx, RequestMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestCredentials : uint8_t {
  Omit,
  Same_origin,
  Include,
  EndGuard_
};

namespace RequestCredentialsValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RequestCredentials::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RequestCredentials stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RequestCredentialsValues

bool
ToJSValue(JSContext* aCx, RequestCredentials aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestCache : uint8_t {
  Default,
  No_store,
  Reload,
  No_cache,
  Force_cache,
  Only_if_cached,
  EndGuard_
};

namespace RequestCacheValues {
extern const EnumEntry strings[7];

static constexpr size_t Count = 6;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RequestCache::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RequestCache stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RequestCacheValues

bool
ToJSValue(JSContext* aCx, RequestCache aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RequestRedirect : uint8_t {
  Follow,
  Error,
  Manual,
  EndGuard_
};

namespace RequestRedirectValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RequestRedirect::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RequestRedirect stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RequestRedirectValues

bool
ToJSValue(JSContext* aCx, RequestRedirect aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRequestOrUSVString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningRequestOrUSVString& aUnion);


struct RequestInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Nullable<OwningBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString >> mBody;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestCache> mCache;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestCredentials> mCredentials;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningByteStringSequenceSequenceOrByteStringByteStringRecord> mHeaders;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mIntegrity;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsCString> mMethod;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestMode> mMode;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mMozErrors;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningNonNull<ObserverCallback>> mObserve;
  MOZ_INIT_OUTSIDE_CTOR Optional<RequestRedirect> mRedirect;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mReferrer;
  MOZ_INIT_OUTSIDE_CTOR Optional<ReferrerPolicy> mReferrerPolicy;
  MOZ_INIT_OUTSIDE_CTOR Optional<RefPtr<mozilla::dom::AbortSignal>> mSignal;

  RequestInit();

  explicit inline RequestInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  RequestInit(const RequestInit&) = delete;
  RequestInit& operator=(const RequestInit&) = delete;

  static bool
  InitIds(JSContext* cx, RequestInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mBody, "mBody", aFlags);
    ImplCycleCollectionTraverse(aCallback, mObserve, "mObserve", aFlags);
    ImplCycleCollectionTraverse(aCallback, mSignal, "mSignal", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mBody);
    ImplCycleCollectionUnlink(mObserve);
    ImplCycleCollectionUnlink(mSignal);
  }
};

namespace binding_detail {
struct FastRequestInit : public RequestInit
{
  inline FastRequestInit()
    : RequestInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class RequestOrUSVString
{
  friend class RequestOrUSVStringArgument;
  enum Type
  {
    eUninitialized,
    eRequest,
    eUSVString
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::Request> > mRequest;
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;

  };

  Type mType;
  Value mValue;

  RequestOrUSVString(const RequestOrUSVString&) = delete;
  RequestOrUSVString& operator=(const RequestOrUSVString&) = delete;
public:
  explicit inline RequestOrUSVString()
    : mType(eUninitialized)
  {
  }

  inline ~RequestOrUSVString()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Request>&
  RawSetAsRequest()
  {
    if (mType == eRequest) {
      return mValue.mRequest.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRequest;
    return mValue.mRequest.SetValue();
  }

  inline NonNull<mozilla::dom::Request>&
  SetAsRequest()
  {
    if (mType == eRequest) {
      return mValue.mRequest.Value();
    }
    Uninit();
    mType = eRequest;
    return mValue.mRequest.SetValue();
  }

  inline bool
  IsRequest() const
  {
    return mType == eRequest;
  }

  inline NonNull<mozilla::dom::Request>&
  GetAsRequest()
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  inline mozilla::dom::Request&
  GetAsRequest() const
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRequest: {
        DestroyRequest();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyRequest()
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    mValue.mRequest.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }
};


class OwningRequestOrUSVString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningRequestOrUSVString& aUnion);
  enum Type
  {
    eUninitialized,
    eRequest,
    eUSVString
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Request> > mRequest;
    UnionMember<nsString > mUSVString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningRequestOrUSVString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningRequestOrUSVString(const OwningRequestOrUSVString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRequestOrUSVString()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Request>&
  RawSetAsRequest();

  OwningNonNull<mozilla::dom::Request>&
  SetAsRequest();

  bool
  TrySetToRequest(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRequest(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsRequest() const
  {
    return mType == eRequest;
  }

  inline OwningNonNull<mozilla::dom::Request>&
  GetAsRequest()
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  inline OwningNonNull<mozilla::dom::Request> const &
  GetAsRequest() const
  {
    MOZ_ASSERT(IsRequest(), "Wrong type!");
    return mValue.mRequest.Value();
  }

  nsString&
  RawSetAsUSVString();

  nsString&
  SetAsUSVString();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningRequestOrUSVString&
  operator=(const OwningRequestOrUSVString& aOther);

private:
  void
  DestroyRequest();

  void
  DestroyUSVString();
};


namespace Request_Binding {

  typedef mozilla::dom::Request NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Request* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Request,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Request,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace Request_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RequestBinding_h
