/* THIS FILE IS AUTOGENERATED FROM RTCConfiguration.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_RTCConfigurationBinding_h
#define mozilla_dom_RTCConfigurationBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/RTCCertificate.h"
#include "mozilla/dom/UnionTypes.h"

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class OwningStringOrStringSequence;
class ProtoAndIfaceCache;
class RTCCertificate;
struct RTCConfigurationAtoms;
struct RTCIceServer;
struct RTCIceServerAtoms;
class StringOrStringSequence;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class RTCIceCredentialType : uint8_t {
  Password,
  EndGuard_
};

namespace RTCIceCredentialTypeValues {
extern const EnumEntry strings[2];

static constexpr size_t Count = 1;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCIceCredentialType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RTCIceCredentialType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RTCIceCredentialTypeValues

bool
ToJSValue(JSContext* aCx, RTCIceCredentialType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCIceTransportPolicy : uint8_t {
  Relay,
  All,
  EndGuard_
};

namespace RTCIceTransportPolicyValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCIceTransportPolicy::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RTCIceTransportPolicy stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RTCIceTransportPolicyValues

bool
ToJSValue(JSContext* aCx, RTCIceTransportPolicy aArgument, JS::MutableHandle<JS::Value> aValue);


enum class RTCBundlePolicy : uint8_t {
  Balanced,
  Max_compat,
  Max_bundle,
  EndGuard_
};

namespace RTCBundlePolicyValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(RTCBundlePolicy::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(RTCBundlePolicy stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace RTCBundlePolicyValues

bool
ToJSValue(JSContext* aCx, RTCBundlePolicy aArgument, JS::MutableHandle<JS::Value> aValue);


struct RTCIceServer : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mCredential;
  MOZ_INIT_OUTSIDE_CTOR RTCIceCredentialType mCredentialType;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mUrl;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningStringOrStringSequence> mUrls;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mUsername;

  RTCIceServer();

  explicit inline RTCIceServer(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCIceServer(const RTCIceServer& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  RTCIceServer&
  operator=(const RTCIceServer& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCIceServerAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCIceServer : public RTCIceServer
{
  inline FastRTCIceServer()
    : RTCIceServer(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RTCConfiguration : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR RTCBundlePolicy mBundlePolicy;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningNonNull<mozilla::dom::RTCCertificate>>> mCertificates;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<RTCIceServer>> mIceServers;
  MOZ_INIT_OUTSIDE_CTOR RTCIceTransportPolicy mIceTransportPolicy;
  MOZ_INIT_OUTSIDE_CTOR nsString mPeerIdentity;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mSdpSemantics;

  RTCConfiguration();

  explicit inline RTCConfiguration(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline RTCConfiguration(const RTCConfiguration& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mCertificates, "mCertificates", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mCertificates);
  }

  RTCConfiguration&
  operator=(const RTCConfiguration& aOther);

private:
  static bool
  InitIds(JSContext* cx, RTCConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastRTCConfiguration : public RTCConfiguration
{
  inline FastRTCConfiguration()
    : RTCConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_RTCConfigurationBinding_h
