/* THIS FILE IS AUTOGENERATED FROM MediaKeySystemAccess.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MediaKeySystemAccessBinding_h
#define mozilla_dom_MediaKeySystemAccessBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

class MediaKeySystemAccess;
struct MediaKeySystemAccessAtoms;
struct MediaKeySystemConfigurationAtoms;
struct MediaKeySystemMediaCapability;
struct MediaKeySystemMediaCapabilityAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class MediaKeysRequirement : uint8_t {
  Required,
  Optional,
  Not_allowed,
  EndGuard_
};

namespace MediaKeysRequirementValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaKeysRequirement::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(MediaKeysRequirement stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace MediaKeysRequirementValues

bool
ToJSValue(JSContext* aCx, MediaKeysRequirement aArgument, JS::MutableHandle<JS::Value> aValue);


struct MediaKeySystemMediaCapability : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsString mContentType;
  MOZ_INIT_OUTSIDE_CTOR nsString mEncryptionScheme;
  MOZ_INIT_OUTSIDE_CTOR nsString mRobustness;

  MediaKeySystemMediaCapability();

  explicit inline MediaKeySystemMediaCapability(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MediaKeySystemMediaCapability(const MediaKeySystemMediaCapability& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MediaKeySystemMediaCapability&
  operator=(const MediaKeySystemMediaCapability& aOther);

  bool
  operator==(const MediaKeySystemMediaCapability& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MediaKeySystemMediaCapabilityAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaKeySystemMediaCapability : public MediaKeySystemMediaCapability
{
  inline FastMediaKeySystemMediaCapability()
    : MediaKeySystemMediaCapability(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MediaKeySystemConfiguration : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<MediaKeySystemMediaCapability> mAudioCapabilities;
  MOZ_INIT_OUTSIDE_CTOR MediaKeysRequirement mDistinctiveIdentifier;
  MOZ_INIT_OUTSIDE_CTOR Sequence<nsString> mInitDataTypes;
  MOZ_INIT_OUTSIDE_CTOR nsString mLabel;
  MOZ_INIT_OUTSIDE_CTOR MediaKeysRequirement mPersistentState;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<nsString>> mSessionTypes;
  MOZ_INIT_OUTSIDE_CTOR Sequence<MediaKeySystemMediaCapability> mVideoCapabilities;

  MediaKeySystemConfiguration();

  explicit inline MediaKeySystemConfiguration(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MediaKeySystemConfiguration(const MediaKeySystemConfiguration& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  MediaKeySystemConfiguration&
  operator=(const MediaKeySystemConfiguration& aOther);

private:
  static bool
  InitIds(JSContext* cx, MediaKeySystemConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaKeySystemConfiguration : public MediaKeySystemConfiguration
{
  inline FastMediaKeySystemConfiguration()
    : MediaKeySystemConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MediaKeySystemAccess_Binding {

  typedef mozilla::dom::MediaKeySystemAccess NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaKeySystemAccess* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaKeySystemAccess,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaKeySystemAccess,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MediaKeySystemAccess_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MediaKeySystemAccessBinding_h
