/* THIS FILE IS AUTOGENERATED FROM MediaCapabilities.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MediaCapabilitiesBinding_h
#define mozilla_dom_MediaCapabilitiesBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

struct AudioConfiguration;
struct AudioConfigurationAtoms;
class MediaCapabilities;
struct MediaCapabilitiesAtoms;
class MediaCapabilitiesInfo;
struct MediaCapabilitiesInfoAtoms;
struct MediaConfigurationAtoms;
struct MediaDecodingConfigurationAtoms;
struct MediaEncodingConfigurationAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct VideoConfiguration;
struct VideoConfigurationAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class MediaDecodingType : uint8_t {
  File,
  Media_source,
  EndGuard_
};

namespace MediaDecodingTypeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaDecodingType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(MediaDecodingType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace MediaDecodingTypeValues

bool
ToJSValue(JSContext* aCx, MediaDecodingType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class MediaEncodingType : uint8_t {
  Record,
  Transmission,
  EndGuard_
};

namespace MediaEncodingTypeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaEncodingType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(MediaEncodingType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace MediaEncodingTypeValues

bool
ToJSValue(JSContext* aCx, MediaEncodingType aArgument, JS::MutableHandle<JS::Value> aValue);


struct AudioConfiguration : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<uint64_t> mBitrate;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mChannels;
  MOZ_INIT_OUTSIDE_CTOR nsString mContentType;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mSamplerate;

  AudioConfiguration();

  explicit inline AudioConfiguration(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline AudioConfiguration(const AudioConfiguration& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  AudioConfiguration&
  operator=(const AudioConfiguration& aOther);

  bool
  operator==(const AudioConfiguration& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, AudioConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastAudioConfiguration : public AudioConfiguration
{
  inline FastAudioConfiguration()
    : AudioConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct VideoConfiguration : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint64_t mBitrate;
  MOZ_INIT_OUTSIDE_CTOR nsString mContentType;
  MOZ_INIT_OUTSIDE_CTOR nsString mFramerate;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mHeight;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mWidth;

  VideoConfiguration();

  explicit inline VideoConfiguration(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline VideoConfiguration(const VideoConfiguration& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  VideoConfiguration&
  operator=(const VideoConfiguration& aOther);

  bool
  operator==(const VideoConfiguration& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, VideoConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastVideoConfiguration : public VideoConfiguration
{
  inline FastVideoConfiguration()
    : VideoConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MediaConfiguration : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<AudioConfiguration> mAudio;
  MOZ_INIT_OUTSIDE_CTOR Optional<VideoConfiguration> mVideo;

  MediaConfiguration();

  explicit inline MediaConfiguration(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MediaConfiguration(const MediaConfiguration& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MediaConfiguration&
  operator=(const MediaConfiguration& aOther);

private:
  static bool
  InitIds(JSContext* cx, MediaConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaConfiguration : public MediaConfiguration
{
  inline FastMediaConfiguration()
    : MediaConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MediaDecodingConfiguration : public MediaConfiguration
{
  MOZ_INIT_OUTSIDE_CTOR MediaDecodingType mType;

  MediaDecodingConfiguration();

  explicit inline MediaDecodingConfiguration(const FastDictionaryInitializer& )
    : MediaConfiguration(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MediaDecodingConfiguration(const MediaDecodingConfiguration& aOther)
    : MediaConfiguration(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MediaDecodingConfiguration&
  operator=(const MediaDecodingConfiguration& aOther);

private:
  static bool
  InitIds(JSContext* cx, MediaDecodingConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaDecodingConfiguration : public MediaDecodingConfiguration
{
  inline FastMediaDecodingConfiguration()
    : MediaDecodingConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MediaEncodingConfiguration : public MediaConfiguration
{
  MOZ_INIT_OUTSIDE_CTOR MediaEncodingType mType;

  MediaEncodingConfiguration();

  explicit inline MediaEncodingConfiguration(const FastDictionaryInitializer& )
    : MediaConfiguration(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline MediaEncodingConfiguration(const MediaEncodingConfiguration& aOther)
    : MediaConfiguration(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MediaEncodingConfiguration&
  operator=(const MediaEncodingConfiguration& aOther);

private:
  static bool
  InitIds(JSContext* cx, MediaEncodingConfigurationAtoms* atomsCache);
};

namespace binding_detail {
struct FastMediaEncodingConfiguration : public MediaEncodingConfiguration
{
  inline FastMediaEncodingConfiguration()
    : MediaEncodingConfiguration(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MediaCapabilities_Binding {

  typedef mozilla::dom::MediaCapabilities NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaCapabilities* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaCapabilities,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaCapabilities,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MediaCapabilities_Binding



namespace MediaCapabilitiesInfo_Binding {

  typedef mozilla::dom::MediaCapabilitiesInfo NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaCapabilitiesInfo* aObject, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaCapabilitiesInfo,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaCapabilitiesInfo,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace MediaCapabilitiesInfo_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_MediaCapabilitiesBinding_h
