/* THIS FILE IS AUTOGENERATED FROM EventHandler.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_EventHandlerBinding_h
#define mozilla_dom_EventHandlerBinding_h

#include "GeckoProfiler.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Event;
class EventHandlerNonNull;
class EventOrString;
struct NativePropertyHooks;
class OnBeforeUnloadEventHandlerNonNull;
class OnErrorEventHandlerNonNull;
class OwningEventOrString;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningEventOrString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningEventOrString& aUnion);


class EventOrString
{
  friend class EventOrStringArgument;
  enum Type
  {
    eUninitialized,
    eEvent,
    eString
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::Event> > mEvent;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  Type mType;
  Value mValue;

  EventOrString(const EventOrString&) = delete;
  EventOrString& operator=(const EventOrString&) = delete;
public:
  explicit inline EventOrString()
    : mType(eUninitialized)
  {
  }

  inline ~EventOrString()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Event>&
  RawSetAsEvent()
  {
    if (mType == eEvent) {
      return mValue.mEvent.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eEvent;
    return mValue.mEvent.SetValue();
  }

  inline NonNull<mozilla::dom::Event>&
  SetAsEvent()
  {
    if (mType == eEvent) {
      return mValue.mEvent.Value();
    }
    Uninit();
    mType = eEvent;
    return mValue.mEvent.SetValue();
  }

  inline bool
  IsEvent() const
  {
    return mType == eEvent;
  }

  inline NonNull<mozilla::dom::Event>&
  GetAsEvent()
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline mozilla::dom::Event&
  GetAsEvent() const
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eEvent: {
        DestroyEvent();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyEvent()
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    mValue.mEvent.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningEventOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningEventOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eEvent,
    eString
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Event> > mEvent;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningEventOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningEventOrString(const OwningEventOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningEventOrString()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Event>&
  RawSetAsEvent();

  OwningNonNull<mozilla::dom::Event>&
  SetAsEvent();

  bool
  TrySetToEvent(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToEvent(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsEvent() const
  {
    return mType == eEvent;
  }

  inline OwningNonNull<mozilla::dom::Event>&
  GetAsEvent()
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline OwningNonNull<mozilla::dom::Event> const &
  GetAsEvent() const
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningEventOrString&
  operator=(const OwningEventOrString& aOther);

private:
  void
  DestroyEvent();

  void
  DestroyString();
};


class EventHandlerNonNull : public CallbackFunction
{
public:
  explicit inline EventHandlerNonNull(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline EventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline EventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  explicit inline EventHandlerNonNull(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, Event& event, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "EventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, event, aRetVal, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(Event& event, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "EventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, event, aRetVal, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, Event& event, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, event, aRetVal, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(Event& event, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(event, aRetVal, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const EventHandlerNonNull& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, Event& event, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv);
};


class OnBeforeUnloadEventHandlerNonNull : public CallbackFunction
{
public:
  explicit inline OnBeforeUnloadEventHandlerNonNull(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline OnBeforeUnloadEventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline OnBeforeUnloadEventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  explicit inline OnBeforeUnloadEventHandlerNonNull(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, Event& event, nsString& aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "OnBeforeUnloadEventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, event, aRetVal, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(Event& event, nsString& aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "OnBeforeUnloadEventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, event, aRetVal, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, Event& event, nsString& aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, event, aRetVal, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(Event& event, nsString& aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(event, aRetVal, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const OnBeforeUnloadEventHandlerNonNull& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, Event& event, nsString& aRetVal, ErrorResult& aRv);
};


class OnErrorEventHandlerNonNull : public CallbackFunction
{
public:
  explicit inline OnErrorEventHandlerNonNull(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
  }

  explicit inline OnErrorEventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  explicit inline OnErrorEventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
  }

  explicit inline OnErrorEventHandlerNonNull(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "OnErrorEventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, event, source, lineno, column, error, aRetVal, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "OnErrorEventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, event, source, lineno, column, error, aRetVal, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, event, source, lineno, column, error, aRetVal, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    return Call(event, source, lineno, column, error, aRetVal, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const OnErrorEventHandlerNonNull& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastEventHandlerNonNull : public EventHandlerNonNull
{
public:
  explicit inline FastEventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal)
    : EventHandlerNonNull(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    EventHandlerNonNull::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    EventHandlerNonNull::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastOnBeforeUnloadEventHandlerNonNull : public OnBeforeUnloadEventHandlerNonNull
{
public:
  explicit inline FastOnBeforeUnloadEventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal)
    : OnBeforeUnloadEventHandlerNonNull(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    OnBeforeUnloadEventHandlerNonNull::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    OnBeforeUnloadEventHandlerNonNull::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastOnErrorEventHandlerNonNull : public OnErrorEventHandlerNonNull
{
public:
  explicit inline FastOnErrorEventHandlerNonNull(JSObject* aCallback, JSObject* aCallbackGlobal)
    : OnErrorEventHandlerNonNull(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    OnErrorEventHandlerNonNull::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    OnErrorEventHandlerNonNull::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_EventHandlerBinding_h
