/* THIS FILE IS AUTOGENERATED FROM Element.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_ElementBinding_h
#define mozilla_dom_ElementBinding_h

#include "GeckoProfiler.h"
#include "ShadowRootBinding.h"
#include "WindowBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Element;
struct ElementAtoms;
struct FocusOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct ScrollIntoViewOptionsAtoms;
struct ShadowRootInitAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class ScrollLogicalPosition : uint8_t {
  Start,
  Center,
  End,
  Nearest,
  EndGuard_
};

namespace ScrollLogicalPositionValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(ScrollLogicalPosition::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(ScrollLogicalPosition stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace ScrollLogicalPositionValues

bool
ToJSValue(JSContext* aCx, ScrollLogicalPosition aArgument, JS::MutableHandle<JS::Value> aValue);


struct FocusOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mPreventScroll;

  FocusOptions();

  explicit inline FocusOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline FocusOptions(const FocusOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  FocusOptions&
  operator=(const FocusOptions& aOther);

  bool
  operator==(const FocusOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, FocusOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastFocusOptions : public FocusOptions
{
  inline FastFocusOptions()
    : FocusOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ScrollIntoViewOptions : public ScrollOptions
{
  MOZ_INIT_OUTSIDE_CTOR ScrollLogicalPosition mBlock;
  MOZ_INIT_OUTSIDE_CTOR ScrollLogicalPosition mInline;

  ScrollIntoViewOptions();

  explicit inline ScrollIntoViewOptions(const FastDictionaryInitializer& )
    : ScrollOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ScrollIntoViewOptions(const ScrollIntoViewOptions& aOther)
    : ScrollOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ScrollIntoViewOptions&
  operator=(const ScrollIntoViewOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ScrollIntoViewOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastScrollIntoViewOptions : public ScrollIntoViewOptions
{
  inline FastScrollIntoViewOptions()
    : ScrollIntoViewOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ShadowRootInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ShadowRootMode mMode;

  ShadowRootInit();

  explicit inline ShadowRootInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ShadowRootInit(const ShadowRootInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ShadowRootInit&
  operator=(const ShadowRootInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, ShadowRootInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastShadowRootInit : public ShadowRootInit
{
  inline FastShadowRootInit()
    : ShadowRootInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class BooleanOrScrollIntoViewOptions
{
  friend class BooleanOrScrollIntoViewOptionsArgument;
  enum Type
  {
    eUninitialized,
    eBoolean,
    eScrollIntoViewOptions
  };

  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<binding_detail::FastScrollIntoViewOptions > mScrollIntoViewOptions;

  };

  Type mType;
  Value mValue;

  BooleanOrScrollIntoViewOptions(const BooleanOrScrollIntoViewOptions&) = delete;
  BooleanOrScrollIntoViewOptions& operator=(const BooleanOrScrollIntoViewOptions&) = delete;
public:
  explicit inline BooleanOrScrollIntoViewOptions()
    : mType(eUninitialized)
  {
  }

  inline ~BooleanOrScrollIntoViewOptions()
  {
    Uninit();
  }

  inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline binding_detail::FastScrollIntoViewOptions&
  RawSetAsScrollIntoViewOptions()
  {
    if (mType == eScrollIntoViewOptions) {
      return mValue.mScrollIntoViewOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eScrollIntoViewOptions;
    return mValue.mScrollIntoViewOptions.SetValue();
  }

  inline binding_detail::FastScrollIntoViewOptions&
  SetAsScrollIntoViewOptions()
  {
    if (mType == eScrollIntoViewOptions) {
      return mValue.mScrollIntoViewOptions.Value();
    }
    Uninit();
    mType = eScrollIntoViewOptions;
    return mValue.mScrollIntoViewOptions.SetValue();
  }

  inline bool
  IsScrollIntoViewOptions() const
  {
    return mType == eScrollIntoViewOptions;
  }

  inline binding_detail::FastScrollIntoViewOptions&
  GetAsScrollIntoViewOptions()
  {
    MOZ_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  inline const ScrollIntoViewOptions&
  GetAsScrollIntoViewOptions() const
  {
    MOZ_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eScrollIntoViewOptions: {
        DestroyScrollIntoViewOptions();
        break;
      }
    }
  }

private:
  inline void
  DestroyBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyScrollIntoViewOptions()
  {
    MOZ_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    mValue.mScrollIntoViewOptions.Destroy();
    mType = eUninitialized;
  }
};


class OwningBooleanOrScrollIntoViewOptions : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningBooleanOrScrollIntoViewOptions& aUnion);
  enum Type
  {
    eUninitialized,
    eBoolean,
    eScrollIntoViewOptions
  };

  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<ScrollIntoViewOptions > mScrollIntoViewOptions;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningBooleanOrScrollIntoViewOptions()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningBooleanOrScrollIntoViewOptions(const OwningBooleanOrScrollIntoViewOptions& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningBooleanOrScrollIntoViewOptions()
  {
    Uninit();
  }

  bool&
  RawSetAsBoolean();

  bool&
  SetAsBoolean();

  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  ScrollIntoViewOptions&
  RawSetAsScrollIntoViewOptions();

  ScrollIntoViewOptions&
  SetAsScrollIntoViewOptions();

  bool
  TrySetToScrollIntoViewOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToScrollIntoViewOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsScrollIntoViewOptions() const
  {
    return mType == eScrollIntoViewOptions;
  }

  inline ScrollIntoViewOptions&
  GetAsScrollIntoViewOptions()
  {
    MOZ_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  inline ScrollIntoViewOptions const &
  GetAsScrollIntoViewOptions() const
  {
    MOZ_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningBooleanOrScrollIntoViewOptions&
  operator=(const OwningBooleanOrScrollIntoViewOptions& aOther);

private:
  void
  DestroyBoolean();

  void
  DestroyScrollIntoViewOptions();
};


namespace Element_Binding {

  typedef mozilla::dom::Element NativeType;

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Element* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Element,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Element,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace Element_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ElementBinding_h
