/* THIS FILE IS AUTOGENERATED FROM Document.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_DocumentBinding_h
#define mozilla_dom_DocumentBinding_h

#include "GeckoProfiler.h"
#include "ReferrerPolicyBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct BlockParsingOptionsAtoms;
class Document;
struct DocumentAtoms;
struct ElementCreationOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class VisibilityState : uint8_t {
  Hidden,
  Visible,
  EndGuard_
};

namespace VisibilityStateValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(VisibilityState::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(VisibilityState stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace VisibilityStateValues

bool
ToJSValue(JSContext* aCx, VisibilityState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class DocumentAutoplayPolicy : uint8_t {
  Allowed,
  Allowed_muted,
  Disallowed,
  EndGuard_
};

namespace DocumentAutoplayPolicyValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(DocumentAutoplayPolicy::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(DocumentAutoplayPolicy stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace DocumentAutoplayPolicyValues

bool
ToJSValue(JSContext* aCx, DocumentAutoplayPolicy aArgument, JS::MutableHandle<JS::Value> aValue);


enum class FlashClassification : uint8_t {
  Unknown,
  Allowed,
  Denied,
  EndGuard_
};

namespace FlashClassificationValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(FlashClassification::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline Span<const char> GetString(FlashClassification stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return MakeSpan(entry.value, entry.length);
}
} // namespace FlashClassificationValues

bool
ToJSValue(JSContext* aCx, FlashClassification aArgument, JS::MutableHandle<JS::Value> aValue);


struct BlockParsingOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mBlockScriptCreated;

  BlockParsingOptions();

  explicit inline BlockParsingOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline BlockParsingOptions(const BlockParsingOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  BlockParsingOptions&
  operator=(const BlockParsingOptions& aOther);

  bool
  operator==(const BlockParsingOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, BlockParsingOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBlockParsingOptions : public BlockParsingOptions
{
  inline FastBlockParsingOptions()
    : BlockParsingOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ElementCreationOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mIs;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPseudo;

  ElementCreationOptions();

  explicit inline ElementCreationOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ElementCreationOptions(const ElementCreationOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ElementCreationOptions&
  operator=(const ElementCreationOptions& aOther);

  bool
  operator==(const ElementCreationOptions& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, ElementCreationOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastElementCreationOptions : public ElementCreationOptions
{
  inline FastElementCreationOptions()
    : ElementCreationOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ElementCreationOptionsOrString
{
  friend class ElementCreationOptionsOrStringArgument;
  enum Type
  {
    eUninitialized,
    eElementCreationOptions,
    eString
  };

  union Value
  {
    UnionMember<binding_detail::FastElementCreationOptions > mElementCreationOptions;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  Type mType;
  Value mValue;

  ElementCreationOptionsOrString(const ElementCreationOptionsOrString&) = delete;
  ElementCreationOptionsOrString& operator=(const ElementCreationOptionsOrString&) = delete;
public:
  explicit inline ElementCreationOptionsOrString()
    : mType(eUninitialized)
  {
  }

  inline ~ElementCreationOptionsOrString()
  {
    Uninit();
  }

  inline binding_detail::FastElementCreationOptions&
  RawSetAsElementCreationOptions()
  {
    if (mType == eElementCreationOptions) {
      return mValue.mElementCreationOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElementCreationOptions;
    return mValue.mElementCreationOptions.SetValue();
  }

  inline binding_detail::FastElementCreationOptions&
  SetAsElementCreationOptions()
  {
    if (mType == eElementCreationOptions) {
      return mValue.mElementCreationOptions.Value();
    }
    Uninit();
    mType = eElementCreationOptions;
    return mValue.mElementCreationOptions.SetValue();
  }

  inline bool
  IsElementCreationOptions() const
  {
    return mType == eElementCreationOptions;
  }

  inline binding_detail::FastElementCreationOptions&
  GetAsElementCreationOptions()
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline const ElementCreationOptions&
  GetAsElementCreationOptions() const
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eElementCreationOptions: {
        DestroyElementCreationOptions();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

private:
  inline void
  DestroyElementCreationOptions()
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    mValue.mElementCreationOptions.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningElementCreationOptionsOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningElementCreationOptionsOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eElementCreationOptions,
    eString
  };

  union Value
  {
    UnionMember<ElementCreationOptions > mElementCreationOptions;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningElementCreationOptionsOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningElementCreationOptionsOrString(const OwningElementCreationOptionsOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningElementCreationOptionsOrString()
  {
    Uninit();
  }

  ElementCreationOptions&
  RawSetAsElementCreationOptions();

  ElementCreationOptions&
  SetAsElementCreationOptions();

  bool
  TrySetToElementCreationOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElementCreationOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsElementCreationOptions() const
  {
    return mType == eElementCreationOptions;
  }

  inline ElementCreationOptions&
  GetAsElementCreationOptions()
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline ElementCreationOptions const &
  GetAsElementCreationOptions() const
  {
    MOZ_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  void
  TraceUnion(JSTracer* trc);

  OwningElementCreationOptionsOrString&
  operator=(const OwningElementCreationOptionsOrString& aOther);

private:
  void
  DestroyElementCreationOptions();

  void
  DestroyString();
};


namespace Document_Binding {

  typedef mozilla::dom::Document NativeType;

  static const uint16_t KEYPRESS_EVENT_MODEL_DEFAULT = 0;
  static const uint16_t KEYPRESS_EVENT_MODEL_SPLIT = 1;
  static const uint16_t KEYPRESS_EVENT_MODEL_CONFLATED = 2;
  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Document* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  ClearCachedAdoptedStyleSheetsValue(mozilla::dom::Document* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Document,
                                       &CreateInterfaceObjects,
                                       /* aDefineOnGlobal = */ true);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Document,
                                       &CreateInterfaceObjects,
                                       aDefineOnGlobal);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace Document_Binding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_DocumentBinding_h
